/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.table;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.filter.AbstractFileFilter;
import com.mucommander.commons.file.filter.FileFilter;
import com.mucommander.commons.file.filter.OrFileFilter;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.ui.event.LocationEvent;
import com.mucommander.ui.event.LocationListener;
import com.mucommander.ui.main.FolderPanel;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderChangeMonitor
implements LocationListener,
WindowListener,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FolderChangeMonitor.class);
    private FolderPanel folderPanel;
    private AbstractFile currentFolder;
    private boolean folderChanging;
    private long currentFolderDate;
    private boolean paused;
    private long waitBeforeCheckTime;
    private long lastCheckTimestamp;
    private long totalCheckTime = 0L;
    private int nbSamples = 0;
    private static Thread monitorThread;
    private static List<FolderChangeMonitor> instances;
    private static OrFileFilter disableAutoRefreshFilter;
    private static long checkPeriod;
    private static long waitAfterRefresh;

    public FolderChangeMonitor(FolderPanel folderPanel) {
        this.folderPanel = folderPanel;
        folderPanel.getLocationManager().addLocationListener(this);
        this.currentFolder = folderPanel.getCurrentFolder();
        this.currentFolderDate = this.currentFolder.getDate();
        this.lastCheckTimestamp = System.currentTimeMillis();
        this.waitBeforeCheckTime = waitAfterRefresh;
        folderPanel.getMainFrame().addWindowListener(this);
        instances.add(this);
        if (monitorThread == null && checkPeriod >= 0L) {
            monitorThread = new Thread((Runnable)this, this.getClass().getName());
            monitorThread.setDaemon(true);
            monitorThread.start();
        }
    }

    public void run() {
        while (monitorThread != null) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            int nbInstances = instances.size();
            for (int i = 0; i < nbInstances; ++i) {
                FolderChangeMonitor monitor;
                try {
                    monitor = instances.get(i);
                }
                catch (Exception e) {
                    continue;
                }
                if (!monitor.folderPanel.getMainFrame().isForegroundActive() || this.folderChanging || monitor.paused || System.currentTimeMillis() - Math.max(monitor.lastCheckTimestamp, monitor.folderPanel.getLastFolderChangeTime()) <= monitor.waitBeforeCheckTime) continue;
                boolean folderRefreshed = monitor.checkAndRefresh();
                monitor.lastCheckTimestamp = System.currentTimeMillis();
                monitor.waitBeforeCheckTime = monitor.nbSamples == 0 ? checkPeriod : Math.max(folderRefreshed ? waitAfterRefresh : checkPeriod, (long)((int)(50.0f * ((float)monitor.totalCheckTime / (float)monitor.nbSamples))));
            }
        }
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
        if (!paused) {
            this.waitBeforeCheckTime = 0L;
        }
    }

    private void updateFolderInfo(AbstractFile folder) {
        this.currentFolder = folder;
        this.currentFolderDate = this.currentFolder.getDate();
        this.totalCheckTime = 0L;
        this.nbSamples = 0;
    }

    private synchronized boolean checkAndRefresh() {
        if (this.paused || disableAutoRefreshFilter.match(this.currentFolder)) {
            return false;
        }
        long timeStamp = System.currentTimeMillis();
        long date = this.currentFolder.getDate();
        this.totalCheckTime += System.currentTimeMillis() - timeStamp;
        ++this.nbSamples;
        if (date != this.currentFolderDate) {
            LOGGER.debug(this + " (" + this.currentFolder.getName() + ") Detected changes in current folder, refreshing table!");
            this.folderPanel.tryRefreshCurrentFolder();
        }
        return false;
    }

    public void locationChanging(LocationEvent locationEvent) {
        this.folderChanging = true;
    }

    public void locationChanged(LocationEvent locationEvent) {
        this.updateFolderInfo(locationEvent.getFolderPanel().getCurrentFolder());
        this.folderChanging = false;
    }

    public void locationCancelled(LocationEvent locationEvent) {
        this.folderChanging = false;
    }

    public void locationFailed(LocationEvent locationEvent) {
        this.folderChanging = false;
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        instances.remove(this);
        LOGGER.debug("nbInstances=" + instances.size());
    }

    static {
        disableAutoRefreshFilter = new OrFileFilter(new FileFilter[0]);
        instances = new Vector<FolderChangeMonitor>();
        checkPeriod = MuConfigurations.getPreferences().getVariable(MuPreference.REFRESH_CHECK_PERIOD, 3000L);
        waitAfterRefresh = MuConfigurations.getPreferences().getVariable(MuPreference.WAIT_AFTER_REFRESH, 10000L);
        disableAutoRefreshFilter.addFileFilter(new AbstractFileFilter(){

            public boolean accept(AbstractFile file) {
                return file.getURL().getScheme().equals("s3");
            }
        });
    }
}

