/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.table;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.filter.FileFilter;
import com.mucommander.commons.file.impl.CachedFile;
import com.mucommander.commons.file.util.FileComparator;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.text.CustomDateFormat;
import com.mucommander.text.SizeFormat;
import com.mucommander.ui.main.table.Column;
import com.mucommander.ui.main.table.SortInfo;
import java.util.Date;
import javax.swing.table.AbstractTableModel;

public class FileTableModel
extends AbstractTableModel {
    private AbstractFile currentFolder;
    private long currentFolderDateSnapshot;
    private AbstractFile parent;
    private AbstractFile[] cachedFiles = new AbstractFile[0];
    private int[] fileArrayIndex = new int[0];
    private Object[][] cellValuesCache = new Object[0][Column.values().length - 1];
    private boolean[] rowMarked = new boolean[0];
    private long markedTotalSize;
    private int nbRowsMarked;
    private SortInfo sortInfo;
    private boolean nameColumnEditable;
    private static int sizeFormat;

    static void setSizeFormat(boolean compactSize) {
        sizeFormat = compactSize ? 138 : 4;
        sizeFormat |= 0x40;
    }

    void setSortInfo(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    public synchronized AbstractFile getCurrentFolder() {
        return this.currentFolder;
    }

    public synchronized boolean hasParentFolder() {
        return this.parent != null;
    }

    public synchronized AbstractFile getParentFolder() {
        return this.parent;
    }

    public int getFirstMarkableRow() {
        return this.parent == null ? 0 : 1;
    }

    synchronized void setCurrentFolder(AbstractFile folder, AbstractFile[] children) {
        int nbFiles = children.length;
        this.currentFolder = folder instanceof CachedFile ? folder : new CachedFile(folder, true);
        this.parent = this.currentFolder.getParent();
        if (this.parent != null) {
            FileTableModel.prefetchCachedFileAttributes(this.parent);
        }
        this.cachedFiles = children;
        this.fileArrayIndex = new int[nbFiles];
        for (int i = 0; i < nbFiles; ++i) {
            CachedFile file = new CachedFile(children[i], true);
            FileTableModel.prefetchCachedFileAttributes(file);
            this.cachedFiles[i] = file;
            this.fileArrayIndex[i] = i;
        }
        int nbRows = this.getRowCount();
        this.rowMarked = new boolean[nbRows];
        this.markedTotalSize = 0L;
        this.nbRowsMarked = 0;
        this.cellValuesCache = new Object[nbRows][Column.values().length - 1];
        this.fillCellCache();
    }

    private static void prefetchCachedFileAttributes(AbstractFile cachedFile) {
        AbstractFile canonicalFile;
        cachedFile.isDirectory();
        cachedFile.isBrowsable();
        cachedFile.isHidden();
        if (cachedFile.isSymlink() && (canonicalFile = cachedFile.getCanonicalFile()) != cachedFile) {
            FileTableModel.prefetchCachedFileAttributes(canonicalFile);
        }
    }

    synchronized void fillCellCache() {
        int i;
        int len = this.cellValuesCache.length;
        if (len == 0) {
            return;
        }
        if (this.parent != null) {
            this.cellValuesCache[0][Column.NAME.ordinal() - 1] = "..";
            this.cellValuesCache[0][Column.SIZE.ordinal() - 1] = "<DIR>";
            this.currentFolderDateSnapshot = this.currentFolder.getDate();
            this.cellValuesCache[0][Column.DATE.ordinal() - 1] = CustomDateFormat.format(new Date(this.currentFolderDateSnapshot));
            this.cellValuesCache[0][Column.PERMISSIONS.ordinal() - 1] = "";
            this.cellValuesCache[0][Column.OWNER.ordinal() - 1] = "";
            this.cellValuesCache[0][Column.GROUP.ordinal() - 1] = "";
        }
        int fileIndex = 0;
        int n = i = this.parent == null ? 0 : 1;
        while (i < len) {
            AbstractFile file = this.getCachedFileAtRow(i);
            int cellIndex = this.fileArrayIndex[fileIndex] + (this.parent == null ? 0 : 1);
            this.cellValuesCache[cellIndex][Column.NAME.ordinal() - 1] = file.getName();
            this.cellValuesCache[cellIndex][Column.SIZE.ordinal() - 1] = file.isDirectory() ? "<DIR>" : SizeFormat.format(file.getSize(), sizeFormat);
            this.cellValuesCache[cellIndex][Column.DATE.ordinal() - 1] = CustomDateFormat.format(new Date(file.getDate()));
            this.cellValuesCache[cellIndex][Column.PERMISSIONS.ordinal() - 1] = file.getPermissionsString();
            this.cellValuesCache[cellIndex][Column.OWNER.ordinal() - 1] = file.getOwner();
            this.cellValuesCache[cellIndex][Column.GROUP.ordinal() - 1] = file.getGroup();
            ++fileIndex;
            ++i;
        }
    }

    public synchronized AbstractFile getCachedFileAtRow(int rowIndex) {
        if (rowIndex == 0 && this.parent != null) {
            return this.parent;
        }
        if (this.parent != null) {
            --rowIndex;
        }
        if (rowIndex >= 0 && rowIndex < this.fileArrayIndex.length) {
            return this.cachedFiles[this.fileArrayIndex[rowIndex]];
        }
        return null;
    }

    public synchronized AbstractFile getFileAtRow(int rowIndex) {
        AbstractFile file = this.getCachedFileAtRow(rowIndex);
        if (file == null) {
            return null;
        }
        if (file instanceof CachedFile) {
            return ((CachedFile)file).getProxiedFile();
        }
        return file;
    }

    public synchronized int getFileRow(AbstractFile file) {
        if (this.parent != null && file.equals(this.parent)) {
            return 0;
        }
        int left = this.parent == null ? 0 : 1;
        int right = this.getRowCount() - 1;
        FileComparator fc = FileTableModel.getFileComparator(this.sortInfo);
        while (left <= right) {
            int mid = (right - left) / 2 + left;
            AbstractFile midFile = this.getCachedFileAtRow(mid);
            if (midFile.equals(file)) {
                return mid;
            }
            if (fc.compare(file, midFile) < 0) {
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return -1;
    }

    public synchronized AbstractFile getFileAt(int fileIndex) {
        if (fileIndex >= 0 && fileIndex < this.fileArrayIndex.length) {
            return ((CachedFile)this.cachedFiles[this.fileArrayIndex[fileIndex]]).getProxiedFile();
        }
        return null;
    }

    public synchronized int getFileCount() {
        return this.cachedFiles.length;
    }

    public synchronized boolean isRowMarked(int row) {
        if (row == 0 && this.parent != null) {
            return false;
        }
        return row < this.getRowCount() && this.rowMarked[this.fileArrayIndex[this.parent == null ? row : row - 1]];
    }

    public synchronized void setRowMarked(int row, boolean marked) {
        long fileSize;
        int rowIndex;
        if (row == 0 && this.parent != null) {
            return;
        }
        int n = rowIndex = this.parent == null ? row : row - 1;
        if (marked && this.rowMarked[this.fileArrayIndex[rowIndex]] || !marked && !this.rowMarked[this.fileArrayIndex[rowIndex]]) {
            return;
        }
        AbstractFile file = this.getCachedFileAtRow(row);
        long l = fileSize = file.isDirectory() ? 0L : file.getSize();
        if (marked) {
            if (fileSize > 0L) {
                this.markedTotalSize += fileSize;
            }
            ++this.nbRowsMarked;
        } else {
            if (fileSize > 0L) {
                this.markedTotalSize -= fileSize;
            }
            --this.nbRowsMarked;
        }
        this.rowMarked[this.fileArrayIndex[rowIndex]] = marked;
    }

    public void setRangeMarked(int startRow, int endRow, boolean marked) {
        if (endRow >= startRow) {
            for (int i = startRow; i <= endRow; ++i) {
                this.setRowMarked(i, marked);
            }
        } else {
            for (int i = startRow; i >= endRow; --i) {
                this.setRowMarked(i, marked);
            }
        }
    }

    public synchronized void setFileMarked(AbstractFile file, boolean marked) {
        int row = this.getFileRow(file);
        if (row != -1) {
            this.setRowMarked(row, marked);
        }
    }

    public synchronized void setFilesMarked(FileFilter filter, boolean marked) {
        int i;
        int nbFiles = this.getRowCount();
        int n = i = this.parent == null ? 0 : 1;
        while (i < nbFiles) {
            if (filter.match(this.getCachedFileAtRow(i))) {
                this.setRowMarked(i, marked);
            }
            ++i;
        }
    }

    public synchronized FileSet getMarkedFiles() {
        FileSet markedFiles = new FileSet(this.currentFolder, this.nbRowsMarked);
        int nbRows = this.getRowCount();
        if (this.parent == null) {
            for (int i = 0; i < nbRows; ++i) {
                if (!this.rowMarked[this.fileArrayIndex[i]]) continue;
                markedFiles.add(this.getFileAtRow(i));
            }
        } else {
            int i = 1;
            int iMinusOne = 0;
            while (i < nbRows) {
                if (this.rowMarked[this.fileArrayIndex[iMinusOne]]) {
                    markedFiles.add(this.getFileAtRow(i));
                }
                iMinusOne = i++;
            }
        }
        return markedFiles;
    }

    public int getNbMarkedFiles() {
        return this.nbRowsMarked;
    }

    public long getTotalMarkedSize() {
        return this.markedTotalSize;
    }

    void setNameColumnEditable(boolean editable) {
        this.nameColumnEditable = editable;
    }

    private static FileComparator getFileComparator(SortInfo sortInfo) {
        return new FileComparator(sortInfo.getCriterion().getFileComparatorCriterion(), sortInfo.getAscendingOrder(), sortInfo.getFoldersFirst());
    }

    synchronized void sortRows() {
        this.sort(FileTableModel.getFileComparator(this.sortInfo), 0, this.fileArrayIndex.length - 1);
    }

    private void sort(FileComparator fc, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (lo >= hi) {
            return;
        }
        if (lo == hi - 1) {
            if (fc.compare(this.cachedFiles[this.fileArrayIndex[lo]], this.cachedFiles[this.fileArrayIndex[hi]]) > 0) {
                int temp = this.fileArrayIndex[lo];
                this.fileArrayIndex[lo] = this.fileArrayIndex[hi];
                this.fileArrayIndex[hi] = temp;
            }
            return;
        }
        int pivotIndex = this.fileArrayIndex[(lo + hi) / 2];
        this.fileArrayIndex[(lo + hi) / 2] = this.fileArrayIndex[hi];
        this.fileArrayIndex[hi] = pivotIndex;
        AbstractFile pivot = this.cachedFiles[pivotIndex];
        while (lo < hi) {
            while (fc.compare(this.cachedFiles[this.fileArrayIndex[lo]], pivot) <= 0 && lo < hi) {
                ++lo;
            }
            while (fc.compare(pivot, this.cachedFiles[this.fileArrayIndex[hi]]) <= 0 && lo < hi) {
                --hi;
            }
            if (lo >= hi) continue;
            int temp = this.fileArrayIndex[lo];
            this.fileArrayIndex[lo] = this.fileArrayIndex[hi];
            this.fileArrayIndex[hi] = temp;
        }
        this.fileArrayIndex[hi0] = this.fileArrayIndex[hi];
        this.fileArrayIndex[hi] = pivotIndex;
        this.sort(fc, lo0, lo - 1);
        this.sort(fc, hi + 1, hi0);
    }

    public int getColumnCount() {
        return Column.values().length;
    }

    public String getColumnName(int columnIndex) {
        return Column.valueOf(columnIndex).getLabel();
    }

    public synchronized int getRowCount() {
        return this.fileArrayIndex.length + (this.parent == null ? 0 : 1);
    }

    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount()) {
            return null;
        }
        Column column = Column.valueOf(columnIndex);
        if (column == Column.EXTENSION) {
            return null;
        }
        --columnIndex;
        if (rowIndex == 0 && this.parent != null) {
            return this.cellValuesCache[0][columnIndex];
        }
        int fileIndex = this.parent == null ? rowIndex : rowIndex - 1;
        return this.cellValuesCache[this.fileArrayIndex[fileIndex] + (this.parent == null ? 0 : 1)][columnIndex];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (Column.valueOf(columnIndex) == Column.NAME && (this.parent == null || rowIndex != 0)) {
            return this.nameColumnEditable;
        }
        return false;
    }

    static {
        FileTableModel.setSizeFormat(MuConfigurations.getPreferences().getVariable(MuPreference.DISPLAY_COMPACT_FILE_SIZE, true));
    }
}

