/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.table;

import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.main.table.Column;
import com.mucommander.ui.main.table.FileTable;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class FileTableHeaderRenderer
extends DefaultTableCellRenderer {
    private static final ImageIcon ASCENDING_ICON = IconManager.getIcon(3, "arrow_up.png");
    private static final ImageIcon DESCENDING_ICON = IconManager.getIcon(3, "arrow_down.png");

    public FileTableHeaderRenderer() {
        this.setHorizontalTextPosition(2);
        this.setIconTextGap(6);
        this.setHorizontalAlignment(0);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (table != null) {
            FileTable fileTable;
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                label.setForeground(header.getForeground());
                label.setBackground(header.getBackground());
                label.setFont(header.getFont());
            }
            if ((fileTable = (FileTable)table).getSortInfo().getCriterion() == Column.valueOf(fileTable.convertColumnIndexToModel(column))) {
                label.setIcon(fileTable.getSortInfo().getAscendingOrder() ? ASCENDING_ICON : DESCENDING_ICON);
            } else {
                label.setIcon(null);
            }
        }
        Border border = UIManager.getBorder("TableHeader.cellBorder");
        label.setBorder(border);
        label.setToolTipText((String)value);
        return label;
    }
}

