/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.table;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.ui.icon.FileIcons;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.main.table.CellLabel;
import com.mucommander.ui.main.table.Column;
import com.mucommander.ui.main.table.FileTable;
import com.mucommander.ui.main.table.FileTableModel;
import com.mucommander.ui.quicksearch.QuickSearch;
import com.mucommander.ui.theme.ColorChangedEvent;
import com.mucommander.ui.theme.FontChangedEvent;
import com.mucommander.ui.theme.ThemeCache;
import com.mucommander.ui.theme.ThemeListener;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTableCellRenderer
implements ThemeListener,
TableCellRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTableCellRenderer.class);
    private FileTable table;
    private FileTableModel tableModel;
    private CellLabel[] cellLabels = new CellLabel[Column.values().length];

    public FileTableCellRenderer(FileTable table) {
        this.table = table;
        this.tableModel = table.getFileTableModel();
        for (Column c : Column.values()) {
            this.cellLabels[c.ordinal()] = new CellLabel();
        }
        this.setCellLabelsFont(ThemeCache.tableFont);
        this.cellLabels[Column.EXTENSION.ordinal()].setHorizontalAlignment(0);
        this.cellLabels[Column.NAME.ordinal()].setHorizontalAlignment(2);
        this.cellLabels[Column.SIZE.ordinal()].setHorizontalAlignment(4);
        this.cellLabels[Column.DATE.ordinal()].setHorizontalAlignment(4);
        this.cellLabels[Column.PERMISSIONS.ordinal()].setHorizontalAlignment(2);
        this.cellLabels[Column.OWNER.ordinal()].setHorizontalAlignment(2);
        this.cellLabels[Column.GROUP.ordinal()].setHorizontalAlignment(2);
        ThemeCache.addThemeListener(this);
    }

    public static Font getCellFont() {
        return ThemeCache.tableFont;
    }

    private void setCellLabelsFont(Font newFont) {
        for (Column c : Column.values()) {
            if (c == Column.EXTENSION) continue;
            this.cellLabels[c.ordinal()].setFont(newFont);
        }
    }

    private static int getColorIndex(int row, AbstractFile file, FileTableModel tableModel) {
        if (row == 0 && tableModel.hasParentFolder()) {
            return 1;
        }
        if (tableModel.isRowMarked(row)) {
            return 4;
        }
        if (file.isSymlink()) {
            return 3;
        }
        if (file.isHidden()) {
            return 0;
        }
        if (file.isDirectory()) {
            return 1;
        }
        if (file.isBrowsable()) {
            return 2;
        }
        return 5;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.tableModel.getRowCount()) {
            return null;
        }
        AbstractFile file = this.tableModel.getCachedFileAtRow(rowIndex);
        if (file == null) {
            LOGGER.debug("tableModel.getCachedFileAtRow(" + rowIndex + ") RETURNED NULL !");
            return null;
        }
        QuickSearch<AbstractFile> search = this.table.getQuickSearch();
        boolean matches = !table.hasFocus() ? true : (search.isActive() ? search.matches(this.table.getFileNameAtRow(rowIndex)) : true);
        int selectedIndex = isSelected && ((FileTable)table).isActiveTable() ? 1 : 0;
        int focusedIndex = table.hasFocus() ? 1 : 0;
        int colorIndex = FileTableCellRenderer.getColorIndex(rowIndex, file, this.tableModel);
        Column column = Column.valueOf(table.convertColumnIndexToModel(columnIndex));
        CellLabel label = this.cellLabels[column.ordinal()];
        if (column == Column.EXTENSION) {
            label.setIcon(rowIndex == 0 && this.tableModel.hasParentFolder() ? IconManager.getIcon(0, "parent.png", FileIcons.getScaleFactor()) : FileIcons.getFileIcon(file));
        } else {
            String text = (String)value;
            if (matches || isSelected) {
                label.setForeground(ThemeCache.foregroundColors[focusedIndex][selectedIndex][colorIndex]);
            } else {
                label.setForeground(ThemeCache.unmatchedForeground);
            }
            label.setText(text);
            if ((double)table.getColumnModel().getColumn(columnIndex).getWidth() < label.getPreferredSize().getWidth()) {
                String leftText = text.substring(0, text.length() / 2);
                String rightText = text.substring(text.length() / 2, text.length());
                while ((double)table.getColumnModel().getColumn(columnIndex).getWidth() < label.getPreferredSize().getWidth() && leftText.length() > 0 && rightText.length() > 0) {
                    if (leftText.length() > rightText.length()) {
                        leftText = leftText.substring(0, leftText.length() - 1);
                    } else {
                        rightText = rightText.substring(1, rightText.length());
                    }
                    label.setText(leftText + "..." + rightText);
                }
                label.setToolTipText(text);
            } else {
                label.setToolTipText(null);
            }
        }
        if (selectedIndex == 1) {
            label.setBackground(ThemeCache.backgroundColors[focusedIndex][1], ThemeCache.backgroundColors[focusedIndex][3]);
        } else if (matches) {
            if (table.hasFocus() && search.isActive()) {
                label.setBackground(ThemeCache.backgroundColors[focusedIndex][0]);
            } else {
                label.setBackground(ThemeCache.backgroundColors[focusedIndex][rowIndex % 2 == 0 ? 0 : 2]);
            }
        } else {
            label.setBackground(ThemeCache.unmatchedBackground);
        }
        if (selectedIndex == 1) {
            label.setOutline(table.hasFocus() ? ThemeCache.activeOutlineColor : ThemeCache.inactiveOutlineColor);
        } else {
            label.setOutline(null);
        }
        return label;
    }

    public void colorChanged(ColorChangedEvent event) {
        this.table.repaint();
    }

    public void fontChanged(FontChangedEvent event) {
        if (event.getFontId() == 0) {
            this.setCellLabelsFont(ThemeCache.tableFont);
        }
    }
}

