/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.table;

import com.mucommander.commons.collections.Enumerator;
import com.mucommander.commons.conf.ConfigurationEvent;
import com.mucommander.commons.conf.ConfigurationListener;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsVersions;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.job.MoveJob;
import com.mucommander.text.CustomDateFormat;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionKeymap;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.dialog.file.AbstractCopyDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.event.ActivePanelListener;
import com.mucommander.ui.event.TableSelectionListener;
import com.mucommander.ui.icon.FileIcons;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.menu.TablePopupMenu;
import com.mucommander.ui.main.table.Column;
import com.mucommander.ui.main.table.FileTableCellRenderer;
import com.mucommander.ui.main.table.FileTableColumnModel;
import com.mucommander.ui.main.table.FileTableConfiguration;
import com.mucommander.ui.main.table.FileTableHeader;
import com.mucommander.ui.main.table.FileTableModel;
import com.mucommander.ui.main.table.FileTableWrapperForDisplay;
import com.mucommander.ui.main.table.SortInfo;
import com.mucommander.ui.quicksearch.QuickSearch;
import com.mucommander.ui.theme.ColorChangedEvent;
import com.mucommander.ui.theme.FontChangedEvent;
import com.mucommander.ui.theme.ThemeListener;
import com.mucommander.ui.theme.ThemeManager;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.WeakHashMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTable
extends JTable
implements ConfigurationListener,
ActivePanelListener,
ThemeListener,
FocusListener,
KeyListener,
MouseListener,
MouseMotionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTable.class);
    private MainFrame mainFrame;
    private FolderPanel folderPanel;
    private FileTableModel tableModel;
    private FileTableCellRenderer cellRenderer;
    private FilenameEditor filenameEditor;
    private SortInfo sortInfo = new SortInfo();
    private int currentRow;
    private boolean markOnRightClick;
    private int lastDraggedRow = -1;
    private int lastRow;
    private boolean markKeyRepeated;
    private boolean lastRowMarked;
    private long selectionChangedTimestamp;
    private long lastDoubleClickTimestamp;
    private boolean autoSizeColumnsEnabled;
    private QuickSearch<AbstractFile> quickSearch = new FileTableQuickSearch();
    private WeakHashMap<TableSelectionListener, ?> tableSelectionListeners = new WeakHashMap();
    private boolean isActiveTable;
    private long focusGainedTime;
    private long doubleClickTime;
    private int doubleClickCounter = 1;
    private static int DOUBLE_CLICK_INTERVAL = DesktopManager.getMultiClickInterval();
    private FileTableWrapperForDisplay scrollpaneWrapper;

    public FileTable(MainFrame mainFrame, FolderPanel folderPanel, FileTableConfiguration conf) {
        super(new FileTableModel(), new FileTableColumnModel(conf));
        this.tableModel = (FileTableModel)this.getModel();
        this.tableModel.setSortInfo(this.sortInfo);
        ThemeManager.addCurrentThemeListener(this);
        this.setAutoResizeMode(1);
        this.mainFrame = mainFrame;
        this.folderPanel = folderPanel;
        InputMap inputMap = this.getInputMap(1);
        inputMap.clear();
        inputMap.setParent(null);
        this.cellRenderer = new FileTableCellRenderer(this);
        this.filenameEditor = new FilenameEditor(new JTextField());
        this.getColumnModel().getColumn(this.convertColumnIndexToView(Column.NAME.ordinal())).setCellEditor(this.filenameEditor);
        this.getSelectionModel().setSelectionMode(0);
        this.setTableHeader(new FileTableHeader(this));
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setRowHeight();
        this.setAutoSizeColumnsEnabled(MuConfigurations.getPreferences().getVariable(MuPreference.AUTO_SIZE_COLUMNS, true));
        this.addMouseListener(this);
        folderPanel.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        mainFrame.addActivePanelListener(this);
        MuConfigurations.addPreferencesListener(this);
        if (FileTable.usesTableHeaderRenderingProperties()) {
            this.setTableHeaderRenderingProperties();
        }
        this.scrollpaneWrapper = new FileTableWrapperForDisplay(this, mainFrame);
    }

    public String getFileNameAtRow(int index) {
        return index == 0 && this.tableModel.hasParentFolder() ? ".." : this.tableModel.getFileAtRow(index).getName();
    }

    public JComponent getAsUIComponent() {
        return this.scrollpaneWrapper;
    }

    private void setTableHeaderRenderingProperties() {
        if (FileTable.usesTableHeaderRenderingProperties()) {
            JTableHeader tableHeader = this.getTableHeader();
            if (tableHeader == null) {
                return;
            }
            boolean isActiveTable = this.isActiveTable();
            tableHeader.putClientProperty("JTableHeader.selectedColumn", isActiveTable ? Integer.valueOf(this.convertColumnIndexToView(this.sortInfo.getCriterion().ordinal())) : null);
            tableHeader.putClientProperty("JTableHeader.sortDirection", isActiveTable ? (this.sortInfo.getAscendingOrder() ? "ascending" : "decending") : null);
        }
    }

    static boolean usesTableHeaderRenderingProperties() {
        return OsFamilies.MAC_OS_X.isCurrent() && OsVersions.MAC_OS_X_10_5.isCurrentOrHigher();
    }

    public FolderPanel getFolderPanel() {
        return this.folderPanel;
    }

    public boolean isActiveTable() {
        return this.isActiveTable;
    }

    public FileTableModel getFileTableModel() {
        return this.tableModel;
    }

    public SortInfo getSortInfo() {
        return this.sortInfo;
    }

    public QuickSearch<AbstractFile> getQuickSearch() {
        return this.quickSearch;
    }

    public synchronized AbstractFile getSelectedFile() {
        return this.getSelectedFile(false, false);
    }

    public synchronized AbstractFile getSelectedFile(boolean includeParentFolder) {
        return this.getSelectedFile(includeParentFolder, false);
    }

    public synchronized AbstractFile getSelectedFile(boolean includeParentFolder, boolean returnCachedFile) {
        if (this.tableModel.getRowCount() == 0 || !includeParentFolder && this.isParentFolderSelected()) {
            return null;
        }
        return returnCachedFile ? this.tableModel.getCachedFileAtRow(this.currentRow) : this.tableModel.getFileAtRow(this.currentRow);
    }

    public FileSet getSelectedFiles() {
        AbstractFile selectedFile;
        FileSet selectedFiles = this.tableModel.getMarkedFiles();
        if (selectedFiles.size() == 0 && (selectedFile = this.getSelectedFile()) != null) {
            selectedFiles.add(selectedFile);
        }
        return selectedFiles;
    }

    public boolean isParentFolderSelected() {
        return this.currentRow == 0 && this.tableModel.hasParentFolder();
    }

    public boolean isParentFolder(int row) {
        return row == 0 && this.tableModel.hasParentFolder();
    }

    public AbstractFile getCurrentFolder() {
        return this.tableModel.getCurrentFolder();
    }

    public void setCurrentFolder(AbstractFile folder, AbstractFile[] children) {
        this.setCurrentFolder(folder, children, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentFolder(AbstractFile folder, AbstractFile[] children, AbstractFile fileToSelect) {
        FolderChangeThread folderChangeThread;
        this.quickSearch.stop();
        AbstractFile currentFolder = this.getCurrentFolder();
        FileSet markedFiles = null;
        if (currentFolder != null && folder.equalsCanonical(currentFolder)) {
            markedFiles = this.tableModel.getMarkedFiles();
            if (fileToSelect == null) {
                fileToSelect = this.getSelectedFile();
            }
        } else if (fileToSelect == null && this.tableModel.hasParentFolder() && folder.equals(this.tableModel.getParentFolder())) {
            fileToSelect = currentFolder;
        }
        FolderChangeThread folderChangeThread2 = folderChangeThread = new FolderChangeThread(folder, children, markedFiles, fileToSelect);
        synchronized (folderChangeThread2) {
            SwingUtilities.invokeLater(folderChangeThread);
            while (true) {
                try {
                    folderChangeThread.wait();
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
    }

    private void setRowHeight() {
        this.setRowHeight(2 + Math.max(this.getFontMetrics(this.filenameEditor.filenameField.getFont()).getHeight(), (int)FileIcons.getIconDimension().getHeight()));
    }

    public boolean isAutoSizeColumnsEnabled() {
        return this.autoSizeColumnsEnabled;
    }

    public void setAutoSizeColumnsEnabled(boolean enabled) {
        this.autoSizeColumnsEnabled = enabled;
        if (this.autoSizeColumnsEnabled) {
            this.getTableHeader().setResizingAllowed(false);
            this.resizeAndRepaint();
        } else {
            this.getTableHeader().setResizingAllowed(true);
        }
    }

    public void setFoldersFirst(boolean enabled) {
        if (this.sortInfo.getFoldersFirst() != enabled) {
            this.sortInfo.setFoldersFirst(enabled);
            this.sortTable();
        }
    }

    public void selectFile(AbstractFile file) {
        int row = this.tableModel.getFileRow(file);
        if (row != -1) {
            this.selectRow(row);
        }
    }

    public void selectRow(int row) {
        this.changeSelection(row, 0, false, false);
    }

    public void setRowMarked(int row, boolean marked) {
        this.setRowMarked(row, marked, true);
    }

    public void setRowMarked(int row, boolean marked, boolean repaint) {
        if (this.isParentFolder(row)) {
            return;
        }
        this.tableModel.setRowMarked(row, marked);
        if (repaint) {
            this.repaintRow(row);
        }
        this.fireMarkedFilesChangedEvent();
    }

    public void setFileMarked(AbstractFile file, boolean marked, boolean repaint) {
        int row = this.tableModel.getFileRow(file);
        if (row != -1) {
            this.setRowMarked(row, marked, repaint);
        }
    }

    public void markSelectedFile() {
        if (this.markKeyRepeated && this.lastRowMarked) {
            return;
        }
        if (!this.isParentFolderSelected()) {
            this.setRowMarked(this.currentRow, !this.tableModel.isRowMarked(this.currentRow));
        }
        if (this.currentRow != this.tableModel.getRowCount() - 1) {
            this.selectRow(this.currentRow + 1);
        } else if (!this.lastRowMarked) {
            this.repaintRow(this.currentRow);
            this.lastRowMarked = true;
        }
        this.markKeyRepeated = true;
    }

    public void setRangeMarked(int startRow, int endRow, boolean marked) {
        this.tableModel.setRangeMarked(startRow, endRow, marked);
        this.repaintRange(startRow, endRow);
        this.fireMarkedFilesChangedEvent();
    }

    private void repaintRow(int row) {
        this.repaint(0, row * this.getRowHeight(), this.getWidth(), this.rowHeight);
    }

    private void repaintRange(int startRow, int endRow) {
        int rowHeight = this.getRowHeight();
        this.repaint(0, Math.min(startRow, endRow) * rowHeight, this.getWidth(), (Math.abs(startRow - endRow) + 1) * rowHeight);
    }

    public int getPageRowIncrement() {
        return this.getScrollableBlockIncrement(this.getVisibleRect(), 1, 1) / this.getRowHeight() - 1;
    }

    public void sortBy(Column criterion, boolean ascending, boolean foldersFirst) {
        if (criterion == this.sortInfo.getCriterion() && ascending == this.sortInfo.getAscendingOrder() && foldersFirst == this.sortInfo.getFoldersFirst()) {
            return;
        }
        this.sortInfo.setFoldersFirst(foldersFirst);
        if (this.isColumnVisible(criterion)) {
            this.sortInfo.setCriterion(criterion);
            this.sortInfo.setAscendingOrder(ascending);
            if (FileTable.usesTableHeaderRenderingProperties()) {
                this.setTableHeaderRenderingProperties();
            }
            this.getTableHeader().repaint();
        }
        this.sortTable();
    }

    public void sortBy(SortInfo sortInfo) {
        this.sortBy(sortInfo.getCriterion(), sortInfo.getAscendingOrder(), sortInfo.getFoldersFirst());
    }

    public void sortBy(Column criterion, boolean ascending) {
        this.sortBy(criterion, ascending, this.sortInfo.getFoldersFirst());
    }

    public void sortBy(Column criterion) {
        if (criterion == this.sortInfo.getCriterion()) {
            this.reverseSortOrder();
            return;
        }
        this.sortBy(criterion, this.sortInfo.getAscendingOrder());
    }

    public FileTableColumnModel getFileTableColumnModel() {
        return (FileTableColumnModel)this.getColumnModel();
    }

    @Override
    public void setColumnModel(TableColumnModel columnModel) {
        super.setColumnModel(columnModel);
        if (this.filenameEditor != null) {
            columnModel.getColumn(this.convertColumnIndexToView(Column.NAME.ordinal())).setCellEditor(this.filenameEditor);
        }
        if (FileTable.usesTableHeaderRenderingProperties()) {
            this.setTableHeaderRenderingProperties();
        }
    }

    public boolean isColumnVisible(Column column) {
        return this.getFileTableColumnModel().isColumnVisible(column);
    }

    public boolean isColumnDisplayable(Column column) {
        AbstractFile file = this.getFileTableModel().getFileAt(0);
        if (file == null) {
            file = this.getCurrentFolder();
        }
        if (column == Column.OWNER) {
            return file.canGetOwner();
        }
        if (column == Column.GROUP) {
            return file.canGetGroup();
        }
        return true;
    }

    public void updateColumnsVisibility() {
        FileTableColumnModel columnModel = this.getFileTableColumnModel();
        for (Column c : Column.values()) {
            columnModel.setColumnVisible(c, columnModel.isColumnEnabled(c) && this.isColumnDisplayable(c));
        }
    }

    public boolean isColumnEnabled(Column column) {
        return this.getFileTableColumnModel().isColumnEnabled(column);
    }

    public void setColumnEnabled(Column column, boolean enabled) {
        FileTableColumnModel columnModel = this.getFileTableColumnModel();
        columnModel.setColumnEnabled(column, enabled);
        this.updateColumnsVisibility();
        if (this.sortInfo.getCriterion() == column && !columnModel.isColumnVisible(column)) {
            this.sortBy(Column.NAME);
        }
    }

    public int getColumnPosition(Column column) {
        return this.getFileTableColumnModel().getColumnPosition(column.ordinal());
    }

    public void reverseSortOrder() {
        boolean newSortOrder = !this.sortInfo.getAscendingOrder();
        this.sortInfo.setAscendingOrder(newSortOrder);
        if (FileTable.usesTableHeaderRenderingProperties()) {
            this.setTableHeaderRenderingProperties();
        }
        this.getTableHeader().repaint();
        this.sortTable();
    }

    public void editCurrentFilename() {
        this.mainFrame.getCommandBar().setAlternateActionsMode(false);
        this.tableModel.setNameColumnEditable(true);
        this.editCellAt(this.currentRow, this.convertColumnIndexToView(Column.NAME.ordinal()));
        this.filenameEditor.notifyEditingRow(this.currentRow);
        this.tableModel.setNameColumnEditable(false);
    }

    private void sortTable() {
        AbstractFile selectedFile = this.tableModel.getFileAtRow(this.currentRow);
        this.tableModel.sortRows();
        this.selectFile(selectedFile);
        this.repaint();
    }

    public void addTableSelectionListener(TableSelectionListener listener) {
        this.tableSelectionListeners.put(listener, null);
    }

    public void fireSelectedFileChangedEvent() {
        for (TableSelectionListener listener : this.tableSelectionListeners.keySet()) {
            listener.selectedFileChanged(this);
        }
    }

    public void fireMarkedFilesChangedEvent() {
        for (TableSelectionListener listener : this.tableSelectionListeners.keySet()) {
            listener.markedFilesChanged(this);
        }
    }

    private void doAutoLayout(boolean respectSize) {
        FontMetrics fm = this.getFontMetrics(FileTableCellRenderer.getCellFont());
        int dirStringWidth = fm.stringWidth("<DIR>");
        int remainingWidth = this.getSize().width - 40;
        Iterator<TableColumn> columns = respectSize ? new Enumerator<TableColumn>(this.getColumnModel().getColumns()) : this.getFileTableColumnModel().getAllColumns();
        TableColumn nameColumn = null;
        while (columns.hasNext()) {
            int columnWidth;
            TableColumn column = columns.next();
            Column c = Column.valueOf(column.getModelIndex());
            if (c == Column.NAME) {
                nameColumn = column;
                continue;
            }
            if (c == Column.EXTENSION) {
                columnWidth = (int)FileIcons.getIconDimension().getWidth();
            } else {
                columnWidth = 20;
                int rowCount = this.getModel().getRowCount();
                for (int rowNum = 0; rowNum < rowCount; ++rowNum) {
                    String val = (String)this.getModel().getValueAt(rowNum, column.getModelIndex());
                    int stringWidth = val == null ? 0 : (c == Column.SIZE && val.equals("<DIR>") ? dirStringWidth : fm.stringWidth(val));
                    columnWidth = Math.max(columnWidth, stringWidth);
                }
            }
            if (respectSize) {
                columnWidth = Math.min(columnWidth, remainingWidth);
            }
            column.setWidth(columnWidth += 8);
            if ((remainingWidth -= columnWidth) >= 0) continue;
            remainingWidth = 0;
        }
        nameColumn.setWidth(remainingWidth + 40);
    }

    private void doStaticLayout() {
        int width = this.getSize().width - this.getColumnModel().getTotalColumnWidth();
        if (width == 0) {
            return;
        }
        TableColumn nameColumn = this.getColumnModel().getColumn(this.convertColumnIndexToView(Column.NAME.ordinal()));
        if (nameColumn.getWidth() + width >= 40) {
            nameColumn.setWidth(nameColumn.getWidth() + width);
        } else {
            nameColumn.setWidth(40);
        }
    }

    @Override
    public void doLayout() {
        if (!this.autoSizeColumnsEnabled) {
            if (this.getTableHeader().getResizingColumn() != null) {
                super.doLayout();
            } else if (!this.getFileTableColumnModel().wereColumnSizesSet()) {
                this.doAutoLayout(false);
            } else {
                this.doStaticLayout();
            }
        } else {
            this.doAutoLayout(true);
        }
        Rectangle visibleRect = this.getVisibleRect();
        final Rectangle cellRect = this.getCellRect(this.currentRow, 0, false);
        if ((cellRect.y < visibleRect.y || cellRect.y + this.getRowHeight() > visibleRect.y + visibleRect.height) && this.scrollpaneWrapper != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FileTable.this.scrollpaneWrapper.getViewport().setViewPosition(new Point(0, Math.max(0, cellRect.y - FileTable.this.scrollpaneWrapper.getHeight() / 2 - FileTable.this.getRowHeight() / 2)));
                }
            });
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.cellRenderer;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent ke, int condition, boolean pressed) {
        if (this.quickSearch.isActive() || this.isEditing()) {
            return true;
        }
        return super.processKeyBinding(ks, ke, condition, pressed);
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        this.lastRow = this.currentRow;
        this.currentRow = rowIndex;
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        if (this.currentRow != this.lastRow) {
            this.selectionChangedTimestamp = System.currentTimeMillis();
            this.fireSelectedFileChangedEvent();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Container parentComp = this.getParent();
        return new Dimension(parentComp == null ? 0 : parentComp.getWidth(), this.tableModel.getRowCount() * this.getRowHeight());
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            super.setVisible(true);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + " currentFolder=" + this.getCurrentFolder() + " hasFocus=" + this.hasFocus() + " currentRow=" + this.currentRow;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.mainFrame.getNoEventsMode()) {
            return;
        }
        Object object = mouseEvent.getSource();
        if (System.currentTimeMillis() - this.doubleClickTime < (long)DOUBLE_CLICK_INTERVAL && this.selectionChangedTimestamp < this.doubleClickTime) {
            if (this.doubleClickCounter == 1) {
                this.doubleClickCounter = 2;
                mouseEvent.consume();
            }
        } else {
            this.doubleClickTime = System.currentTimeMillis();
            this.doubleClickCounter = 1;
        }
        if (object == this && DesktopManager.isLeftMouseButton(mouseEvent)) {
            if (this.doubleClickCounter == 1 && System.currentTimeMillis() - this.selectionChangedTimestamp > 500L) {
                int n = mouseEvent.getX();
                Point point = new Point(n, mouseEvent.getY());
                final int n2 = this.rowAtPoint(point);
                int n3 = this.columnAtPoint(point);
                final Column column = Column.valueOf(this.convertColumnIndexToModel(n3));
                if (!(n2 != this.currentRow || this.isParentFolderSelected() || column != Column.NAME && column != Column.DATE && column != Column.PERMISSIONS)) {
                    FontMetrics fontMetrics = this.getFontMetrics(FileTableCellRenderer.getCellFont());
                    int n4 = fontMetrics.stringWidth((String)this.tableModel.getValueAt(n2, column.ordinal()));
                    int n5 = (int)this.getTableHeader().getHeaderRect(n3).getX();
                    if (n < n5 + 4 || n > n5 + n4 + 4) {
                        return;
                    }
                    if (this.hasFocus() && System.currentTimeMillis() - this.focusGainedTime > 100L) {
                        new Thread(){

                            public void run() {
                                try {
                                    2.sleep(800L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                if (System.currentTimeMillis() - FileTable.this.lastDoubleClickTimestamp > 1000L && n2 == FileTable.this.currentRow) {
                                    if (column == Column.NAME) {
                                        if (!FileTable.this.isEditing()) {
                                            FileTable.this.editCurrentFilename();
                                        }
                                    } else if (column == Column.DATE) {
                                        ActionManager.performAction("ChangeDate", FileTable.this.mainFrame);
                                    } else if (column == Column.PERMISSIONS && FileTable.this.getSelectedFile().getChangeablePermissions().getIntValue() != 0) {
                                        ActionManager.performAction("ChangePermissions", FileTable.this.mainFrame);
                                    }
                                }
                            }
                        }.start();
                    }
                }
            } else if (this.doubleClickCounter == 2) {
                this.lastDoubleClickTimestamp = System.currentTimeMillis();
                ActionManager.performAction(mouseEvent.isShiftDown() ? "OpenNatively" : "Open", this.mainFrame);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.mainFrame.getNoEventsMode()) {
            return;
        }
        if (e.getSource() != this) {
            return;
        }
        if (DesktopManager.isRightMouseButton(e)) {
            boolean parentFolderClicked;
            int y;
            int x = e.getX();
            int clickedRow = this.rowAtPoint(new Point(x, y = e.getY()));
            boolean bl = parentFolderClicked = clickedRow == 0 && this.tableModel.hasParentFolder();
            if (this.currentRow != clickedRow) {
                this.selectRow(clickedRow);
            }
            if (!this.hasFocus()) {
                this.requestFocus();
            }
            new TablePopupMenu(this.mainFrame, this.getCurrentFolder(), parentFolderClicked ? null : this.tableModel.getFileAtRow(clickedRow), parentFolderClicked, this.tableModel.getMarkedFiles()).show(this, x, y);
        } else if (DesktopManager.isMiddleMouseButton(e)) {
            this.lastDraggedRow = this.rowAtPoint(e.getPoint());
            this.markOnRightClick = !this.tableModel.isRowMarked(this.lastDraggedRow);
            this.setRowMarked(this.lastDraggedRow, this.markOnRightClick);
        } else if (DesktopManager.isLeftMouseButton(e)) {
            if (e.isShiftDown()) {
                this.setRangeMarked(this.currentRow, this.lastRow, !this.tableModel.isRowMarked(this.currentRow));
            } else if (e.isControlDown()) {
                int rowNum;
                this.setRowMarked(rowNum, !this.tableModel.isRowMarked(rowNum = this.rowAtPoint(e.getPoint())));
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mainFrame.getNoEventsMode()) {
            return;
        }
        if (DesktopManager.isMiddleMouseButton(e) && this.lastDraggedRow != -1) {
            int draggedRow = this.rowAtPoint(e.getPoint());
            if (draggedRow == -1) {
                return;
            }
            this.setRangeMarked(this.lastDraggedRow, draggedRow, this.markOnRightClick);
            this.lastDraggedRow = draggedRow;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.quickSearch.isActive()) {
            return;
        }
        if (ActionManager.getActionInstance("MarkSelectedFile", this.mainFrame).isAccelerator(KeyStroke.getKeyStrokeForEvent(keyEvent))) {
            this.markKeyRepeated = false;
            this.lastRowMarked = false;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.focusGainedTime = System.currentTimeMillis();
        if (this.isEditing()) {
            this.filenameEditor.filenameField.requestFocus();
        } else {
            this.repaint();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void activePanelChanged(FolderPanel folderPanel) {
        boolean bl = this.isActiveTable = folderPanel == this.getFolderPanel();
        if (FileTable.usesTableHeaderRenderingProperties()) {
            this.setTableHeaderRenderingProperties();
        }
    }

    @Override
    public void configurationChanged(ConfigurationEvent configurationEvent) {
        String string = configurationEvent.getVariable();
        if (string.equals("display_compact_file_size")) {
            FileTableModel.setSizeFormat(configurationEvent.getBooleanValue());
            this.tableModel.fillCellCache();
            this.resizeAndRepaint();
        } else if (string.equals("date_format") || string.equals("date_separator") || string.equals("time_format")) {
            CustomDateFormat.updateDateFormat();
            this.tableModel.fillCellCache();
            this.resizeAndRepaint();
        } else if (string.equals("file_table.icon_scale")) {
            this.setRowHeight();
        } else if (string.equals("file_table.use_system_file_icons")) {
            this.repaint();
        }
    }

    @Override
    public void colorChanged(ColorChangedEvent event) {
    }

    @Override
    public void fontChanged(FontChangedEvent event) {
        if (event.getFontId() == 0) {
            this.filenameEditor.filenameField.setFont(event.getFont());
            this.setRowHeight();
        }
    }

    public FileTableConfiguration getConfiguration() {
        return this.getFileTableColumnModel().getConfiguration();
    }

    public int getColumnWidth(Column column) {
        return this.getFileTableColumnModel().getColumnFromId(column.ordinal()).getWidth();
    }

    private class FolderChangeThread
    implements Runnable {
        private AbstractFile folder;
        private AbstractFile[] children;
        private FileSet markedFiles;
        private AbstractFile selectedFile;

        private FolderChangeThread(AbstractFile folder, AbstractFile[] children, FileSet markedFiles, AbstractFile selectedFile) {
            this.folder = folder;
            this.children = children;
            this.markedFiles = markedFiles;
            this.selectedFile = selectedFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object columnModel;
            try {
                int rowToSelect;
                FileTable.this.tableModel.setCurrentFolder(this.folder, this.children);
                columnModel = FileTable.this.getFileTableColumnModel();
                FileTable.this.updateColumnsVisibility();
                if (!((FileTableColumnModel)columnModel).isColumnVisible(FileTable.this.sortInfo.getCriterion())) {
                    FileTable.this.sortInfo.setCriterion(Column.NAME);
                    if (FileTable.usesTableHeaderRenderingProperties()) {
                        FileTable.this.setTableHeaderRenderingProperties();
                    }
                }
                FileTable.this.tableModel.sortRows();
                if (this.selectedFile != null) {
                    rowToSelect = FileTable.this.tableModel.getFileRow(this.selectedFile);
                    if (rowToSelect == -1) {
                        int rowCount = FileTable.this.tableModel.getRowCount();
                        rowToSelect = FileTable.this.currentRow < rowCount ? FileTable.this.currentRow : rowCount - 1;
                    }
                } else {
                    rowToSelect = 0;
                }
                FileTable.this.selectRow(FileTable.this.currentRow = rowToSelect);
                FileTable.this.fireSelectedFileChangedEvent();
                if (this.markedFiles != null) {
                    int nbMarkedFiles = this.markedFiles.size();
                    for (int i = 0; i < nbMarkedFiles; ++i) {
                        int fileRow = FileTable.this.tableModel.getFileRow((AbstractFile)this.markedFiles.elementAt(i));
                        if (fileRow == -1) continue;
                        FileTable.this.tableModel.setRowMarked(fileRow, true);
                    }
                    FileTable.this.fireMarkedFilesChangedEvent();
                }
                FileTable.this.resizeAndRepaint();
            }
            catch (Throwable e) {
                LOGGER.warn("Caught exception while changing folder, this should not happen!", e);
            }
            finally {
                columnModel = this;
                synchronized (columnModel) {
                    this.notify();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileTableQuickSearch
    extends QuickSearch<AbstractFile> {
        private FileTableQuickSearch() {
            super(FileTable.this);
        }

        @Override
        protected void searchStarted() {
            FileTable.this.scrollpaneWrapper.dimBackground();
        }

        @Override
        protected void searchStopped() {
            FileTable.this.mainFrame.getStatusBar().updateSelectedFilesInfo();
            FileTable.this.scrollpaneWrapper.undimBackground();
        }

        @Override
        protected int getNumOfItems() {
            return FileTable.this.tableModel.getRowCount();
        }

        @Override
        protected String getItemString(int index) {
            return FileTable.this.getFileNameAtRow(index);
        }

        @Override
        protected void searchStringBecameEmpty(String searchString) {
            FileTable.this.mainFrame.getStatusBar().setStatusInfo(searchString);
        }

        @Override
        protected void matchFound(int row, String searchString) {
            if (row != FileTable.this.currentRow) {
                FileTable.this.selectRow(row);
            }
            FileTable.this.mainFrame.getStatusBar().setStatusInfo(searchString, IconManager.getIcon(2, "quick_search_ok.png"), false);
        }

        @Override
        protected void matchNotFound(String searchString) {
            FileTable.this.mainFrame.getStatusBar().setStatusInfo(searchString, IconManager.getIcon(2, "quick_search_ko.png"), false);
        }

        @Override
        public synchronized void keyPressed(KeyEvent e) {
            boolean keyHasModifiers;
            if (FileTable.this.mainFrame.getNoEventsMode()) {
                return;
            }
            char keyChar = e.getKeyChar();
            if (!this.isActive()) {
                if (!this.isValidQuickSearchInput(e)) {
                    return;
                }
                if (ActionKeymap.isKeyStrokeRegistered(KeyStroke.getKeyStrokeForEvent(e))) {
                    return;
                }
                this.start();
            }
            int keyCode = e.getKeyCode();
            boolean bl = keyHasModifiers = (e.getModifiersEx() & 0x3C0) != 0;
            if (keyCode == 8 && !keyHasModifiers) {
                if (this.isSearchStringEmpty()) {
                    return;
                }
                this.removeLastCharacterFromSearchString();
                this.findMatch(0, true, true);
            } else if (keyCode == 27 && !keyHasModifiers) {
                this.stop();
            } else if (!(keyCode != 38 && keyCode != 40 || keyHasModifiers)) {
                boolean down = keyCode == 40;
                this.findMatch(FileTable.this.currentRow + (down ? 1 : -1), down, false);
            } else if (ActionManager.getActionInstance("MarkSelectedFile", FileTable.this.mainFrame).isAccelerator(KeyStroke.getKeyStrokeForEvent(e)) || ActionManager.getActionInstance("MarkNextRow", FileTable.this.mainFrame).isAccelerator(KeyStroke.getKeyStrokeForEvent(e))) {
                if (!FileTable.this.isParentFolderSelected()) {
                    FileTable.this.setRowMarked(FileTable.this.currentRow, !FileTable.this.tableModel.isRowMarked(FileTable.this.currentRow));
                }
                this.findMatch(FileTable.this.currentRow + 1, true, false);
            } else if (ActionManager.getActionInstance("MarkPreviousRow", FileTable.this.mainFrame).isAccelerator(KeyStroke.getKeyStrokeForEvent(e))) {
                if (!FileTable.this.isParentFolderSelected()) {
                    FileTable.this.setRowMarked(FileTable.this.currentRow, !FileTable.this.tableModel.isRowMarked(FileTable.this.currentRow));
                }
                this.findMatch(FileTable.this.currentRow - 1, false, false);
            } else if (this.isValidQuickSearchInput(e)) {
                this.appendCharacterToSearchString(keyChar);
                this.findMatch(0, true, true);
            } else {
                String muActionId = ActionKeymap.getRegisteredActionIdForKeystroke(KeyStroke.getKeyStrokeForEvent(e));
                if (muActionId != null) {
                    e.consume();
                    this.stop();
                    ActionManager.getActionInstance(muActionId, FileTable.this.mainFrame).performAction();
                }
                return;
            }
            this.setLastSearchStringChange(System.currentTimeMillis());
        }
    }

    private class FilenameEditor
    extends DefaultCellEditor {
        private JTextField filenameField;
        private int editingRow;

        public FilenameEditor(JTextField textField) {
            super(textField);
            this.filenameField = textField;
            this.filenameField.setFont(FileTableCellRenderer.getCellFont());
            textField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (keyCode == 27) {
                        FilenameEditor.this.cancelCellEditing();
                    }
                }
            });
            textField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FilenameEditor.this.rename();
                }
            });
            textField.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    FilenameEditor.this.cancelCellEditing();
                    FileTable.this.repaint();
                }

                public void focusGained(FocusEvent e) {
                }
            });
        }

        private void rename() {
            AbstractFile fileToRename;
            String newName = this.filenameField.getText();
            if (!newName.equals((fileToRename = FileTable.this.tableModel.getFileAtRow(this.editingRow)).getName())) {
                AbstractFile current = FileTable.this.getCurrentFolder();
                ProgressDialog progressDialog = new ProgressDialog(FileTable.this.mainFrame, Translator.get("move_dialog.moving", new String[0]));
                FileSet files = new FileSet(current);
                files.add(fileToRename);
                MoveJob renameJob = new MoveJob(progressDialog, FileTable.this.mainFrame, files, current, newName, -1, true);
                progressDialog.start(renameJob);
            }
        }

        public void notifyEditingRow(int row) {
            this.editingRow = row;
            AbstractFile file = FileTable.this.tableModel.getFileAtRow(this.editingRow);
            AbstractCopyDialog.selectDestinationFilename(file, file.getName(), 0).feedToPathField(this.filenameField);
            this.filenameField.requestFocus();
        }
    }
}

