/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.table;

import com.mucommander.text.Translator;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Column {
    EXTENSION(true, true, 3, "ToggleExtensionColumn", "SortByExtension"),
    NAME(false, true, 0, null, "SortByName"),
    SIZE(true, true, 1, "ToggleSizeColumn", "SortBySize"),
    DATE(true, true, 2, "ToggleDateColumn", "SortByDate"),
    PERMISSIONS(true, true, 4, "TogglePermissionsColumn", "SortByPermissions"),
    OWNER(true, false, 5, "ToggleOwnerColumn", "SortByOwner"),
    GROUP(true, false, 6, "ToggleGroupColumn", "SortByGroup");

    private static final Map<Integer, Column> ORDINAL_TO_ENUM_MAPPING;
    private String label = Translator.get(this.toString(), new String[0]);
    private int minimumWidth;
    private boolean showByDefault;
    private int fileComparatorCriterion;
    private String toggleActionId;
    private String sortByActionId;

    private Column(boolean hasMinimumWidth, boolean showByDefault, int fileComparatorCriterion, String toggleActionId, String sortByActionId) {
        this.minimumWidth = hasMinimumWidth ? 8 : 0;
        this.showByDefault = showByDefault;
        this.fileComparatorCriterion = fileComparatorCriterion;
        this.toggleActionId = toggleActionId;
        this.sortByActionId = sortByActionId;
    }

    public String getLabel() {
        return this.label;
    }

    public int getMinimumColumnWidth() {
        return this.minimumWidth;
    }

    public boolean showByDefault() {
        return this.showByDefault;
    }

    public int getFileComparatorCriterion() {
        return this.fileComparatorCriterion;
    }

    public static Column valueOf(int ordinal) {
        return ORDINAL_TO_ENUM_MAPPING.get(ordinal);
    }

    public String getToggleColumnActionId() {
        return this.toggleActionId;
    }

    public String getSortByColumnActionId() {
        return this.sortByActionId;
    }

    static {
        ORDINAL_TO_ENUM_MAPPING = new HashMap<Integer, Column>(){
            {
                for (Column column : Column.values()) {
                    this.put(column.ordinal(), column);
                }
            }
        };
    }
}

