/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.quicklist;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.event.LocationEvent;
import com.mucommander.ui.event.LocationListener;
import com.mucommander.ui.quicklist.QuickListWithIcons;
import java.util.LinkedList;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentLocationsQL
extends QuickListWithIcons<AbstractFile>
implements LocationListener {
    private static int MAX_ELEMENTS = 15;
    private LinkedList<AbstractFile> linkedList = new LinkedList();

    public RecentLocationsQL() {
        super(ActionProperties.getActionLabel("ShowRecentLocationsQL"), Translator.get("recent_locations_quick_list.empty_message", new String[0]));
    }

    @Override
    protected void acceptListItem(AbstractFile item) {
        this.folderPanel.tryChangeCurrentFolder(item);
    }

    public AbstractFile[] getData() {
        LinkedList list = (LinkedList)this.linkedList.clone();
        if (!list.remove(this.folderPanel.getCurrentFolder())) {
            list.removeLast();
        }
        return list.toArray(new AbstractFile[0]);
    }

    @Override
    protected Icon itemToIcon(AbstractFile item) {
        return this.getIconOfFile(item);
    }

    @Override
    public void locationChanged(LocationEvent locationEvent) {
        AbstractFile currentFolder = locationEvent.getFolderPanel().getCurrentFolder();
        if (!this.linkedList.remove(currentFolder) && this.linkedList.size() > MAX_ELEMENTS) {
            this.linkedList.removeLast();
        }
        this.linkedList.addFirst(currentFolder);
    }

    @Override
    public void locationCancelled(LocationEvent locationEvent) {
    }

    @Override
    public void locationChanging(LocationEvent locationEvent) {
    }

    @Override
    public void locationFailed(LocationEvent locationEvent) {
    }
}

