/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.quicklist;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.event.LocationEvent;
import com.mucommander.ui.event.LocationListener;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.quicklist.QuickListWithIcons;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentFoldersQL
extends QuickListWithIcons<AbstractFile>
implements LocationListener {
    protected List<AbstractFile> parents = new Vector<AbstractFile>();
    protected boolean updated = true;

    public ParentFoldersQL(FolderPanel folderPanel) {
        super(ActionProperties.getActionLabel("ShowParentFoldersQL"), Translator.get("parent_folders_quick_list.empty_message", new String[0]));
        folderPanel.getLocationManager().addLocationListener(this);
    }

    @Override
    protected void acceptListItem(AbstractFile item) {
        this.folderPanel.tryChangeCurrentFolder(item);
    }

    protected void populateParentFolders(AbstractFile folder) {
        this.parents = new Vector<AbstractFile>();
        while ((folder = folder.getParent()) != null) {
            this.parents.add(folder);
        }
    }

    public AbstractFile[] getData() {
        if (!this.updated) {
            this.updated = true;
            if (true) {
                this.populateParentFolders(this.folderPanel.getCurrentFolder());
            }
        }
        return this.parents.toArray(new AbstractFile[0]);
    }

    @Override
    protected Icon itemToIcon(AbstractFile item) {
        return this.getIconOfFile(item);
    }

    @Override
    public void locationChanged(LocationEvent locationEvent) {
        this.updated = false;
    }

    @Override
    public void locationChanging(LocationEvent locationEvent) {
    }

    @Override
    public void locationCancelled(LocationEvent locationEvent) {
    }

    @Override
    public void locationFailed(LocationEvent locationEvent) {
    }
}

