/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.menu;

import com.mucommander.bonjour.BonjourMenu;
import com.mucommander.bonjour.BonjourService;
import com.mucommander.bookmark.Bookmark;
import com.mucommander.bookmark.BookmarkManager;
import com.mucommander.commons.collections.AlteredVector;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.action.ActionParameters;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.action.impl.OpenLocationAction;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.dialog.pref.theme.ThemeEditorDialog;
import com.mucommander.ui.helper.MenuToolkit;
import com.mucommander.ui.helper.MnemonicHelper;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.WindowManager;
import com.mucommander.ui.main.menu.OpenWithMenu;
import com.mucommander.ui.main.table.Column;
import com.mucommander.ui.main.table.FileTable;
import com.mucommander.ui.theme.Theme;
import com.mucommander.ui.theme.ThemeManager;
import com.mucommander.ui.viewer.FileFrame;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class MainMenuBar
extends JMenuBar
implements ActionListener,
MenuListener {
    private MainFrame mainFrame;
    private JMenu viewMenu;
    private JMenu themesMenu;
    private JCheckBoxMenuItem[] sortByItems = new JCheckBoxMenuItem[Column.values().length];
    private JMenu columnsMenu;
    private JCheckBoxMenuItem[] toggleColumnItems = new JCheckBoxMenuItem[Column.values().length];
    private JCheckBoxMenuItem toggleToggleAutoSizeItem;
    private JCheckBoxMenuItem toggleShowFoldersFirstItem;
    private JCheckBoxMenuItem toggleShowHiddenFilesItem;
    private JCheckBoxMenuItem toggleTreeItem;
    private JMenu goMenu;
    private int volumeOffset;
    private JMenu bookmarksMenu;
    private int bookmarksOffset;
    private JMenu windowMenu;
    private int windowOffset;
    private JCheckBoxMenuItem splitHorizontallyItem;
    private JCheckBoxMenuItem splitVerticallyItem;
    private WeakHashMap<JMenuItem, Frame> windowMenuFrames;
    private static final String[] RECALL_WINDOW_ACTION_IDS = new String[]{"RecallWindow1", "RecallWindow2", "RecallWindow3", "RecallWindow4", "RecallWindow5", "RecallWindow6", "RecallWindow7", "RecallWindow8", "RecallWindow9", "RecallWindow10"};

    public MainMenuBar(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        MnemonicHelper menuMnemonicHelper = OsFamilies.MAC_OS_X.isCurrent() ? null : new MnemonicHelper();
        MnemonicHelper menuItemMnemonicHelper = new MnemonicHelper();
        MnemonicHelper menuItemMnemonicHelper2 = new MnemonicHelper();
        JMenu fileMenu = MenuToolkit.addMenu(Translator.get("file_menu", new String[0]), menuMnemonicHelper, this);
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("NewWindow", mainFrame), menuItemMnemonicHelper);
        fileMenu.add(new JSeparator());
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("Open", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("OpenNatively", mainFrame), menuItemMnemonicHelper);
        fileMenu.add(new OpenWithMenu(mainFrame));
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("OpenInNewTab", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("OpenInOtherPanel", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("OpenInBothPanels", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("RevealInDesktop", mainFrame), menuItemMnemonicHelper);
        fileMenu.add(new JSeparator());
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("RunCommand", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("Pack", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("Unpack", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("Email", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("BatchRename", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("SplitFile", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("CombineFiles", mainFrame), menuItemMnemonicHelper);
        fileMenu.add(new JSeparator());
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("ShowFileProperties", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("CalculateChecksum", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("ChangePermissions", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("ChangeDate", mainFrame), menuItemMnemonicHelper);
        if (!OsFamilies.MAC_OS_X.isCurrent()) {
            fileMenu.add(new JSeparator());
            MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("ShowPreferences", mainFrame), menuItemMnemonicHelper);
        }
        fileMenu.add(new JSeparator());
        MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("CloseWindow", mainFrame), menuItemMnemonicHelper);
        if (!OsFamilies.MAC_OS_X.isCurrent()) {
            MenuToolkit.addMenuItem(fileMenu, ActionManager.getActionInstance("Quit", mainFrame), menuItemMnemonicHelper);
        }
        this.add(fileMenu);
        menuItemMnemonicHelper.clear();
        JMenu markMenu = MenuToolkit.addMenu(Translator.get("mark_menu", new String[0]), menuMnemonicHelper, this);
        MenuToolkit.addMenuItem(markMenu, ActionManager.getActionInstance("MarkSelectedFile", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(markMenu, ActionManager.getActionInstance("MarkGroup", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(markMenu, ActionManager.getActionInstance("UnmarkGroup", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(markMenu, ActionManager.getActionInstance("MarkAll", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(markMenu, ActionManager.getActionInstance("UnmarkAll", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(markMenu, ActionManager.getActionInstance("MarkExtension", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(markMenu, ActionManager.getActionInstance("InvertSelection", mainFrame), menuItemMnemonicHelper);
        markMenu.add(new JSeparator());
        MenuToolkit.addMenuItem(markMenu, ActionManager.getActionInstance("CopyFilesToClipboard", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(markMenu, ActionManager.getActionInstance("CopyFileNames", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(markMenu, ActionManager.getActionInstance("CopyFilePaths", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(markMenu, ActionManager.getActionInstance("PasteClipboardFiles", mainFrame), menuItemMnemonicHelper);
        markMenu.add(new JSeparator());
        MenuToolkit.addMenuItem(markMenu, ActionManager.getActionInstance("CompareFolders", mainFrame), menuItemMnemonicHelper);
        this.add(markMenu);
        menuItemMnemonicHelper.clear();
        this.viewMenu = MenuToolkit.addMenu(Translator.get("view_menu", new String[0]), menuMnemonicHelper, this);
        MenuToolkit.addMenuItem(this.viewMenu, ActionManager.getActionInstance("SwapFolders", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(this.viewMenu, ActionManager.getActionInstance("SetSameFolder", mainFrame), menuItemMnemonicHelper);
        this.viewMenu.add(new JSeparator());
        this.toggleShowFoldersFirstItem = MenuToolkit.addCheckBoxMenuItem(this.viewMenu, ActionManager.getActionInstance("ToggleShowFoldersFirst", mainFrame), menuItemMnemonicHelper);
        this.toggleShowHiddenFilesItem = MenuToolkit.addCheckBoxMenuItem(this.viewMenu, ActionManager.getActionInstance("ToggleHiddenFiles", mainFrame), menuItemMnemonicHelper);
        this.toggleTreeItem = MenuToolkit.addCheckBoxMenuItem(this.viewMenu, ActionManager.getActionInstance("ToggleTree", mainFrame), menuItemMnemonicHelper);
        this.viewMenu.add(new JSeparator());
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Column c : Column.values()) {
            JCheckBoxMenuItem jCheckBoxMenuItem = MenuToolkit.addCheckBoxMenuItem(this.viewMenu, ActionManager.getActionInstance(c.getSortByColumnActionId(), mainFrame), menuItemMnemonicHelper);
            this.sortByItems[c.ordinal()] = jCheckBoxMenuItem;
            buttonGroup.add(jCheckBoxMenuItem);
        }
        MenuToolkit.addMenuItem(this.viewMenu, ActionManager.getActionInstance("ReverseSortOrder", mainFrame), menuItemMnemonicHelper);
        this.viewMenu.add(new JSeparator());
        this.columnsMenu = MenuToolkit.addMenu(Translator.get("view_menu.show_hide_columns", new String[0]), null, this);
        menuItemMnemonicHelper2.clear();
        for (Column c : Column.values()) {
            if (c == Column.NAME) continue;
            this.toggleColumnItems[c.ordinal()] = MenuToolkit.addCheckBoxMenuItem(this.columnsMenu, ActionManager.getActionInstance(c.getToggleColumnActionId(), mainFrame), menuItemMnemonicHelper2);
        }
        this.viewMenu.add(this.columnsMenu);
        this.toggleToggleAutoSizeItem = MenuToolkit.addCheckBoxMenuItem(this.viewMenu, ActionManager.getActionInstance("ToggleAutoSize", mainFrame), menuItemMnemonicHelper);
        this.viewMenu.add(new JSeparator());
        MenuToolkit.addMenuItem(this.viewMenu, ActionManager.getActionInstance("ToggleToolBar", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(this.viewMenu, ActionManager.getActionInstance("ToggleStatusBar", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(this.viewMenu, ActionManager.getActionInstance("ToggleCommandBar", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(this.viewMenu, ActionManager.getActionInstance("CustomizeCommandBar", mainFrame), menuItemMnemonicHelper);
        this.add(this.viewMenu);
        menuItemMnemonicHelper.clear();
        this.goMenu = MenuToolkit.addMenu(Translator.get("go_menu", new String[0]), menuMnemonicHelper, this);
        MenuToolkit.addMenuItem(this.goMenu, ActionManager.getActionInstance("GoBack", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(this.goMenu, ActionManager.getActionInstance("GoForward", mainFrame), menuItemMnemonicHelper);
        this.goMenu.add(new JSeparator());
        MenuToolkit.addMenuItem(this.goMenu, ActionManager.getActionInstance("GoToParent", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(this.goMenu, ActionManager.getActionInstance("GoToParentInOtherPanel", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(this.goMenu, ActionManager.getActionInstance("GoToParentInBothPanels", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(this.goMenu, ActionManager.getActionInstance("GoToRoot", mainFrame), menuItemMnemonicHelper);
        this.goMenu.add(new JSeparator());
        MenuToolkit.addMenuItem(this.goMenu, ActionManager.getActionInstance("ChangeLocation", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(this.goMenu, ActionManager.getActionInstance("ConnectToServer", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(this.goMenu, ActionManager.getActionInstance("ShowServerConnections", mainFrame), menuItemMnemonicHelper);
        this.goMenu.add(new JSeparator());
        JMenu quickListMenu = MenuToolkit.addMenu(Translator.get("quick_lists_menu", new String[0]), menuMnemonicHelper, this);
        menuItemMnemonicHelper2.clear();
        MenuToolkit.addMenuItem(quickListMenu, ActionManager.getActionInstance("ShowParentFoldersQL", mainFrame), menuItemMnemonicHelper2);
        MenuToolkit.addMenuItem(quickListMenu, ActionManager.getActionInstance("ShowRecentLocationsQL", mainFrame), menuItemMnemonicHelper2);
        MenuToolkit.addMenuItem(quickListMenu, ActionManager.getActionInstance("ShowRecentExecutedFilesQL", mainFrame), menuItemMnemonicHelper2);
        MenuToolkit.addMenuItem(quickListMenu, ActionManager.getActionInstance("ShowBookmarksQL", mainFrame), menuItemMnemonicHelper2);
        MenuToolkit.addMenuItem(quickListMenu, ActionManager.getActionInstance("ShowRootFoldersQL", mainFrame), menuItemMnemonicHelper2);
        this.goMenu.add(quickListMenu);
        this.goMenu.add(new JSeparator());
        BonjourMenu bonjourMenu = new BonjourMenu(){

            public MuAction getMenuItemAction(BonjourService bs) {
                return new OpenLocationAction(MainMenuBar.this.mainFrame, new Hashtable<String, Object>(), bs);
            }
        };
        char mnemonic = menuItemMnemonicHelper.getMnemonic(bonjourMenu.getName());
        if (mnemonic != '\u0000') {
            bonjourMenu.setMnemonic(mnemonic);
        }
        bonjourMenu.setIcon(null);
        this.goMenu.add(bonjourMenu);
        this.goMenu.add(new JSeparator());
        this.volumeOffset = this.goMenu.getItemCount();
        this.add(this.goMenu);
        menuItemMnemonicHelper.clear();
        this.bookmarksMenu = MenuToolkit.addMenu(Translator.get("bookmarks_menu", new String[0]), menuMnemonicHelper, this);
        MenuToolkit.addMenuItem(this.bookmarksMenu, ActionManager.getActionInstance("AddBookmark", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(this.bookmarksMenu, ActionManager.getActionInstance("EditBookmarks", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(this.bookmarksMenu, ActionManager.getActionInstance("ExploreBookmarks", mainFrame), menuItemMnemonicHelper);
        this.bookmarksMenu.add(new JSeparator());
        MenuToolkit.addMenuItem(this.bookmarksMenu, ActionManager.getActionInstance("EditCredentials", mainFrame), menuItemMnemonicHelper);
        this.bookmarksMenu.add(new JSeparator());
        this.bookmarksOffset = this.bookmarksMenu.getItemCount();
        this.add(this.bookmarksMenu);
        menuItemMnemonicHelper.clear();
        this.windowMenu = MenuToolkit.addMenu(Translator.get("window_menu", new String[0]), menuMnemonicHelper, this);
        if (OsFamilies.MAC_OS_X.isCurrent()) {
            MenuToolkit.addMenuItem(this.windowMenu, ActionManager.getActionInstance("MinimizeWindow", mainFrame), menuItemMnemonicHelper);
            MenuToolkit.addMenuItem(this.windowMenu, ActionManager.getActionInstance("MaximizeWindow", mainFrame), menuItemMnemonicHelper);
            this.windowMenu.add(new JSeparator());
        }
        MenuToolkit.addMenuItem(this.windowMenu, ActionManager.getActionInstance("SplitEqually", mainFrame), menuItemMnemonicHelper);
        buttonGroup = new ButtonGroup();
        this.splitVerticallyItem = MenuToolkit.addCheckBoxMenuItem(this.windowMenu, ActionManager.getActionInstance("SplitVertically", mainFrame), menuItemMnemonicHelper);
        buttonGroup.add(this.splitVerticallyItem);
        this.splitHorizontallyItem = MenuToolkit.addCheckBoxMenuItem(this.windowMenu, ActionManager.getActionInstance("SplitHorizontally", mainFrame), menuItemMnemonicHelper);
        buttonGroup.add(this.splitHorizontallyItem);
        this.windowMenu.add(new JSeparator());
        this.themesMenu = MenuToolkit.addMenu(Translator.get("prefs_dialog.themes", new String[0]), null, this);
        this.windowMenu.add(this.themesMenu);
        this.windowMenu.add(new JSeparator());
        MenuToolkit.addMenuItem(this.windowMenu, ActionManager.getActionInstance("RecallPreviousWindow", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(this.windowMenu, ActionManager.getActionInstance("RecallNextWindow", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(this.windowMenu, ActionManager.getActionInstance("BringAllToFront", mainFrame), menuItemMnemonicHelper);
        this.windowMenu.add(new JSeparator());
        this.windowOffset = this.windowMenu.getItemCount();
        this.add(this.windowMenu);
        menuItemMnemonicHelper.clear();
        JMenu helpMenu = MenuToolkit.addMenu(Translator.get("help_menu", new String[0]), menuMnemonicHelper, null);
        MenuToolkit.addMenuItem(helpMenu, ActionManager.getActionInstance("GoToDocumentation", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(helpMenu, ActionManager.getActionInstance("ShowKeyboardShortcuts", mainFrame), menuItemMnemonicHelper);
        MenuToolkit.addMenuItem(helpMenu, ActionManager.getActionInstance("ShowDebugConsole", mainFrame), menuItemMnemonicHelper);
        if (DesktopManager.canBrowse()) {
            helpMenu.add(new JSeparator());
            MenuToolkit.addMenuItem(helpMenu, ActionManager.getActionInstance("GoToWebsite", mainFrame), menuItemMnemonicHelper);
            MenuToolkit.addMenuItem(helpMenu, ActionManager.getActionInstance("GoToForums", mainFrame), menuItemMnemonicHelper);
            MenuToolkit.addMenuItem(helpMenu, ActionManager.getActionInstance("ReportBug", mainFrame), menuItemMnemonicHelper);
            MenuToolkit.addMenuItem(helpMenu, ActionManager.getActionInstance("Donate", mainFrame), menuItemMnemonicHelper);
            helpMenu.add(new JSeparator());
            MenuToolkit.addMenuItem(helpMenu, ActionManager.getActionInstance("CheckForUpdates", mainFrame), menuItemMnemonicHelper);
        }
        if (!OsFamilies.MAC_OS_X.isCurrent()) {
            helpMenu.add(new JSeparator());
            MenuToolkit.addMenuItem(helpMenu, ActionManager.getActionInstance("ShowAbout", mainFrame), menuItemMnemonicHelper);
        }
        this.add(helpMenu);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.mainFrame.getNoEventsMode()) {
            return;
        }
        this.windowMenuFrames.get(e.getSource()).toFront();
    }

    public void menuSelected(MenuEvent e) {
        block18: {
            Object source;
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block17: {
                                source = e.getSource();
                                if (source != this.viewMenu) break block17;
                                FileTable activeTable = this.mainFrame.getActiveTable();
                                this.sortByItems[activeTable.getSortInfo().getCriterion().ordinal()].setSelected(true);
                                this.toggleShowFoldersFirstItem.setSelected(activeTable.getSortInfo().getFoldersFirst());
                                this.toggleShowHiddenFilesItem.setSelected(MuConfigurations.getPreferences().getVariable(MuPreference.SHOW_HIDDEN_FILES, true));
                                this.toggleTreeItem.setSelected(activeTable.getFolderPanel().isTreeVisible());
                                this.toggleToggleAutoSizeItem.setSelected(this.mainFrame.isAutoSizeColumnsEnabled());
                                break block18;
                            }
                            if (source != this.columnsMenu) break block19;
                            FileTable activeTable = this.mainFrame.getActiveTable();
                            for (Column c : Column.values()) {
                                if (c == Column.NAME) continue;
                                JCheckBoxMenuItem item = this.toggleColumnItems[c.ordinal()];
                                item.setSelected(activeTable.isColumnEnabled(c));
                                item.setEnabled(activeTable.isColumnDisplayable(c));
                                item.setText(c.getLabel());
                            }
                            break block18;
                        }
                        if (source != this.goMenu) break block20;
                        for (int i = this.goMenu.getItemCount(); i > this.volumeOffset; --i) {
                            this.goMenu.remove(this.volumeOffset);
                        }
                        AbstractFile[] volumes = LocalFile.getVolumes();
                        int nbFolders = volumes.length;
                        for (int i = 0; i < nbFolders; ++i) {
                            this.goMenu.add(new OpenLocationAction(this.mainFrame, new Hashtable<String, Object>(), volumes[i]));
                        }
                        break block18;
                    }
                    if (source != this.bookmarksMenu) break block21;
                    for (int i = this.bookmarksMenu.getItemCount(); i > this.bookmarksOffset; --i) {
                        this.bookmarksMenu.remove(this.bookmarksOffset);
                    }
                    AlteredVector<Bookmark> bookmarks = BookmarkManager.getBookmarks();
                    int nbBookmarks = bookmarks.size();
                    if (nbBookmarks > 0) {
                        for (int i = 0; i < nbBookmarks; ++i) {
                            MenuToolkit.addMenuItem(this.bookmarksMenu, new OpenLocationAction(this.mainFrame, new Hashtable<String, Object>(), (Bookmark)bookmarks.get(i)), null);
                        }
                    } else {
                        JMenuItem noBookmarkItem = MenuToolkit.addMenuItem(this.bookmarksMenu, Translator.get("bookmarks_menu.no_bookmark", new String[0]), null, null, null);
                        noBookmarkItem.setEnabled(false);
                    }
                    break block18;
                }
                if (source != this.windowMenu) break block22;
                if (this.mainFrame.getSplitPaneOrientation()) {
                    this.splitVerticallyItem.setSelected(true);
                } else {
                    this.splitHorizontallyItem.setSelected(true);
                }
                for (int i = this.windowMenu.getItemCount(); i > this.windowOffset; --i) {
                    this.windowMenu.remove(this.windowOffset);
                }
                this.windowMenuFrames = new WeakHashMap();
                List<MainFrame> mainFrames = WindowManager.getMainFrames();
                int nbFrames = mainFrames.size();
                for (int i = 0; i < nbFrames; ++i) {
                    MuAction recallWindowAction;
                    MainFrame mainFrame = mainFrames.get(i);
                    JCheckBoxMenuItem checkBoxMenuItem = new JCheckBoxMenuItem();
                    if (i < 10) {
                        recallWindowAction = ActionManager.getActionInstance(RECALL_WINDOW_ACTION_IDS[i], this.mainFrame);
                    } else {
                        Hashtable<String, Object> actionProps = new Hashtable<String, Object>();
                        actionProps.put("window_number", "" + (i + 1));
                        recallWindowAction = ActionManager.getActionInstance(new ActionParameters("RecallWindow", actionProps), this.mainFrame);
                    }
                    checkBoxMenuItem.setAction(recallWindowAction);
                    checkBoxMenuItem.setText(i + 1 + " " + mainFrame.getActiveTable().getCurrentFolder().getAbsolutePath());
                    checkBoxMenuItem.setToolTipText(recallWindowAction.getLabel());
                    checkBoxMenuItem.setSelected(mainFrame == this.mainFrame);
                    this.windowMenu.add(checkBoxMenuItem);
                }
                Frame[] frames = Frame.getFrames();
                nbFrames = frames.length;
                boolean firstFrame = true;
                for (int i = 0; i < nbFrames; ++i) {
                    Frame frame = frames[i];
                    if (!frame.isShowing() || !(frame instanceof FileFrame)) continue;
                    if (firstFrame) {
                        this.windowMenu.add(new JSeparator());
                        firstFrame = false;
                    }
                    JMenuItem menuItem = new JMenuItem(frame.getTitle());
                    menuItem.addActionListener(this);
                    this.windowMenu.add(menuItem);
                    this.windowMenuFrames.put(menuItem, frame);
                }
                break block18;
            }
            if (source != this.themesMenu) break block18;
            this.themesMenu.removeAll();
            ButtonGroup buttonGroup = new ButtonGroup();
            Iterator<Theme> themes = ThemeManager.availableThemes();
            this.themesMenu.add(new JMenuItem(new EditCurrentThemeAction()));
            this.themesMenu.add(new JSeparator());
            while (themes.hasNext()) {
                Theme theme = themes.next();
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(new ChangeCurrentThemeAction(theme));
                buttonGroup.add(item);
                if (ThemeManager.isCurrentTheme(theme)) {
                    item.setSelected(true);
                }
                this.themesMenu.add(item);
            }
        }
    }

    public void menuDeselected(MenuEvent e) {
    }

    public void menuCanceled(MenuEvent e) {
    }

    private class EditCurrentThemeAction
    extends AbstractAction {
        public EditCurrentThemeAction() {
            super(Translator.get("prefs_dialog.edit_current_theme", new String[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new ThemeEditorDialog((Frame)MainMenuBar.this.mainFrame, ThemeManager.getCurrentTheme()).editTheme();
        }
    }

    private class ChangeCurrentThemeAction
    extends AbstractAction {
        private Theme theme;

        public ChangeCurrentThemeAction(Theme theme) {
            super(theme.getName());
            this.theme = theme;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ThemeManager.setCurrentTheme(this.theme);
            }
            catch (IllegalArgumentException e) {
                InformationDialog.showErrorDialog(MainMenuBar.this.mainFrame, Translator.get("theme_could_not_be_loaded", new String[0]));
            }
        }
    }
}

