/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.commandbar;

import com.mucommander.RuntimeConstants;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.io.backup.BackupInputStream;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.main.commandbar.CommandBarIO;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;
import javax.swing.KeyStroke;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class CommandBarReader
extends CommandBarIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandBarReader.class);
    private List<String> actionsIdsV;
    private List<String> alternateActionsIdsV;
    private KeyStroke modifier;
    private AbstractFile file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CommandBarReader(AbstractFile file) throws SAXException, IOException, ParserConfigurationException {
        this.file = file;
        InputStream in = null;
        try {
            in = new BackupInputStream(file);
            SAXParserFactory.newInstance().newSAXParser().parse(in, (DefaultHandler)this);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String[] getActionsRead() {
        int nbActions = this.actionsIdsV.size();
        String[] actionIds = new String[nbActions];
        this.actionsIdsV.toArray(actionIds);
        return actionIds;
    }

    public String[] getAlternateActionsRead() {
        int nbActions = this.alternateActionsIdsV.size();
        String[] alternateActionIds = new String[nbActions];
        this.alternateActionsIdsV.toArray(alternateActionIds);
        return alternateActionIds;
    }

    public KeyStroke getModifierRead() {
        return this.modifier;
    }

    public void startDocument() {
        LOGGER.trace(this.file.getAbsolutePath() + " parsing started");
        this.actionsIdsV = new Vector<String>();
        this.alternateActionsIdsV = new Vector<String>();
        this.modifier = null;
    }

    public void endDocument() {
        LOGGER.trace(this.file.getAbsolutePath() + " parsing finished");
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("button")) {
            String actionIdAttribute = attributes.getValue("action_id");
            if (actionIdAttribute != null) {
                if (ActionManager.isActionExist(actionIdAttribute)) {
                    this.actionsIdsV.add(actionIdAttribute);
                    actionIdAttribute = attributes.getValue("alt_action_id");
                    this.alternateActionsIdsV.add(ActionManager.isActionExist(actionIdAttribute) ? actionIdAttribute : null);
                }
            } else {
                String actionClassAttribute = attributes.getValue("action");
                if (actionClassAttribute != null) {
                    String actionId = ActionManager.extrapolateId(actionClassAttribute);
                    if (ActionManager.isActionExist(actionId)) {
                        this.actionsIdsV.add(actionId);
                        actionClassAttribute = attributes.getValue("alt_action");
                        if (actionClassAttribute == null) {
                            this.alternateActionsIdsV.add(null);
                        } else {
                            actionId = ActionManager.extrapolateId(actionClassAttribute);
                            if (ActionManager.isActionExist(actionId)) {
                                this.alternateActionsIdsV.add(actionId);
                            } else {
                                LOGGER.warn("Error in command_bar.xml: action id for " + actionClassAttribute + " not found");
                                this.alternateActionsIdsV.add(null);
                            }
                        }
                    } else {
                        LOGGER.warn("Error in command_bar.xml: action id for " + actionClassAttribute + " not found");
                    }
                }
            }
        } else if (qName.equals("command_bar")) {
            this.modifier = KeyStroke.getKeyStroke(attributes.getValue("modifier"));
            String fileVersion = attributes.getValue("version");
            if (!RuntimeConstants.VERSION.equals(fileVersion)) {
                CommandBarReader.setModified();
            }
        }
    }
}

