/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main;

import com.mucommander.desktop.AbstractTrash;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.button.PopupButton;
import com.mucommander.ui.button.RolloverButtonAdapter;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.main.MainFrame;
import java.awt.Insets;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class TrashPopupButton
extends PopupButton {
    private MainFrame mainFrame;
    private RolloverButtonAdapter rolloverButtonAdapter;

    public TrashPopupButton(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.setContentAreaFilled(false);
        this.setIcon(IconManager.getIcon(2, "trash.png"));
        this.rolloverButtonAdapter = new RolloverButtonAdapter();
        RolloverButtonAdapter.setButtonDecoration(this);
        this.addMouseListener(this.rolloverButtonAdapter);
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        AbstractTrash trash = DesktopManager.getTrash();
        if (trash != null) {
            if (trash.canOpen()) {
                popupMenu.add(ActionManager.getActionInstance("OpenTrash", this.mainFrame));
            }
            if (trash.canEmpty()) {
                JMenuItem emptyTrashItem = new JMenuItem(ActionManager.getActionInstance("EmptyTrash", this.mainFrame));
                int itemCount = trash.getItemCount();
                if (itemCount == 0) {
                    emptyTrashItem.setEnabled(false);
                } else if (itemCount > 0) {
                    emptyTrashItem.setText(emptyTrashItem.getText() + " (" + itemCount + ")");
                }
                popupMenu.add(emptyTrashItem);
            }
        }
        return popupMenu;
    }

    public Insets getInsets() {
        return new Insets(2, 2, 2, 2);
    }
}

