/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main;

import com.mucommander.cache.FastLRUCache;
import com.mucommander.cache.LRUCache;
import com.mucommander.commons.conf.ConfigurationEvent;
import com.mucommander.commons.conf.ConfigurationListener;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.commons.runtime.JavaVersions;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.text.SizeFormat;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.border.MutableLineBorder;
import com.mucommander.ui.event.ActivePanelListener;
import com.mucommander.ui.event.LocationEvent;
import com.mucommander.ui.event.LocationListener;
import com.mucommander.ui.event.TableSelectionListener;
import com.mucommander.ui.icon.SpinningDial;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.TrashPopupButton;
import com.mucommander.ui.main.table.FileTable;
import com.mucommander.ui.main.table.FileTableModel;
import com.mucommander.ui.theme.ColorChangedEvent;
import com.mucommander.ui.theme.FontChangedEvent;
import com.mucommander.ui.theme.ThemeListener;
import com.mucommander.ui.theme.ThemeManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusBar
extends JPanel
implements ActivePanelListener,
LocationListener,
TableSelectionListener,
ThemeListener,
ComponentListener,
MouseListener,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusBar.class);
    private MainFrame mainFrame;
    private JLabel selectedFilesLabel;
    private SpinningDial dial;
    private VolumeSpaceLabel volumeSpaceLabel;
    private Thread autoUpdateThread;
    private static LRUCache<String, Long[]> volumeInfoCache = new FastLRUCache<String, Long[]>(50);
    public static final ConfigurationListener CONFIGURATION_ADAPTER;
    private static int selectedFileSizeFormat;

    private static void setSelectedFileSizeFormat(boolean compactSize) {
        selectedFileSizeFormat = compactSize ? 138 : 20;
        selectedFileSizeFormat |= 0x40;
    }

    public StatusBar(MainFrame mainFrame) {
        this.setLayout(new BoxLayout(this, 0));
        this.mainFrame = mainFrame;
        this.selectedFilesLabel = new JLabel("");
        this.dial = new SpinningDial();
        this.add(this.selectedFilesLabel);
        this.add(Box.createHorizontalGlue());
        if (DesktopManager.getTrash() != null) {
            TrashPopupButton trashButton = new TrashPopupButton(mainFrame);
            trashButton.setPopupMenuLocation(1);
            this.add(trashButton);
            this.add(Box.createRigidArea(new Dimension(2, 0)));
        }
        this.volumeSpaceLabel = new VolumeSpaceLabel();
        this.add(this.volumeSpaceLabel);
        this.setVisible(MuConfigurations.getPreferences().getVariable(MuPreference.STATUS_BAR_VISIBLE, true));
        FolderPanel leftPanel = mainFrame.getLeftPanel();
        leftPanel.getLocationManager().addLocationListener(this);
        FolderPanel rightPanel = mainFrame.getRightPanel();
        rightPanel.getLocationManager().addLocationListener(this);
        leftPanel.getFileTable().addTableSelectionListener(this);
        rightPanel.getFileTable().addTableSelectionListener(this);
        mainFrame.addActivePanelListener(this);
        this.selectedFilesLabel.addMouseListener(this);
        this.volumeSpaceLabel.addMouseListener(this);
        this.addMouseListener(this);
        this.addComponentListener(this);
        this.selectedFilesLabel.setFont(ThemeManager.getCurrentFont(5));
        this.selectedFilesLabel.setForeground(ThemeManager.getCurrentColor(50));
        this.volumeSpaceLabel.setFont(ThemeManager.getCurrentFont(5));
        this.volumeSpaceLabel.setForeground(ThemeManager.getCurrentColor(50));
        ThemeManager.addCurrentThemeListener(this);
    }

    private void updateStatusInfo() {
        if (!this.isVisible()) {
            return;
        }
        this.updateSelectedFilesInfo();
        this.updateVolumeInfo();
    }

    public void updateSelectedFilesInfo() {
        String filesInfo;
        if (!this.isVisible()) {
            return;
        }
        FileTable currentFileTable = this.mainFrame.getActiveTable();
        AbstractFile selectedFile = currentFileTable.getSelectedFile(false, true);
        FileTableModel tableModel = currentFileTable.getFileTableModel();
        int nbMarkedFiles = tableModel.getNbMarkedFiles();
        long markedTotalSize = tableModel.getTotalMarkedSize();
        int fileCount = tableModel.getFileCount();
        int nbSelectedFiles = nbMarkedFiles == 0 && selectedFile != null ? 1 : nbMarkedFiles;
        if (fileCount == 0) {
            filesInfo = " ";
        } else {
            filesInfo = Translator.get("status_bar.selected_files", "" + nbSelectedFiles, "" + fileCount);
            if (nbMarkedFiles > 0) {
                filesInfo = filesInfo + " - " + SizeFormat.format(markedTotalSize, selectedFileSizeFormat);
            }
            if (selectedFile != null) {
                filesInfo = filesInfo + " - " + selectedFile.getName();
            }
        }
        this.setStatusInfo(filesInfo);
    }

    private synchronized void updateVolumeInfo() {
        if (!this.isVisible()) {
            return;
        }
        final AbstractFile currentFolder = this.mainFrame.getActiveTable().getCurrentFolder();
        final String volumePath = currentFolder.getVolume().getAbsolutePath(true);
        Long[] cachedVolumeInfo = volumeInfoCache.get(volumePath);
        if (cachedVolumeInfo != null) {
            LOGGER.debug("Cache hit!");
            this.volumeSpaceLabel.setVolumeSpace(cachedVolumeInfo[0], cachedVolumeInfo[1]);
        } else {
            new Thread("StatusBar.updateVolumeInfo"){

                public void run() {
                    long volumeFree;
                    long volumeTotal;
                    if (currentFolder instanceof LocalFile && JavaVersions.JAVA_1_5.isCurrentOrLower()) {
                        try {
                            long[] volumeInfo = ((LocalFile)currentFolder).getVolumeInfo();
                            volumeTotal = volumeInfo[0];
                            volumeFree = volumeInfo[1];
                        }
                        catch (IOException e) {
                            volumeTotal = -1L;
                            volumeFree = -1L;
                        }
                    } else {
                        try {
                            volumeFree = currentFolder.getFreeSpace();
                        }
                        catch (IOException e) {
                            volumeFree = -1L;
                        }
                        try {
                            volumeTotal = currentFolder.getTotalSpace();
                        }
                        catch (IOException e) {
                            volumeTotal = -1L;
                        }
                    }
                    StatusBar.this.volumeSpaceLabel.setVolumeSpace(volumeTotal, volumeFree);
                    LOGGER.debug("Adding to cache");
                    volumeInfoCache.add(volumePath, new Long[]{volumeTotal, volumeFree}, 60000L);
                }
            }.start();
        }
    }

    public void setStatusInfo(String text, Icon icon, boolean iconBeforeText) {
        this.selectedFilesLabel.setText(text);
        if (icon == null) {
            BufferedImage bi = new BufferedImage(1, 16, 2);
            icon = new ImageIcon(bi);
        }
        this.selectedFilesLabel.setIcon(icon);
        this.selectedFilesLabel.setHorizontalTextPosition(iconBeforeText ? 11 : 10);
    }

    public void setStatusInfo(String infoMessage) {
        this.setStatusInfo(infoMessage, null, false);
    }

    private synchronized void startAutoUpdate() {
        if (this.autoUpdateThread == null) {
            this.autoUpdateThread = new Thread((Runnable)this, "StatusBar autoUpdateThread");
            this.autoUpdateThread.setDaemon(true);
            this.autoUpdateThread.start();
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.startAutoUpdate();
            super.setVisible(true);
            this.updateStatusInfo();
        } else {
            this.autoUpdateThread = null;
            super.setVisible(false);
        }
    }

    public void run() {
        do {
            try {
                Thread.sleep(6000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isVisible() || this.mainFrame.getNoEventsMode() || !this.mainFrame.isForegroundActive()) continue;
            this.updateVolumeInfo();
        } while (this.autoUpdateThread != null && this.mainFrame.isVisible());
    }

    public void activePanelChanged(FolderPanel folderPanel) {
        this.updateStatusInfo();
    }

    public void selectedFileChanged(FileTable source) {
        if (source == this.mainFrame.getActiveTable() && this.mainFrame.isForegroundActive()) {
            this.updateSelectedFilesInfo();
        }
    }

    public void markedFilesChanged(FileTable source) {
        if (source == this.mainFrame.getActiveTable() && this.mainFrame.isForegroundActive()) {
            this.updateSelectedFilesInfo();
        }
    }

    public void locationChanged(LocationEvent e) {
        this.dial.setAnimated(false);
        this.updateStatusInfo();
    }

    public void locationChanging(LocationEvent e) {
        this.setStatusInfo(Translator.get("status_bar.connecting_to_folder", new String[0]), this.dial, true);
        this.dial.setAnimated(true);
    }

    public void locationCancelled(LocationEvent e) {
        this.dial.setAnimated(false);
        this.updateStatusInfo();
    }

    public void locationFailed(LocationEvent e) {
        this.dial.setAnimated(false);
        this.updateStatusInfo();
    }

    public void mouseClicked(MouseEvent e) {
        if (this.mainFrame.getNoEventsMode()) {
            return;
        }
        if (DesktopManager.isRightMouseButton(e)) {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(ActionManager.getActionInstance("ToggleStatusBar", this.mainFrame));
            popupMenu.show(this, e.getX(), e.getY());
            popupMenu.setVisible(true);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        this.updateStatusInfo();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void fontChanged(FontChangedEvent event) {
        if (event.getFontId() == 5) {
            this.selectedFilesLabel.setFont(event.getFont());
            this.volumeSpaceLabel.setFont(event.getFont());
            this.repaint();
        }
    }

    public void colorChanged(ColorChangedEvent event) {
        if (event.getColorId() == 50) {
            this.selectedFilesLabel.setForeground(event.getColor());
            this.volumeSpaceLabel.setForeground(event.getColor());
            this.repaint();
        }
    }

    static {
        StatusBar.setSelectedFileSizeFormat(MuConfigurations.getPreferences().getVariable(MuPreference.DISPLAY_COMPACT_FILE_SIZE, true));
        CONFIGURATION_ADAPTER = new ConfigurationListener(){

            public synchronized void configurationChanged(ConfigurationEvent event) {
                String var = event.getVariable();
                if (var.equals("display_compact_file_size")) {
                    StatusBar.setSelectedFileSizeFormat(event.getBooleanValue());
                }
            }
        };
        MuConfigurations.addPreferencesListener(CONFIGURATION_ADAPTER);
    }

    private static class VolumeSpaceLabel
    extends JLabel
    implements ThemeListener {
        private long freeSpace;
        private long totalSpace;
        private Color backgroundColor;
        private Color okColor;
        private Color warningColor;
        private Color criticalColor;

        private VolumeSpaceLabel() {
            super("");
            this.setHorizontalAlignment(0);
            this.backgroundColor = ThemeManager.getCurrentColor(51);
            this.okColor = ThemeManager.getCurrentColor(53);
            this.warningColor = ThemeManager.getCurrentColor(54);
            this.criticalColor = ThemeManager.getCurrentColor(55);
            this.setBorder(new MutableLineBorder(ThemeManager.getCurrentColor(52)));
            ThemeManager.addCurrentThemeListener(this);
        }

        private void setVolumeSpace(long totalSpace, long freeSpace) {
            String volumeInfo;
            this.freeSpace = freeSpace;
            this.totalSpace = totalSpace;
            if (freeSpace != -1L) {
                volumeInfo = SizeFormat.format(freeSpace, 202);
                if (totalSpace != -1L) {
                    volumeInfo = volumeInfo + " / " + SizeFormat.format(totalSpace, 202);
                }
                volumeInfo = Translator.get("status_bar.volume_free", volumeInfo);
            } else if (totalSpace != -1L) {
                volumeInfo = SizeFormat.format(totalSpace, 202);
                volumeInfo = Translator.get("status_bar.volume_capacity", volumeInfo);
            } else {
                volumeInfo = "";
            }
            this.setText(volumeInfo);
            if (freeSpace == -1L || totalSpace == -1L) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText("" + (int)((float)(100L * freeSpace) / (float)totalSpace) + "%");
            }
            this.repaint();
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return new Dimension(d.width + 4, d.height + 2);
        }

        private Color interpolateColor(Color c1, Color c2, float percent) {
            return new Color((int)((float)c1.getRed() + (float)(c2.getRed() - c1.getRed()) * percent), (int)((float)c1.getGreen() + (float)(c2.getGreen() - c1.getGreen()) * percent), (int)((float)c1.getBlue() + (float)(c2.getBlue() - c1.getBlue()) * percent));
        }

        public void paint(Graphics g) {
            if (this.freeSpace != -1L && this.totalSpace != -1L) {
                int width = this.getWidth();
                int height = this.getHeight();
                float freeSpacePercentage = (float)this.freeSpace / (float)this.totalSpace;
                Color c = freeSpacePercentage <= 0.05f ? this.criticalColor : (freeSpacePercentage <= 0.1f ? this.interpolateColor(this.warningColor, this.criticalColor, (0.1f - freeSpacePercentage) / 0.1f) : this.interpolateColor(this.okColor, this.warningColor, (1.0f - freeSpacePercentage) / 0.9f));
                g.setColor(c);
                int freeSpaceWidth = Math.max(Math.round(freeSpacePercentage * (float)(width - 2)), 1);
                g.fillRect(1, 1, freeSpaceWidth + 1, height - 2);
                g.setColor(this.backgroundColor);
                g.fillRect(freeSpaceWidth + 1, 1, width - freeSpaceWidth - 1, height - 2);
            }
            super.paint(g);
        }

        public void fontChanged(FontChangedEvent event) {
        }

        public void colorChanged(ColorChangedEvent event) {
            switch (event.getColorId()) {
                case 51: {
                    this.backgroundColor = event.getColor();
                    break;
                }
                case 52: {
                    if (!(this.getBorder() instanceof MutableLineBorder)) break;
                    ((MutableLineBorder)this.getBorder()).setLineColor(event.getColor());
                    break;
                }
                case 53: {
                    this.okColor = event.getColor();
                    break;
                }
                case 54: {
                    this.warningColor = event.getColor();
                    break;
                }
                case 55: {
                    this.criticalColor = event.getColor();
                    break;
                }
                default: {
                    return;
                }
            }
            this.repaint();
        }
    }
}

