/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main;

import com.mucommander.commons.file.AbstractArchiveEntryFile;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.runtime.JavaVersions;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsVersions;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.conf.MuSnapshot;
import com.mucommander.ui.action.ActionKeymap;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.button.ToolbarMoreButton;
import com.mucommander.ui.event.ActivePanelListener;
import com.mucommander.ui.event.LocationEvent;
import com.mucommander.ui.event.LocationListener;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.layout.ProportionalSplitPane;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.StatusBar;
import com.mucommander.ui.main.WindowManager;
import com.mucommander.ui.main.commandbar.CommandBar;
import com.mucommander.ui.main.menu.MainMenuBar;
import com.mucommander.ui.main.table.Column;
import com.mucommander.ui.main.table.FileTable;
import com.mucommander.ui.main.table.FileTableConfiguration;
import com.mucommander.ui.main.table.SortInfo;
import com.mucommander.ui.main.toolbar.ToolBar;
import com.mucommander.ui.quicklist.QuickListFocusableComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.table.TableColumnModel;

public class MainFrame
extends JFrame
implements LocationListener {
    private ProportionalSplitPane splitPane;
    private FolderPanel leftFolderPanel;
    private FolderPanel rightFolderPanel;
    private FileTable leftTable;
    private FileTable rightTable;
    private FileTable activeTable;
    private JPanel toolbarPanel;
    private ToolBar toolbar;
    private StatusBar statusBar;
    private CommandBar commandBar;
    private boolean noEventsMode;
    private boolean foregroundActive;
    private WeakHashMap<ActivePanelListener, ?> activePanelListeners = new WeakHashMap();

    private void setWindowIcon() {
        if (OsFamilies.MAC_OS_X.isCurrent()) {
            return;
        }
        if (JavaVersions.JAVA_1_6.isCurrentOrHigher()) {
            Vector<Image> icons = new Vector<Image>();
            icons.add(IconManager.getIcon(7, "icon16_8.png").getImage());
            if (OsFamilies.WINDOWS.isCurrent() && OsVersions.WINDOWS_XP.isCurrentOrLower()) {
                icons.add(IconManager.getIcon(7, "icon48_8.png").getImage());
            } else {
                icons.add(IconManager.getIcon(7, "icon16_24.png").getImage());
                icons.add(IconManager.getIcon(7, "icon32_24.png").getImage());
                icons.add(IconManager.getIcon(7, "icon48_24.png").getImage());
                icons.add(IconManager.getIcon(7, "icon128_24.png").getImage());
                icons.add(IconManager.getIcon(7, "icon256_24.png").getImage());
            }
            this.setIconImages(icons);
        } else {
            this.setIconImage(IconManager.getIcon(7, "icon16_8.png").getImage());
        }
    }

    private void init(FolderPanel leftFolderPanel, FolderPanel rightFolderPanel) {
        this.setWindowIcon();
        this.setResizable(true);
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        this.leftFolderPanel = leftFolderPanel;
        this.rightFolderPanel = rightFolderPanel;
        this.leftTable = leftFolderPanel.getFileTable();
        this.rightTable = rightFolderPanel.getFileTable();
        this.activeTable = this.leftTable;
        this.toolbar = new ToolBar(this);
        this.toolbarPanel = ToolbarMoreButton.wrapToolBar(this.toolbar);
        this.toolbarPanel.setVisible(MuConfigurations.getPreferences().getVariable(MuPreference.TOOLBAR_VISIBLE, true));
        contentPane.add((Component)this.toolbarPanel, "North");
        JPanel insetsPane = new JPanel(new BorderLayout()){

            public Insets getInsets() {
                return new Insets(0, 3, 3, 3);
            }
        };
        contentPane.add((Component)insetsPane, "Center");
        leftFolderPanel.getLocationManager().addLocationListener(this);
        rightFolderPanel.getLocationManager().addLocationListener(this);
        MainMenuBar menuBar = new MainMenuBar(this);
        this.setJMenuBar(menuBar);
        this.splitPane = new ProportionalSplitPane(this, MuConfigurations.getSnapshot().getVariable(MuSnapshot.getSplitOrientation(0), "vertical").equals("vertical") ? 1 : 0, false, this.leftFolderPanel, this.rightFolderPanel){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 0);
            }
        };
        this.splitPane.setBorder(null);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.disableAccessibilityShortcuts();
        insetsPane.add((Component)this.splitPane, "Center");
        YBoxPanel southPanel = new YBoxPanel();
        southPanel.addSpace(2);
        this.statusBar = new StatusBar(this);
        southPanel.add(this.statusBar);
        this.commandBar = new CommandBar(this);
        this.commandBar.setVisible(MuConfigurations.getPreferences().getVariable(MuPreference.COMMAND_BAR_VISIBLE, true));
        southPanel.add(this.commandBar);
        insetsPane.add((Component)southPanel, "South");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ActionManager.performAction("CloseWindow", MainFrame.this);
            }
        });
        ActionKeymap.registerActions(this);
        this.fireActivePanelChanged(this.activeTable.getFolderPanel());
        this.setFocusTraversalPolicy(new CustomFocusTraversalPolicy());
    }

    private MainFrame() {
    }

    private FileTableConfiguration getFileTableConfiguration(boolean isLeft) {
        FileTableConfiguration conf = new FileTableConfiguration();
        for (Column c : Column.values()) {
            if (c != Column.NAME) {
                conf.setEnabled(c, MuConfigurations.getSnapshot().getVariable(MuSnapshot.getShowColumnVariable(0, c, isLeft), c.showByDefault()));
                conf.setWidth(c, MuConfigurations.getSnapshot().getIntegerVariable(MuSnapshot.getColumnWidthVariable(0, c, isLeft)));
            }
            conf.setPosition(c, MuConfigurations.getSnapshot().getVariable(MuSnapshot.getColumnPositionVariable(0, c, isLeft), c.ordinal()));
        }
        return conf;
    }

    public MainFrame(AbstractFile[] leftInitialFolders, AbstractFile[] rightInitialFolders) {
        this.init(new FolderPanel(this, leftInitialFolders, this.getFileTableConfiguration(true)), new FolderPanel(this, rightInitialFolders, this.getFileTableConfiguration(false)));
        boolean isLeft = true;
        while (true) {
            FileTable fileTable = isLeft ? this.leftTable : this.rightTable;
            fileTable.sortBy(Column.valueOf(MuConfigurations.getSnapshot().getVariable(MuSnapshot.getFileTableSortByVariable(0, isLeft), "name").toUpperCase()), !MuConfigurations.getSnapshot().getVariable(MuSnapshot.getFileTableSortOrderVariable(0, isLeft), "asc").equals("desc"));
            FolderPanel folderPanel = isLeft ? this.leftFolderPanel : this.rightFolderPanel;
            folderPanel.setTreeWidth(MuConfigurations.getSnapshot().getVariable(MuSnapshot.getTreeWidthVariable(0, isLeft), 150));
            folderPanel.setTreeVisible(MuConfigurations.getSnapshot().getVariable(MuSnapshot.getTreeVisiblityVariable(0, isLeft), false));
            if (!isLeft) break;
            isLeft = false;
        }
    }

    MainFrame cloneMainFrame() {
        MainFrame mainFrame = new MainFrame();
        mainFrame.init(new FolderPanel(mainFrame, this.leftFolderPanel.getCurrentFolder(), this.leftTable.getConfiguration()), new FolderPanel(mainFrame, this.rightFolderPanel.getCurrentFolder(), this.rightTable.getConfiguration()));
        mainFrame.leftTable.sortBy(this.leftTable.getSortInfo());
        mainFrame.rightTable.sortBy(this.rightTable.getSortInfo());
        return mainFrame;
    }

    public void addActivePanelListener(ActivePanelListener activePanelListener) {
        this.activePanelListeners.put(activePanelListener, null);
    }

    private void fireActivePanelChanged(FolderPanel folderPanel) {
        for (ActivePanelListener listener : this.activePanelListeners.keySet()) {
            listener.activePanelChanged(folderPanel);
        }
    }

    public boolean getNoEventsMode() {
        return this.noEventsMode;
    }

    public void setNoEventsMode(boolean enabled) {
        this.noEventsMode = enabled;
    }

    public JPanel getToolBarPanel() {
        return this.toolbarPanel;
    }

    public CommandBar getCommandBar() {
        return this.commandBar;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public FileTable getActiveTable() {
        return this.activeTable;
    }

    public FolderPanel getActivePanel() {
        return this.activeTable.getFolderPanel();
    }

    void setActiveTable(FileTable table) {
        boolean activeTableChanged;
        boolean bl = activeTableChanged = this.activeTable != table;
        if (activeTableChanged) {
            this.activeTable = table;
            this.updateWindowTitle();
            this.fireActivePanelChanged(table.getFolderPanel());
        }
    }

    public FileTable getInactiveTable() {
        return this.activeTable == this.leftTable ? this.rightTable : this.leftTable;
    }

    public FolderPanel getInactivePanel() {
        return this.getInactiveTable().getFolderPanel();
    }

    public FolderPanel getLeftPanel() {
        return this.leftFolderPanel;
    }

    public FolderPanel getRightPanel() {
        return this.rightFolderPanel;
    }

    public ProportionalSplitPane getSplitPane() {
        return this.splitPane;
    }

    public void setSplitPaneOrientation(boolean vertical) {
        this.splitPane.setOrientation(vertical ? 1 : 0);
    }

    public boolean getSplitPaneOrientation() {
        return this.splitPane.getOrientation() == 1;
    }

    public void swapFolders() {
        this.splitPane.remove(this.leftFolderPanel);
        this.splitPane.remove(this.rightFolderPanel);
        FolderPanel tempPanel = this.leftFolderPanel;
        this.leftFolderPanel = this.rightFolderPanel;
        this.rightFolderPanel = tempPanel;
        int tempTreeWidth = this.leftFolderPanel.getTreeWidth();
        this.leftFolderPanel.setTreeWidth(this.rightFolderPanel.getTreeWidth());
        this.rightFolderPanel.setTreeWidth(tempTreeWidth);
        boolean tempTreeVisible = this.leftFolderPanel.isTreeVisible();
        this.leftFolderPanel.setTreeVisible(this.rightFolderPanel.isTreeVisible());
        this.rightFolderPanel.setTreeVisible(tempTreeVisible);
        FileTable tempTable = this.leftTable;
        this.leftTable = this.rightTable;
        this.rightTable = tempTable;
        TableColumnModel model = this.leftTable.getColumnModel();
        this.leftTable.setColumnModel(this.rightTable.getColumnModel());
        this.rightTable.setColumnModel(model);
        SortInfo sortInfo = this.leftTable.getSortInfo().clone();
        this.leftTable.sortBy(this.rightTable.getSortInfo());
        this.leftTable.updateColumnsVisibility();
        this.rightTable.sortBy(sortInfo);
        this.rightTable.updateColumnsVisibility();
        this.splitPane.setLeftComponent(this.leftFolderPanel);
        this.splitPane.setRightComponent(this.rightFolderPanel);
        this.splitPane.doLayout();
        this.splitPane.updateDividerLocation();
        this.activeTable.requestFocus();
    }

    public void setSameFolder() {
        (this.activeTable == this.leftTable ? this.rightTable : this.leftTable).getFolderPanel().tryChangeCurrentFolder(this.activeTable.getCurrentFolder());
    }

    public boolean isForegroundActive() {
        return this.foregroundActive;
    }

    void setForegroundActive(boolean foregroundActive) {
        this.foregroundActive = foregroundActive;
    }

    public void tryRefreshCurrentFolders() {
        this.leftFolderPanel.tryRefreshCurrentFolder();
        this.rightFolderPanel.tryRefreshCurrentFolder();
    }

    public boolean isAncestorOfActiveWindow() {
        if (this.isActive()) {
            return true;
        }
        Window[] ownedWindows = this.getOwnedWindows();
        int nbWindows = ownedWindows.length;
        for (int i = 0; i < nbWindows; ++i) {
            if (!ownedWindows[i].isActive()) continue;
            return true;
        }
        return false;
    }

    public void updateWindowTitle() {
        String string = this.activeTable.getCurrentFolder().getAbsolutePath();
        List<MainFrame> list = WindowManager.getMainFrames();
        if (list.size() > 1) {
            string = string + " [" + (list.indexOf(this) + 1) + "]";
        }
        this.setTitle(string);
        if (OsFamilies.MAC_OS_X.isCurrent() && OsVersions.MAC_OS_X_10_5.isCurrentOrHigher()) {
            AbstractFile abstractFile = this.activeTable.getCurrentFolder();
            Object object = abstractFile.getURL().getScheme().equals("file") ? (abstractFile.hasAncestor(AbstractArchiveEntryFile.class) ? abstractFile.getParentArchive().getUnderlyingFileObject() : abstractFile.getUnderlyingFileObject()) : new File("/Network");
            this.getRootPane().putClientProperty("Window.documentFile", object);
        }
    }

    public void toFront() {
        if ((this.getExtendedState() & 1) != 0) {
            this.setExtendedState(0);
        }
        super.toFront();
    }

    public boolean isAutoSizeColumnsEnabled() {
        return this.leftTable.isAutoSizeColumnsEnabled();
    }

    public void setAutoSizeColumnsEnabled(boolean b) {
        this.leftTable.setAutoSizeColumnsEnabled(b);
        this.rightTable.setAutoSizeColumnsEnabled(b);
    }

    public void locationChanged(LocationEvent e) {
        this.updateWindowTitle();
    }

    public void locationChanging(LocationEvent locationEvent) {
    }

    public void locationCancelled(LocationEvent locationEvent) {
    }

    public void locationFailed(LocationEvent locationEvent) {
    }

    protected class CustomFocusTraversalPolicy
    extends FocusTraversalPolicy {
        protected CustomFocusTraversalPolicy() {
        }

        public Component getComponentAfter(Container container, Component component) {
            if (component instanceof QuickListFocusableComponent) {
                return ((QuickListFocusableComponent)((Object)component)).getInvokerFileTable();
            }
            if (component == MainFrame.this.leftFolderPanel.getFoldersTreePanel().getTree()) {
                return MainFrame.this.leftTable;
            }
            if (component == MainFrame.this.rightFolderPanel.getFoldersTreePanel().getTree()) {
                return MainFrame.this.rightTable;
            }
            if (component == MainFrame.this.leftFolderPanel.getLocationTextField()) {
                return MainFrame.this.leftTable;
            }
            if (component == MainFrame.this.leftTable) {
                return MainFrame.this.rightTable;
            }
            if (component == MainFrame.this.rightFolderPanel.getLocationTextField()) {
                return MainFrame.this.rightTable;
            }
            return MainFrame.this.leftTable;
        }

        public Component getComponentBefore(Container container, Component component) {
            return this.getComponentAfter(container, component);
        }

        public Component getFirstComponent(Container container) {
            return MainFrame.this.leftTable;
        }

        public Component getLastComponent(Container container) {
            return MainFrame.this.rightTable;
        }

        public Component getDefaultComponent(Container container) {
            return MainFrame.this.getActiveTable();
        }
    }
}

