/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main;

import com.mucommander.bookmark.Bookmark;
import com.mucommander.bookmark.BookmarkManager;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.commons.file.util.PathUtils;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.ui.autocomplete.AutocompleterTextComponent;
import com.mucommander.ui.autocomplete.CompleterFactory;
import com.mucommander.ui.autocomplete.TextFieldCompletion;
import com.mucommander.ui.event.LocationEvent;
import com.mucommander.ui.event.LocationListener;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.progress.ProgressTextField;
import com.mucommander.ui.theme.ColorChangedEvent;
import com.mucommander.ui.theme.FontChangedEvent;
import com.mucommander.ui.theme.ThemeListener;
import com.mucommander.ui.theme.ThemeManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocationTextField
extends ProgressTextField
implements LocationListener,
ThemeListener,
FocusListener {
    private FolderPanel folderPanel;
    private boolean folderChangeInitiatedByLocationField;
    private String locationFieldTextSave;
    private static Pattern windowsTrailingSpacePattern;

    public LocationTextField(FolderPanel folderPanel) {
        super(0, ThemeManager.getCurrentColor(49));
        this.folderPanel = folderPanel;
        this.setFont(ThemeManager.getCurrentFont(3));
        this.setDisabledTextColor(ThemeManager.getCurrentColor(45));
        this.setForeground(ThemeManager.getCurrentColor(45));
        this.setBackground(ThemeManager.getCurrentColor(46));
        this.setSelectedTextColor(ThemeManager.getCurrentColor(47));
        this.setSelectionColor(ThemeManager.getCurrentColor(48));
        folderPanel.getLocationManager().addLocationListener(this);
        this.addFocusListener(this);
        this.enableAutoCompletion();
        ThemeManager.addCurrentThemeListener(this);
    }

    private void enableAutoCompletion() {
        new TextFieldCompletion(new AutocompleterTextComponent(this){

            public void OnEnterPressed(KeyEvent keyEvent) {
                if (LocationTextField.this.textFieldValidated()) {
                    LocationTextField.this.folderChangeCompleted(false);
                }
                keyEvent.consume();
            }

            public void OnEscPressed(KeyEvent keyEvent) {
                LocationTextField.this.textFieldCancelled();
            }
        }, CompleterFactory.getLocationCompleter());
    }

    private void folderChangeCompleted(boolean folderChangedSuccessfully) {
        if (folderChangedSuccessfully || !this.folderChangeInitiatedByLocationField) {
            this.setText(this.folderPanel.getCurrentFolder().getAbsolutePath());
        }
        this.setEnabled(true);
        if (!folderChangedSuccessfully && this.folderChangeInitiatedByLocationField) {
            this.setText(this.locationFieldTextSave);
            this.selectAll();
            this.requestFocus();
        }
        this.folderChangeInitiatedByLocationField = false;
    }

    public void locationChanging(LocationEvent e) {
        if (!this.folderChangeInitiatedByLocationField) {
            String locationText;
            FileURL folderURL = e.getFolderURL();
            if (folderURL.getScheme().equals("file")) {
                if ("localhost".equals(folderURL.getHost())) {
                    locationText = folderURL.getPath();
                    if (LocalFile.hasRootDrives()) {
                        locationText = PathUtils.removeLeadingSeparator(locationText, "/");
                    }
                } else {
                    locationText = "\\\\" + folderURL.getHost() + folderURL.getPath().replace('/', '\\');
                    if (!locationText.endsWith("\\")) {
                        locationText = locationText + "\\";
                    }
                }
            } else {
                locationText = folderURL.toString(false);
            }
            this.setText(locationText);
        }
        this.setEnabled(false);
    }

    public void locationChanged(LocationEvent e) {
        this.folderChangeCompleted(true);
    }

    public void locationCancelled(LocationEvent e) {
        this.folderChangeCompleted(false);
    }

    public void locationFailed(LocationEvent e) {
        this.folderChangeCompleted(false);
    }

    public boolean textFieldValidated() {
        String variableKey;
        String variableValue;
        Matcher matcher;
        String location = this.getText();
        if (OsFamilies.WINDOWS.isCurrent() && location.indexOf(":\\") == 1 && (matcher = windowsTrailingSpacePattern.matcher(location)).find()) {
            location = location.substring(0, matcher.start());
        }
        this.locationFieldTextSave = location;
        boolean tryToInterpretEnteredString = true;
        Bookmark b = BookmarkManager.getBookmark(location);
        if (b != null) {
            location = b.getLocation();
            this.setText(location);
            tryToInterpretEnteredString = false;
        }
        AbstractFile[] volumes = LocalFile.getVolumes();
        for (int i = 0; tryToInterpretEnteredString && i < volumes.length; ++i) {
            if (!volumes[i].getName().equalsIgnoreCase(location)) continue;
            location = volumes[i].getAbsolutePath();
            this.setText(location);
            tryToInterpretEnteredString = false;
        }
        if (tryToInterpretEnteredString && location.startsWith("$") && (variableValue = System.getenv(variableKey = location.substring(1))) != null) {
            location = variableValue;
            this.setText(location);
        }
        this.folderChangeInitiatedByLocationField = true;
        return this.folderPanel.tryChangeCurrentFolder(location) == null;
    }

    public void textFieldCancelled() {
        this.setText(this.folderPanel.getCurrentFolder().getAbsolutePath());
        this.transferFocus();
    }

    public void focusGained(FocusEvent e) {
        this.folderPanel.getMainFrame().getJMenuBar().setEnabled(false);
    }

    public void focusLost(FocusEvent e) {
        this.folderPanel.getMainFrame().getJMenuBar().setEnabled(true);
    }

    public void colorChanged(ColorChangedEvent event) {
        switch (event.getColorId()) {
            case 49: {
                this.setProgressColor(event.getColor());
                break;
            }
            case 45: {
                this.setDisabledTextColor(event.getColor());
                this.setForeground(event.getColor());
                break;
            }
            case 46: {
                this.setBackground(event.getColor());
                break;
            }
            case 47: {
                this.setSelectedTextColor(event.getColor());
                break;
            }
            case 48: {
                this.setSelectionColor(event.getColor());
            }
        }
    }

    public void fontChanged(FontChangedEvent event) {
        if (event.getFontId() == 3) {
            this.setFont(event.getFont());
        }
    }

    static {
        if (OsFamilies.WINDOWS.isCurrent()) {
            windowsTrailingSpacePattern = Pattern.compile("[ ]+[\\\\]*$");
        }
    }
}

