/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main;

import com.mucommander.commons.conf.ConfigurationEvent;
import com.mucommander.commons.conf.ConfigurationListener;
import com.mucommander.commons.file.filter.AndFileFilter;
import com.mucommander.commons.file.filter.AttributeFileFilter;
import com.mucommander.commons.file.filter.FileFilter;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.ui.main.DSStoreFileFilter;
import com.mucommander.ui.main.SystemFileFilter;

public class ConfigurableFolderFilter
extends AndFileFilter
implements ConfigurationListener {
    private FileFilter hiddenFileFilter = new AttributeFileFilter(5, true);
    private FileFilter dsFileFilter = new DSStoreFileFilter();
    private FileFilter systemFileFilter = new SystemFileFilter();

    public ConfigurableFolderFilter() {
        super(new FileFilter[0]);
        this.configureFilters();
        MuConfigurations.addPreferencesListener(this);
    }

    private void configureFilters() {
        if (!MuConfigurations.getPreferences().getVariable(MuPreference.SHOW_HIDDEN_FILES, true)) {
            this.addFileFilter(this.hiddenFileFilter);
        }
        if (!MuConfigurations.getPreferences().getVariable(MuPreference.SHOW_DS_STORE_FILES, true)) {
            this.addFileFilter(this.dsFileFilter);
        }
        if (!MuConfigurations.getPreferences().getVariable(MuPreference.SHOW_SYSTEM_FOLDERS, true)) {
            this.addFileFilter(this.systemFileFilter);
        }
    }

    public void configurationChanged(ConfigurationEvent event) {
        String var = event.getVariable();
        if (var.equals("file_table.show_hidden_files")) {
            if (event.getBooleanValue()) {
                this.removeFileFilter(this.hiddenFileFilter);
            } else {
                this.addFileFilter(this.hiddenFileFilter);
            }
        } else if (var.equals("file_table.show_ds_store_files")) {
            if (event.getBooleanValue()) {
                this.removeFileFilter(this.dsFileFilter);
            } else {
                this.addFileFilter(this.dsFileFilter);
            }
        } else if (var.equals("file_table.show_system_folders")) {
            if (event.getBooleanValue()) {
                this.removeFileFilter(this.systemFileFilter);
            } else {
                this.addFileFilter(this.systemFileFilter);
            }
        }
    }
}

