/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.macosx;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.mucommander.Launcher;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.ui.macosx.OSXIntegration;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.WindowManager;

class EAWTHandler
implements ApplicationListener {
    public EAWTHandler() {
        Application app = new Application();
        app.setEnabledAboutMenu(true);
        app.setEnabledPreferencesMenu(true);
        app.addApplicationListener((ApplicationListener)this);
    }

    public void handleAbout(ApplicationEvent event) {
        event.setHandled(true);
        OSXIntegration.showAbout();
    }

    public void handlePreferences(ApplicationEvent event) {
        event.setHandled(true);
        OSXIntegration.showPreferences();
    }

    public void handleQuit(ApplicationEvent event) {
        event.setHandled(OSXIntegration.doQuit());
    }

    public void handleOpenApplication(ApplicationEvent event) {
    }

    public void handleReOpenApplication(ApplicationEvent event) {
    }

    public void handleOpenFile(ApplicationEvent event) {
        Launcher.waitUntilLaunched();
        AbstractFile file = FileFactory.getFile(event.getFilename());
        FolderPanel activePanel = WindowManager.getCurrentMainFrame().getActivePanel();
        if (file.isBrowsable()) {
            activePanel.tryChangeCurrentFolder(file);
        } else {
            activePanel.tryChangeCurrentFolder(file.getParent(), file, false);
        }
    }

    public void handlePrintFile(ApplicationEvent event) {
    }
}

