/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.list;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.FileSet;
import java.awt.Component;
import java.awt.Font;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;

public class FileList
extends JList {
    protected FileSet files;
    protected boolean fileAttributesPreloaded;
    protected String[] filenames;
    protected Icon[] icons;
    protected Font customFont;

    public FileList(final FileSet files, boolean preloadFileAttributes) {
        this.files = files;
        int nbFiles = files.size();
        if (nbFiles > 0) {
            this.setPrototypeCellValue(files.elementAt(0));
        }
        if (preloadFileAttributes) {
            this.filenames = new String[nbFiles];
            this.icons = new Icon[nbFiles];
            for (int i = 0; i < nbFiles; ++i) {
                AbstractFile file = (AbstractFile)files.elementAt(i);
                this.filenames[i] = file.getName();
                this.icons[i] = file.getIcon();
            }
            this.fileAttributesPreloaded = true;
        }
        this.setModel(new AbstractListModel(){

            public int getSize() {
                return files.size();
            }

            public Object getElementAt(int index) {
                return files.elementAt(index);
            }
        });
        this.customFont = new JLabel().getFont();
        this.customFont = this.customFont.deriveFont(this.customFont.getStyle(), this.customFont.getSize() - 2);
        this.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                label.setFont(FileList.this.customFont);
                if (FileList.this.fileAttributesPreloaded) {
                    label.setText(FileList.this.filenames[index]);
                    label.setIcon(FileList.this.icons[index]);
                } else {
                    AbstractFile file = (AbstractFile)value;
                    label.setText(file.getName());
                    label.setIcon(file.getIcon());
                }
                return label;
            }
        });
    }
}

