/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.list;

import com.mucommander.commons.collections.AlteredVector;
import com.mucommander.commons.collections.VectorChangeListener;
import com.mucommander.text.Translator;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicList<E>
extends JList {
    private AlteredVector<E> items;
    private DynamicListModel model;
    private MoveUpAction moveUpAction;
    private MoveDownAction moveDownAction;
    private RemoveAction removeAction;

    public DynamicList(AlteredVector<E> items) {
        this.items = items;
        this.model = new DynamicListModel();
        this.setModel(this.model);
        this.items.addVectorChangeListener(this.model);
        this.setSelectionMode(0);
        if (items.size() > 0) {
            this.setSelectedIndex(0);
        }
        this.moveUpAction = new MoveUpAction();
        this.moveDownAction = new MoveDownAction();
        this.removeAction = new RemoveAction();
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        Class<?> actionClass = this.removeAction.getClass();
        inputMap.put(KeyStroke.getKeyStroke(127, 0), actionClass);
        inputMap.put(KeyStroke.getKeyStroke(8, 0), actionClass);
        actionMap.put(actionClass, this.removeAction);
        actionClass = this.moveUpAction.getClass();
        inputMap.put(KeyStroke.getKeyStroke(38, 1), actionClass);
        inputMap.put(KeyStroke.getKeyStroke(38, 4), actionClass);
        inputMap.put(KeyStroke.getKeyStroke(37, 1), actionClass);
        inputMap.put(KeyStroke.getKeyStroke(37, 4), actionClass);
        actionMap.put(actionClass, this.moveUpAction);
        actionClass = this.moveDownAction.getClass();
        inputMap.put(KeyStroke.getKeyStroke(40, 1), actionClass);
        inputMap.put(KeyStroke.getKeyStroke(40, 4), actionClass);
        inputMap.put(KeyStroke.getKeyStroke(39, 1), actionClass);
        inputMap.put(KeyStroke.getKeyStroke(39, 4), actionClass);
        actionMap.put(actionClass, this.moveDownAction);
    }

    public void selectAndScroll(int index) {
        this.setSelectedIndex(index);
        this.ensureIndexIsVisible(index);
    }

    public boolean isIndexValid(int index) {
        return index >= 0 && index < this.items.size();
    }

    public void itemModified(int index, boolean selectItem) {
        if (!this.isIndexValid(index)) {
            return;
        }
        this.model.notifyModified(index);
    }

    public void moveItem(int index, boolean moveUp) {
        int newIndex;
        if (!this.isIndexValid(index)) {
            return;
        }
        if (moveUp) {
            if (index < 1) {
                return;
            }
            newIndex = index - 1;
        } else {
            if (index >= this.items.size() - 1) {
                return;
            }
            newIndex = index + 1;
        }
        Object tmp = this.items.elementAt(index);
        this.items.setElementAt(this.items.elementAt(newIndex), index);
        this.items.setElementAt(tmp, newIndex);
        this.selectAndScroll(newIndex);
    }

    public Action getMoveUpAction() {
        return this.moveUpAction;
    }

    public Action getMoveDownAction() {
        return this.moveDownAction;
    }

    public Action getRemoveAction() {
        return this.removeAction;
    }

    private class RemoveAction
    extends AbstractAction {
        private RemoveAction() {
            this.putValue("Name", Translator.get("delete", new String[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int selectedIndex = DynamicList.this.getSelectedIndex();
            if (!DynamicList.this.isIndexValid(selectedIndex)) {
                return;
            }
            DynamicList.this.items.removeElementAt(selectedIndex);
            int nbItems = DynamicList.this.items.size();
            if (nbItems > 0) {
                DynamicList.this.selectAndScroll(Math.min(selectedIndex, nbItems - 1));
            }
            DynamicList.this.requestFocus();
        }
    }

    private class MoveDownAction
    extends AbstractAction {
        private MoveDownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DynamicList.this.moveItem(DynamicList.this.getSelectedIndex(), false);
            DynamicList.this.requestFocus();
        }
    }

    private class MoveUpAction
    extends AbstractAction {
        private MoveUpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DynamicList.this.moveItem(DynamicList.this.getSelectedIndex(), true);
            DynamicList.this.requestFocus();
        }
    }

    private class DynamicListModel
    extends AbstractListModel
    implements VectorChangeListener {
        private DynamicListModel() {
        }

        public int getSize() {
            return DynamicList.this.items.size();
        }

        public Object getElementAt(int i) {
            if (i < 0 || i >= DynamicList.this.items.size()) {
                return null;
            }
            return DynamicList.this.items.elementAt(i);
        }

        private void notifyAdded(int fromIndex, int toIndex) {
            this.fireIntervalAdded(this, fromIndex, toIndex);
        }

        private void notifyRemoved(int fromIndex, int toIndex) {
            this.fireIntervalRemoved(this, fromIndex, toIndex);
        }

        private void notifyModified(int index) {
            this.fireContentsChanged(this, index, index);
        }

        public void elementsAdded(int startIndex, int nbAdded) {
            DynamicList.this.model.notifyAdded(startIndex, startIndex + nbAdded - 1);
        }

        public void elementsRemoved(int startIndex, int nbRemoved) {
            DynamicList.this.model.notifyRemoved(startIndex, startIndex + nbRemoved - 1);
        }

        public void elementChanged(int index) {
            DynamicList.this.model.notifyModified(index);
        }
    }
}

