/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.list;

import com.mucommander.commons.collections.AlteredVector;
import com.mucommander.ui.list.DynamicList;
import java.awt.Container;
import java.awt.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicHorizontalWrapList<E>
extends DynamicList<E> {
    private int itemWidth;
    private int lastParentWidth;

    public DynamicHorizontalWrapList(AlteredVector<E> items, int itemWidth, int horizontalPadding) {
        super(items);
        this.itemWidth = itemWidth + horizontalPadding;
        this.setLayoutOrientation(2);
    }

    @Override
    public void repaint() {
        Container parent = this.getParent();
        if (parent != null) {
            Rectangle parentBounds = parent.getBounds();
            int parentWidth = parentBounds.width;
            if (this.lastParentWidth != parentWidth) {
                this.lastParentWidth = parentWidth;
                int itemsPerRow = parentWidth / this.itemWidth;
                this.setFixedCellWidth(this.itemWidth + (parentWidth - this.itemWidth * itemsPerRow) / itemsPerRow);
                this.setVisibleRowCount(this.getComponentCount() / itemsPerRow);
            }
        }
        super.repaint();
    }
}

