/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.layout;

import com.mucommander.desktop.DesktopManager;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class ProportionalSplitPane
extends JSplitPane
implements ComponentListener,
MouseListener {
    private int windowWidth;
    private int lastDividerLocation = -1;
    private float splitRatio = 0.5f;
    private Window window;

    public ProportionalSplitPane(Window window, int orientation, boolean continuousLayout, JComponent leftComponent, JComponent rightComponent) {
        super(orientation, continuousLayout, leftComponent, rightComponent);
        this.init(window, leftComponent, rightComponent);
    }

    private void init(Window window, JComponent leftComponent, JComponent rightComponent) {
        this.window = window;
        window.addComponentListener(this);
        BasicSplitPaneDivider divider = this.getDividerComponent();
        divider.addComponentListener(this);
        divider.addMouseListener(this);
        Dimension nullDimension = new Dimension(0, 0);
        if (leftComponent != null) {
            leftComponent.setMinimumSize(nullDimension);
        }
        if (rightComponent != null) {
            rightComponent.setMinimumSize(nullDimension);
        }
    }

    public void updateDividerLocation() {
        if (!this.window.isVisible()) {
            return;
        }
        this.lastDividerLocation = -1;
        this.setDividerLocation(this.splitRatio);
    }

    public void setSplitRatio(float splitRatio) {
        this.splitRatio = splitRatio;
        this.updateDividerLocation();
    }

    public BasicSplitPaneDivider getDividerComponent() {
        return ((BasicSplitPaneUI)this.getUI()).getDivider();
    }

    public void disableAccessibilityShortcuts() {
        InputMap inputMap = this.getInputMap(1);
        inputMap.clear();
        inputMap.setParent(null);
    }

    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
        this.updateDividerLocation();
    }

    public void componentResized(ComponentEvent e) {
        Object source = e.getSource();
        if (source == this.window) {
            this.windowWidth = this.window.getWidth();
            this.updateDividerLocation();
        }
    }

    public void componentMoved(ComponentEvent e) {
        if (e.getSource() == this.getDividerComponent()) {
            if (this.lastDividerLocation == -1) {
                this.lastDividerLocation = this.getDividerLocation();
                return;
            }
            if (this.lastDividerLocation == this.getDividerLocation()) {
                return;
            }
            if (this.windowWidth != this.window.getWidth()) {
                this.windowWidth = this.window.getWidth();
                return;
            }
            this.lastDividerLocation = this.getDividerLocation();
            this.splitRatio = (float)this.lastDividerLocation / (float)(this.getOrientation() == 1 ? this.getWidth() : this.getHeight());
        }
    }

    public void componentShown(ComponentEvent e) {
        if (e.getSource() == this.window) {
            this.updateDividerLocation();
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (DesktopManager.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
            this.setSplitRatio(0.5f);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

