/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.icon;

import com.mucommander.ui.icon.AnimatedIcon;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class SpinningDial
extends AnimatedIcon {
    public static final Color DEFAULT_COLOR = Color.BLACK;
    private int width;
    private int height;
    private Image[] frames;
    private Color color;
    private float strokeWidth;

    public SpinningDial() {
        this(16, 16);
    }

    public SpinningDial(boolean animate) {
        this(16, 16, animate);
    }

    public SpinningDial(int w, int h) {
        this(w, h, 12);
    }

    public SpinningDial(int w, int h, boolean animate) {
        this(w, h, 12, animate);
    }

    public SpinningDial(int w, int h, int spokes) {
        this(w, h, spokes, DEFAULT_COLOR);
    }

    public SpinningDial(int w, int h, int spokes, boolean animate) {
        this(w, h, spokes, DEFAULT_COLOR, animate);
    }

    public SpinningDial(int w, int h, int spokes, Color c) {
        this(w, h, spokes, c, false);
    }

    public SpinningDial(int w, int h, int spokes, Color c, boolean animate) {
        super(spokes, 1000 / spokes);
        this.width = w;
        this.height = h;
        this.color = c;
        this.frames = new Image[this.getFrameCount()];
        this.strokeWidth = 25.6f;
        if (animate) {
            this.setAnimated(true);
        }
    }

    protected Color getSpokeColor(int alpha) {
        return new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), Math.max(32, alpha));
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    private void initialiseGraphics(Graphics2D graphics) {
        float scale = (float)Math.min(this.width, this.height) / 256.0f;
        graphics.setComposite(AlphaComposite.Clear);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setComposite(AlphaComposite.Src);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setStroke(new BasicStroke(this.strokeWidth, 1, 1));
        graphics.translate((float)this.width / 2.0f, (float)this.height / 2.0f);
        graphics.scale(scale, scale);
    }

    public synchronized void paintFrame(Component c, Graphics graphics, int x, int y) {
        if (this.isAnimated()) {
            int currentFrame = this.getFrame();
            if (this.frames[currentFrame] == null) {
                GraphicsConfiguration gc;
                BufferedImage frame = c != null && (gc = c.getGraphicsConfiguration()) != null ? gc.createCompatibleImage(this.width, this.height, 3) : new BufferedImage(this.width, this.height, 2);
                Graphics2D g = (Graphics2D)((Image)frame).getGraphics();
                this.initialiseGraphics(g);
                int alpha = 255;
                int radius = 127 - (int)(this.strokeWidth / 2.0f);
                for (int i = 0; i < this.getFrameCount(); ++i) {
                    double cos = Math.cos(Math.PI * 2 - Math.PI * 2 * (double)(i - currentFrame) / (double)this.getFrameCount());
                    double sin = Math.sin(Math.PI * 2 - Math.PI * 2 * (double)(i - currentFrame) / (double)this.getFrameCount());
                    g.setColor(this.getSpokeColor(alpha));
                    g.drawLine((int)((double)((float)radius * 0.6f) * cos), (int)((double)((float)radius * 0.6f) * sin), (int)((double)radius * cos), (int)((double)radius * sin));
                    alpha = Math.max(32, alpha * 3 / 4);
                }
                g.dispose();
                this.frames[currentFrame] = frame;
            }
            graphics.drawImage(this.frames[currentFrame], x, y, null);
        }
    }

    public void setAnimated(boolean a) {
        super.setAnimated(a);
        if (!a) {
            this.repaint();
        }
    }
}

