/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.icon;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.icon.FileIconProvider;
import com.mucommander.ui.icon.IconManager;
import java.awt.Dimension;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class CustomFileIconProvider
implements FileIconProvider {
    private static boolean initialized;
    private static Map<String, String> extensionMap;
    static final String[][] ICON_EXTENSIONS;

    private static void init() {
        extensionMap = new Hashtable<String, String>();
        int nbIcons = ICON_EXTENSIONS.length;
        for (int i = 0; i < nbIcons; ++i) {
            int nbExtensions = ICON_EXTENSIONS[i].length;
            String iconName = ICON_EXTENSIONS[i][0];
            for (int j = 1; j < nbExtensions; ++j) {
                extensionMap.put(ICON_EXTENSIONS[i][j], iconName);
            }
        }
        initialized = true;
    }

    private static ImageIcon getSymlinkIcon(Icon targetIcon) {
        return IconManager.getCompositeIcon(targetIcon, IconManager.getIcon(0, "link.png"));
    }

    public Icon getFileIcon(AbstractFile file, Dimension preferredResolution) {
        ImageIcon icon;
        boolean isSymlink;
        if (!initialized) {
            CustomFileIconProvider.init();
        }
        if (isSymlink = file.isSymlink()) {
            file = file.getCanonicalFile();
        }
        String fileExtension = file.getExtension();
        if (!"file".equals(file.getURL().getScheme()) && file.isRoot()) {
            icon = IconManager.getIcon(0, "network.png");
        } else if (file.isDirectory()) {
            icon = fileExtension != null && fileExtension.equals("app") ? IconManager.getIcon(0, "executable_osx.png") : IconManager.getIcon(0, "folder.png");
        } else if (file.isBrowsable()) {
            icon = IconManager.getIcon(0, "archive_supported.png");
        } else if (fileExtension == null) {
            icon = IconManager.getIcon(0, "file.png");
        } else {
            String iconName = extensionMap.get(fileExtension.toLowerCase());
            if (iconName == null) {
                icon = IconManager.getIcon(0, "file.png");
            } else {
                icon = IconManager.getIcon(0, iconName);
                if (icon == null) {
                    return IconManager.getIcon(0, "file.png");
                }
            }
        }
        if (isSymlink) {
            return CustomFileIconProvider.getSymlinkIcon(icon);
        }
        return icon;
    }

    static {
        ICON_EXTENSIONS = new String[][]{{"archive_unsupported.png", "7z", "ace", "arj", "bin", "bz", "cab", "dmg", "hqx", "ipk", "lha", "lzh", "lzx", "msi", "mpkg", "pak", "pkg", "pq6", "rar", "rk", "rz", "sea", "sit", "sitx", "sqx", "z", "zoo"}, {"audio.png", "aac", "aif", "aiff", "aifc", "amr", "ape", "au", "cda", "mp3", "mpa", "mp2", "mpc", "m3u", "m4a", "m4b", "m4p", "nap", "ogg", "pls", "ra", "ram", "wav", "wave", "flac", "wma", "mid", "midi", "smf", "mod", "mtm", "xm", "s3m", "mka"}, {"cd_image.png", "iso", "nrg"}, {"certificate.png", "cer", "crt", "key"}, {"configuration.png", "cnf", "conf", "config", "inf", "ini", "pif", "prefs", "prf"}, {"database.png", "myi", "myd", "frm", "sql", "sqc", "sqr", "mdb", "mde", "mdn", "mdt", "accdb", "accde", "accdr", "accdt"}, {"executable_windows.png", "bat", "com", "exe"}, {"feed.png", "rdf", "rss"}, {"font.png", "fnt", "fon", "otf"}, {"font_truetype.png", "ttc", "ttf"}, {"image_bitmap.png", "exif", "ico", "gif", "j2k", "jpg", "jpeg", "jpg2", "jp2", "bmp", "ico", "iff", "mng", "pcd", "pic", "pict", "png", "psd", "psp", "pbm", "pgm", "ppm", "raw", "tga", "tiff", "tif", "wbmp", "xbm", "xcf", "xpm"}, {"image_vector.png", "ai", "cgm", "dpx", "dxf", "eps", "emf", "ps", "svg", "svgz", "wmf", "xar"}, {"library.png", "dylib", "la", "o", "so"}, {"linux.png", "deb", "rpm"}, {"macromedia_actionscript.png", "as"}, {"macromedia_flash.png", "swf", "swd", "swa", "swc", "fla", "flv", "flp", "jsfl"}, {"macromedia_freehand.png", "fh", "fhd"}, {"ms_excel.png", "xls", "xla", "xlb", "xlc", "xld", "xlk", "xll", "xlm", "xlr", "xlt", "xlv", "xlw", "xlshtml", "xlsmhtml", "xlthtml", "xlsx", "xltx", "xlsm", "xltm", "xlam", "xlsb"}, {"ms_word.png", "doc", "wbk", "wiz", "wpg", "wpk", "wpm", "wpt", "wrs", "wwl", "docx", "dotx", "docm", "dotm"}, {"ms_powerpoint.png", "pcb", "pot", "ppa", "ppi", "pps", "ppt", "pwz", "pptx", "potx", "ppsx", "pptm", "potm", "ppsm"}, {"ms_visualstudio.png", "atp", "dbp", "hxc", "ncb", "pch", "pdb", "sln", "suo", "srf", "vaf", "vam", "vbg", "vbp", "vbproj", "vcproj", "vdp", "vdproj", "vip", "vmx", "vsdir", "vsmacros", "vsmproj", "vup"}, {"ms_windows_shortcut.png", "lnk"}, {"pdf.png", "pdf"}, {"source.png", "asm", "asp", "bas", "bcp", "cbl", "cob", "f", "fpp", "inc", "js", "lsp", "m4", "pas", "pl", "py", "src", "vb", "vbe", "vbs", "x"}, {"source.png", "awk", "csh", "esh", "sh", "ksh", "ws", "wsf"}, {"source_c.png", "c", "cc"}, {"source_c_header.png", "h", "hh", "hhh"}, {"source_cplusplus.png", "cpp", "c++"}, {"source_csharp.png", "c#=", "cs"}, {"source_java.png", "java", "jsp"}, {"source_php.png", "php", "php3", "php4", "php5", "phtm", "phtml"}, {"source_ruby.png", "rb", "rbx", "rhtml"}, {"source_web.png", "html", "htm", "xhtml", "wml", "wmlc", "wmls", "wmlsc", "hdml", "xhdml", "chtml", "vrml", "torrent", "url", "css"}, {"source_xml.png", "xml", "dtd", "xfd", "xfdl", "xmap", "xmi", "xsc", "xsd", "xsl", "xslt", "xtd", "xul", "rss", "jnlp", "plist"}, {"text.png", "1st", "ans", "asc", "ascii", "diz", "err", "faq", "latex", "log", "man", "msg", "nfo", "readme", "rtf", "sig", "tex", "text", "txt"}, {"vcard.png", "vcf"}, {"video.png", "3g2", "3gp", "3gp2", "3gpp", "asf", "asx", "avi", "dir", "dv", "dxr", "m1v", "m4e", "m4u", "moov", "mov", "movie", "mp4", "mpe", "mpeg", "mpg", "mpv2", "qt", "rm", "rmvb", "rts", "vob", "wmv", "divx", "mkv"}};
    }
}

