/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.icon;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class AnimatedIcon
implements Icon {
    private HashSet<TrackedComponent> components = new HashSet();
    private Timer timer;
    private int currentFrame;
    private int frameCount;
    private boolean animate;

    public AnimatedIcon() {
        this(8, 125);
    }

    public AnimatedIcon(int frameCount, int repaintDelay) {
        this.timer = new Timer(repaintDelay, new AnimationUpdater(this));
        this.timer.setRepeats(true);
        this.setFrameCount(frameCount);
        this.setFrameDelay(repaintDelay);
    }

    public abstract int getIconWidth();

    public abstract int getIconHeight();

    protected abstract void paintFrame(Component var1, Graphics var2, int var3, int var4);

    public synchronized void setFrameCount(int count) {
        this.frameCount = count;
    }

    public synchronized int getFrameCount() {
        return this.frameCount;
    }

    public synchronized int getFrame() {
        return this.currentFrame;
    }

    public synchronized void setFrame(int frame) {
        if (frame != this.currentFrame) {
            this.currentFrame = frame == 0 ? 0 : frame % this.frameCount;
            this.repaint();
        }
    }

    public synchronized void nextFrame() {
        this.setFrame(this.currentFrame + 1);
    }

    public synchronized void setFrameDelay(int delay) {
        this.timer.setDelay(delay);
    }

    public synchronized void setAnimated(boolean a) {
        if (a) {
            if (!this.timer.isRunning()) {
                this.timer.restart();
            }
        } else if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.animate = a;
    }

    public synchronized boolean isAnimated() {
        return this.animate;
    }

    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        this.paintFrame(c, g, x, y);
        if (c != null) {
            AffineTransform transform = ((Graphics2D)g).getTransform();
            this.components.add(new TrackedComponent(c, x, y, (int)((double)this.getIconWidth() * transform.getScaleX()), (int)((double)this.getIconHeight() * transform.getScaleY())));
            if (!this.timer.isRunning() && this.animate) {
                this.timer.restart();
            }
        }
    }

    protected synchronized void repaint() {
        if (this.components.isEmpty()) {
            this.timer.stop();
        } else {
            for (TrackedComponent comp : this.components) {
                comp.repaint();
            }
            this.components.clear();
        }
    }

    protected void finalize() throws Throwable {
        this.timer.stop();
        super.finalize();
    }

    private static class AnimationUpdater
    implements ActionListener {
        private WeakReference<AnimatedIcon> icon;

        public AnimationUpdater(AnimatedIcon icon) {
            this.icon = new WeakReference<AnimatedIcon>(icon);
        }

        public void actionPerformed(ActionEvent event) {
            AnimatedIcon i = (AnimatedIcon)this.icon.get();
            if (i != null) {
                i.nextFrame();
            }
        }
    }

    private static class TrackedComponent {
        private Component component;
        private int x;
        private int y;
        private int width;
        private int height;
        private int hashCode;

        public TrackedComponent(Component c, int x, int y, int width, int height) {
            Component ancestor = this.findNonRendererAncestor(c);
            if (ancestor != c) {
                Point pt = SwingUtilities.convertPoint(c, x, y, ancestor);
                c = ancestor;
                x = pt.x;
                y = pt.y;
            }
            this.component = c;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.hashCode = (x + "," + y + ":" + c.hashCode()).hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        private Component findNonRendererAncestor(Component component) {
            Container container = SwingUtilities.getAncestorOfClass(CellRendererPane.class, component);
            if (container != null && container != component && container.getParent() != null) {
                component = this.findNonRendererAncestor(container.getParent());
            }
            return component;
        }

        public void repaint() {
            this.component.repaint(this.x, this.y, this.width, this.height);
        }
    }
}

