/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.helper;

import java.util.List;
import java.util.Vector;
import javax.swing.JButton;

public class MnemonicHelper {
    private List<Character> takenMnemonics = new Vector<Character>();

    public char getMnemonic(String text) {
        if (text == null || text.length() == 0) {
            return '\u0000';
        }
        int mnemonicPos = 0;
        text = text.toLowerCase();
        int textLength = text.length();
        do {
            char mnemonic;
            if (this.isMnemonicUsed(mnemonic = text.charAt(mnemonicPos++))) continue;
            this.takenMnemonics.add(Character.valueOf(mnemonic));
            return mnemonic;
        } while (mnemonicPos < textLength);
        return '\u0000';
    }

    public char getMnemonic(JButton button) {
        return this.getMnemonic(button.getText());
    }

    public boolean isMnemonicUsed(char ch) {
        return this.takenMnemonics.indexOf(new Character(ch)) != -1;
    }

    public void clear() {
        this.takenMnemonics.clear();
    }
}

