/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.helper;

import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.helper.MnemonicHelper;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuListener;

public class MenuToolkit {
    public static JMenu addMenu(String title, MnemonicHelper mnemonicHelper, MenuListener menuListener) {
        char mnemonic;
        JMenu menu = new JMenu(title);
        if (mnemonicHelper != null && (mnemonic = mnemonicHelper.getMnemonic(title)) != '\u0000') {
            menu.setMnemonic(mnemonic);
        }
        if (menuListener != null) {
            menu.addMenuListener(menuListener);
        }
        return menu;
    }

    public static JMenuItem addMenuItem(JMenu menu, String text, MnemonicHelper mnemonicHelper, KeyStroke accelerator, ActionListener actionListener) {
        return MenuToolkit.addMenuItem(menu, text, mnemonicHelper, accelerator, actionListener, false);
    }

    public static JCheckBoxMenuItem addCheckBoxMenuItem(JMenu menu, String text, MnemonicHelper mnemonicHelper, KeyStroke accelerator, ActionListener actionListener) {
        return (JCheckBoxMenuItem)MenuToolkit.addMenuItem(menu, text, mnemonicHelper, accelerator, actionListener, true);
    }

    private static JMenuItem addMenuItem(JMenu menu, String text, MnemonicHelper mnemonicHelper, KeyStroke accelerator, ActionListener actionListener, boolean createCheckBoxMenuItem) {
        char mnemonic;
        JMenuItem menuItem;
        JMenuItem jMenuItem = menuItem = createCheckBoxMenuItem ? new JCheckBoxMenuItem(text, false) : new JMenuItem(text);
        if (mnemonicHelper != null && (mnemonic = mnemonicHelper.getMnemonic(text)) != '\u0000') {
            menuItem.setMnemonic(mnemonic);
        }
        if (accelerator != null) {
            menuItem.setAccelerator(accelerator);
        }
        if (actionListener != null) {
            menuItem.addActionListener(actionListener);
        }
        menu.add(menuItem);
        return menuItem;
    }

    public static JMenuItem addMenuItem(JMenu menu, MuAction action, MnemonicHelper mnemonicHelper) {
        return MenuToolkit.addMenuItem(menu, action, mnemonicHelper, false);
    }

    public static JCheckBoxMenuItem addCheckBoxMenuItem(JMenu menu, MuAction action, MnemonicHelper mnemonicHelper) {
        return (JCheckBoxMenuItem)MenuToolkit.addMenuItem(menu, action, mnemonicHelper, true);
    }

    private static JMenuItem addMenuItem(JMenu menu, MuAction action, MnemonicHelper mnemonicHelper, boolean createCheckBoxMenuItem) {
        char mnemonic;
        JMenuItem menuItem;
        JMenuItem jMenuItem = menuItem = createCheckBoxMenuItem ? new JCheckBoxMenuItem(action) : new JMenuItem(action);
        if (mnemonicHelper != null && (mnemonic = mnemonicHelper.getMnemonic(action.getLabel())) != '\u0000') {
            menuItem.setMnemonic(mnemonic);
        }
        menuItem.setIcon(null);
        menu.add(menuItem);
        return menuItem;
    }
}

