/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.helper;

import java.awt.Component;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FocusRequester
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FocusRequester.class);
    private Component c;
    private boolean requestFocusInWindow;

    private FocusRequester(Component c, boolean requestFocusInWindow) {
        this.c = c;
        this.requestFocusInWindow = requestFocusInWindow;
    }

    public static synchronized void requestFocus(Component c) {
        if (c == null) {
            LOGGER.debug(">>>>>>>>>>>>>>>>>> Component is null, returning!");
            return;
        }
        SwingUtilities.invokeLater(new FocusRequester(c, false));
    }

    public static synchronized void requestFocusInWindow(Component c) {
        if (c == null) {
            LOGGER.debug(">>>>>>>>>>>>>>>>>> Component is null, returning!");
            return;
        }
        SwingUtilities.invokeLater(new FocusRequester(c, true));
    }

    public void run() {
        if (this.requestFocusInWindow) {
            this.c.requestFocusInWindow();
        } else {
            this.c.requestFocus();
        }
        LOGGER.debug("focus requested on " + this.c.getClass().getName());
        this.c = null;
    }
}

