/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.event;

import com.mucommander.commons.file.FileURL;
import com.mucommander.ui.event.LocationEvent;
import com.mucommander.ui.event.LocationListener;
import com.mucommander.ui.main.FolderPanel;
import java.util.WeakHashMap;

public class LocationManager {
    private WeakHashMap<LocationListener, ?> locationListeners = new WeakHashMap();
    private FolderPanel folderPanel;

    public LocationManager(FolderPanel folderPanel) {
        this.folderPanel = folderPanel;
    }

    public synchronized void addLocationListener(LocationListener listener) {
        this.locationListeners.put(listener, null);
    }

    public synchronized void removeLocationListener(LocationListener listener) {
        this.locationListeners.remove(listener);
    }

    public synchronized void fireLocationChanging(FileURL folderURL) {
        for (LocationListener listener : this.locationListeners.keySet()) {
            listener.locationChanging(new LocationEvent(this.folderPanel, folderURL));
        }
    }

    public synchronized void fireLocationChanged(FileURL folderURL) {
        for (LocationListener listener : this.locationListeners.keySet()) {
            listener.locationChanged(new LocationEvent(this.folderPanel, folderURL));
        }
    }

    public synchronized void fireLocationCancelled(FileURL folderURL) {
        for (LocationListener listener : this.locationListeners.keySet()) {
            listener.locationCancelled(new LocationEvent(this.folderPanel, folderURL));
        }
    }

    public synchronized void fireLocationFailed(FileURL folderURL) {
        for (LocationListener listener : this.locationListeners.keySet()) {
            listener.locationFailed(new LocationEvent(this.folderPanel, folderURL));
        }
    }
}

