/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.encoding;

import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.ui.combobox.SaneComboBox;
import com.mucommander.ui.dialog.DialogOwner;
import com.mucommander.ui.encoding.EncodingListener;
import com.mucommander.ui.encoding.EncodingPreferences;
import com.mucommander.ui.encoding.PreferredEncodingsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.JButton;
import javax.swing.JPanel;

public class EncodingSelectBox
extends JPanel {
    protected SaneComboBox comboBox;
    protected JButton customizeButton;
    protected final WeakHashMap<EncodingListener, ?> listeners = new WeakHashMap();
    protected String currentEncoding;

    public EncodingSelectBox(final DialogOwner dialogOwner, String selectedEncoding) {
        super(new BorderLayout());
        this.comboBox = new SaneComboBox();
        this.populateComboBox(selectedEncoding);
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String oldEncoding = EncodingSelectBox.this.currentEncoding;
                EncodingSelectBox.this.currentEncoding = (String)EncodingSelectBox.this.comboBox.getSelectedItem();
                if (EncodingSelectBox.this.currentEncoding == null || !EncodingSelectBox.this.currentEncoding.equals(oldEncoding)) {
                    EncodingSelectBox.this.fireEncodingListener(oldEncoding, EncodingSelectBox.this.currentEncoding);
                }
            }
        });
        this.add((Component)this.comboBox, "Center");
        this.customizeButton = new JButton("...");
        if (OsFamilies.MAC_OS_X.isCurrent()) {
            this.customizeButton.putClientProperty("JComponent.sizeVariant", "small");
        }
        this.customizeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String selectedEncoding = EncodingSelectBox.this.getSelectedEncoding();
                Window owner = dialogOwner.getOwner();
                if (owner instanceof Frame) {
                    new PreferredEncodingsDialog((Frame)owner).showDialog();
                } else {
                    new PreferredEncodingsDialog((Dialog)owner).showDialog();
                }
                EncodingSelectBox.this.comboBox.removeAllItems();
                EncodingSelectBox.this.populateComboBox(selectedEncoding);
            }
        });
        this.add((Component)this.customizeButton, "East");
    }

    protected void populateComboBox(String selectEncoding) {
        List<String> encodings = EncodingPreferences.getPreferredEncodings();
        if (selectEncoding != null && !encodings.contains(selectEncoding)) {
            selectEncoding = null;
        }
        int nbEncodings = encodings.size();
        for (String encoding : encodings) {
            this.comboBox.addItem(encoding);
        }
        if (selectEncoding != null) {
            this.comboBox.setSelectedItem(selectEncoding);
            this.currentEncoding = selectEncoding;
        } else if (nbEncodings > 0) {
            this.comboBox.setSelectedItem(encodings.get(0));
            this.currentEncoding = selectEncoding;
        }
    }

    public String getSelectedEncoding() {
        int index = this.comboBox.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return (String)this.comboBox.getItemAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEncodingListener(EncodingListener listener) {
        WeakHashMap<EncodingListener, ?> weakHashMap = this.listeners;
        synchronized (weakHashMap) {
            this.listeners.put(listener, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEncodingListener(String oldEncoding, String newEncoding) {
        WeakHashMap<EncodingListener, ?> weakHashMap = this.listeners;
        synchronized (weakHashMap) {
            for (EncodingListener listener : this.listeners.keySet()) {
                listener.encodingChanged(this, oldEncoding, newEncoding);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.comboBox.setEnabled(enabled);
        this.customizeButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }
}

