/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.encoding;

import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.DialogOwner;
import com.mucommander.ui.encoding.EncodingListener;
import com.mucommander.ui.encoding.EncodingPreferences;
import com.mucommander.ui.encoding.PreferredEncodingsDialog;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class EncodingMenu
extends JMenu {
    protected final WeakHashMap<EncodingListener, ?> listeners = new WeakHashMap();
    protected DialogOwner dialogOwner;
    protected String selectedEncoding;

    public EncodingMenu(DialogOwner dialogOwner, String selectedEncoding) {
        super(Translator.get("encoding", new String[0]));
        this.dialogOwner = dialogOwner;
        this.selectedEncoding = selectedEncoding;
        this.populateMenu();
    }

    protected void populateMenu() {
        List<String> encodings = EncodingPreferences.getPreferredEncodings();
        if (this.selectedEncoding != null && !encodings.contains(this.selectedEncoding)) {
            encodings.add(0, this.selectedEncoding);
        }
        int nbEncodings = encodings.size();
        ButtonGroup group = new ButtonGroup();
        for (String enc : encodings) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(enc);
            if (this.selectedEncoding != null && this.selectedEncoding.equals(enc)) {
                item.setSelected(true);
            }
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String oldEncoding = EncodingMenu.this.selectedEncoding;
                    EncodingMenu.this.selectedEncoding = ((JCheckBoxMenuItem)e.getSource()).getText();
                    if (!oldEncoding.equals(EncodingMenu.this.selectedEncoding)) {
                        EncodingMenu.this.fireEncodingListener(oldEncoding, EncodingMenu.this.selectedEncoding);
                    }
                }
            });
            group.add(item);
            this.add(item);
        }
        this.add(new JSeparator());
        JMenuItem customizeItem = new JMenuItem(Translator.get("customize", new String[0]) + "...");
        customizeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Window owner = EncodingMenu.this.dialogOwner.getOwner();
                if (owner instanceof Frame) {
                    new PreferredEncodingsDialog((Frame)owner).showDialog();
                } else {
                    new PreferredEncodingsDialog((Dialog)owner).showDialog();
                }
                EncodingMenu.this.removeAll();
                EncodingMenu.this.populateMenu();
            }
        });
        this.add(customizeItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEncodingListener(EncodingListener listener) {
        WeakHashMap<EncodingListener, ?> weakHashMap = this.listeners;
        synchronized (weakHashMap) {
            this.listeners.put(listener, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEncodingListener(String oldEncoding, String newEncoding) {
        WeakHashMap<EncodingListener, ?> weakHashMap = this.listeners;
        synchronized (weakHashMap) {
            for (EncodingListener listener : this.listeners.keySet()) {
                listener.encodingChanged(this, oldEncoding, newEncoding);
            }
        }
    }
}

