/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dnd;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.job.CopyJob;
import com.mucommander.job.MoveJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.dnd.DnDContext;
import com.mucommander.ui.dnd.TransferableFileSet;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.MainFrame;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDropTargetListener
implements DropTargetListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileDropTargetListener.class);
    private FolderPanel folderPanel;
    private boolean changeFolderOnlyMode;
    private int currentDropAction;
    private boolean dragAccepted;
    private static final int MOVE_ACTION_MODIFIERS_EX = OsFamilies.MAC_OS_X.isCurrent() ? 256 : 512;

    public FileDropTargetListener(FolderPanel folderPanel, boolean changeFolderOnlyMode) {
        this.folderPanel = folderPanel;
        this.changeFolderOnlyMode = changeFolderOnlyMode;
    }

    private Cursor getDragActionCursor(int dropAction, boolean dragAccepted) {
        switch (dropAction) {
            case 1: {
                return dragAccepted ? DragSource.DefaultCopyDrop : DragSource.DefaultCopyNoDrop;
            }
            case 2: {
                return dragAccepted ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop;
            }
            case 0x40000000: {
                return dragAccepted ? DragSource.DefaultLinkDrop : DragSource.DefaultLinkNoDrop;
            }
        }
        return Cursor.getDefaultCursor();
    }

    private boolean acceptOrRejectDragEvent(DropTargetDragEvent event) {
        this.currentDropAction = event.getDropAction();
        boolean bl = this.dragAccepted = event.isDataFlavorSupported(TransferableFileSet.getFileSetDataFlavor()) || event.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || event.isDataFlavorSupported(DataFlavor.getTextPlainUnicodeFlavor());
        if (this.dragAccepted && DnDContext.isDragInitiatedByMucommander()) {
            FolderPanel dragInitiator = DnDContext.getDragInitiator();
            if (dragInitiator == this.folderPanel || dragInitiator.getCurrentFolder().equalsCanonical(this.folderPanel.getCurrentFolder())) {
                this.dragAccepted = false;
            } else {
                int dragModifiers = DnDContext.getDragGestureModifiersEx();
                if (this.currentDropAction == 2 && (dragModifiers & MOVE_ACTION_MODIFIERS_EX) == 0 && (event.getSourceActions() & 1) != 0) {
                    LOGGER.debug("changing default action, was: DnDConstants.ACTION_MOVE, now: DnDConstants.ACTION_COPY");
                    this.currentDropAction = 1;
                }
            }
        }
        LOGGER.trace("dragAccepted=" + this.dragAccepted + " dropAction=" + this.currentDropAction);
        if (this.dragAccepted) {
            event.acceptDrag(this.currentDropAction);
        } else {
            event.rejectDrag();
        }
        LOGGER.trace("cursor=" + this.getDragActionCursor(this.currentDropAction, this.dragAccepted));
        this.folderPanel.setCursor(this.getDragActionCursor(this.currentDropAction, this.dragAccepted));
        return this.dragAccepted;
    }

    public void dragEnter(DropTargetDragEvent event) {
        this.acceptOrRejectDragEvent(event);
    }

    public void dragOver(DropTargetDragEvent event) {
        this.acceptOrRejectDragEvent(event);
    }

    public void dropActionChanged(DropTargetDragEvent event) {
        this.acceptOrRejectDragEvent(event);
    }

    public void dragExit(DropTargetEvent event) {
        this.folderPanel.setCursor(Cursor.getDefaultCursor());
    }

    public void drop(DropTargetDropEvent event) {
        this.folderPanel.setCursor(Cursor.getDefaultCursor());
        if (!this.dragAccepted) {
            event.rejectDrop();
            return;
        }
        event.acceptDrop(this.currentDropAction);
        FileSet droppedFiles = TransferableFileSet.getTransferFiles(event.getTransferable());
        if (droppedFiles == null || droppedFiles.size() == 0) {
            event.dropComplete(false);
            return;
        }
        if (this.changeFolderOnlyMode || this.currentDropAction == 0x40000000) {
            AbstractFile file = (AbstractFile)droppedFiles.elementAt(0);
            if (file.isDirectory()) {
                this.folderPanel.tryChangeCurrentFolder(file);
            } else {
                this.folderPanel.tryChangeCurrentFolder(file.getParent(), file, false);
            }
            this.folderPanel.requestFocus();
        } else {
            MainFrame mainFrame = this.folderPanel.getMainFrame();
            AbstractFile destFolder = this.folderPanel.getCurrentFolder();
            if (this.currentDropAction == 2) {
                ProgressDialog progressDialog = new ProgressDialog(mainFrame, Translator.get("move_dialog.moving", new String[0]));
                MoveJob moveJob = new MoveJob(progressDialog, mainFrame, droppedFiles, destFolder, null, -1, false);
                progressDialog.start(moveJob);
            } else {
                ProgressDialog progressDialog = new ProgressDialog(mainFrame, Translator.get("copy_dialog.copying", new String[0]));
                CopyJob job = new CopyJob(progressDialog, mainFrame, droppedFiles, destFolder, null, 0, -1);
                progressDialog.start(job);
            }
        }
        event.dropComplete(true);
    }
}

