/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.shutdown;

import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.QuestionDialog;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.WindowManager;
import java.awt.Component;
import javax.swing.JCheckBox;

public class QuitDialog
extends QuestionDialog {
    private boolean quitConfirmed;

    public QuitDialog(MainFrame mainFrame) {
        super(mainFrame, Translator.get("quit_dialog.title", new String[0]), Translator.get("quit_dialog.desc", "" + WindowManager.getMainFrames().size()), (Component)mainFrame, new String[]{ActionProperties.getActionLabel("Quit"), Translator.get("cancel", new String[0])}, new int[]{0, 1}, 0);
        JCheckBox showNextTimeCheckBox = new JCheckBox(Translator.get("quit_dialog.show_next_time", new String[0]), true);
        this.addComponent(showNextTimeCheckBox);
        boolean bl = this.quitConfirmed = this.getActionValue() == 0;
        if (this.quitConfirmed) {
            MuConfigurations.getPreferences().setVariable(MuPreference.CONFIRM_ON_QUIT, showNextTimeCheckBox.isSelected());
        }
    }

    public boolean quitConfirmed() {
        return this.quitConfirmed;
    }

    public static boolean confirmationRequired() {
        return WindowManager.getMainFrames().size() > 0 && MuConfigurations.getPreferences().getVariable(MuPreference.CONFIRM_ON_QUIT, true);
    }

    public static boolean confirmQuit() {
        if (QuitDialog.confirmationRequired()) {
            QuitDialog quitDialog = new QuitDialog(WindowManager.getCurrentMainFrame());
            return quitDialog.quitConfirmed();
        }
        return true;
    }
}

