/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.shell;

import com.mucommander.shell.ShellHistoryListener;
import com.mucommander.shell.ShellHistoryManager;
import com.mucommander.ui.autocomplete.CompleterFactory;
import com.mucommander.ui.combobox.AutocompletedEditableCombobox;
import com.mucommander.ui.combobox.EditableComboBox;
import com.mucommander.ui.combobox.EditableComboBoxListener;
import com.mucommander.ui.combobox.SaneComboBox;
import com.mucommander.ui.dialog.shell.RunDialog;
import com.mucommander.ui.theme.ThemeManager;
import java.util.Iterator;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ShellComboBox
extends AutocompletedEditableCombobox
implements ShellHistoryListener,
EditableComboBoxListener,
PopupMenuListener {
    private JTextField input;
    private RunDialog parent;

    public ShellComboBox(RunDialog parent) {
        super(CompleterFactory.getComboboxOptionsCompleter());
        this.parent = parent;
        this.input = this.getTextField();
        this.addPopupMenuListener(this);
        this.setForeground(ThemeManager.getCurrentColor(37));
        this.setBackground(ThemeManager.getCurrentColor(38));
        this.setSelectionForeground(ThemeManager.getCurrentColor(39));
        this.setSelectionBackground(ThemeManager.getCurrentColor(40));
        this.setFont(ThemeManager.getCurrentFont(4));
        this.populateHistory();
        ShellHistoryManager.addListener(this);
        if (this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
        this.setComboSelectionUpdatesTextField(true);
        this.addEditableComboBoxListener(this);
    }

    private void populateHistory() {
        this.removeAllItems();
        Iterator<String> iterator = ShellHistoryManager.getHistoryIterator();
        String command = null;
        while (iterator.hasNext()) {
            command = iterator.next();
            this.insertItemAt(command, 0);
        }
        if (command != null) {
            this.input.setText(command);
            this.input.setSelectionStart(0);
            this.input.setSelectionEnd(command.length());
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.input.setSelectionStart(0);
            this.input.setSelectionEnd(this.input.getText().length());
        }
    }

    public void comboBoxSelectionChanged(SaneComboBox source) {
    }

    public void textFieldValidated(EditableComboBox source) {
        this.parent.runCommand(this.input.getText());
    }

    public void textFieldCancelled(EditableComboBox source) {
        this.parent.dispose();
    }

    public void historyChanged(String command) {
        command = command.trim();
        this.insertItemAt(command, 0);
    }

    public void historyCleared() {
        this.removeAllItems();
        this.input.setText("");
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.setComboSelectionUpdatesTextField(false);
        if (this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
        this.setComboSelectionUpdatesTextField(true);
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    public String getCommand() {
        return this.input.getText();
    }
}

