/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.server;

import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.connection.ConnectionHandler;
import com.mucommander.commons.file.connection.ConnectionPool;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.helper.MnemonicHelper;
import com.mucommander.ui.layout.XBoxPanel;
import com.mucommander.ui.main.MainFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ShowServerConnectionsDialog
extends FocusDialog
implements ActionListener {
    private MainFrame mainFrame;
    private JList connectionList;
    private List<ConnectionHandler> connections;
    private JButton disconnectButton;
    private JButton goToButton;
    private JButton closeButton;
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(400, 300);
    private static final Dimension MAXIMUM_DIALOG_DIMENSION = new Dimension(600, 400);

    public ShowServerConnectionsDialog(MainFrame mainFrame) {
        super((Frame)mainFrame, ActionProperties.getActionLabel("ShowServerConnections"), (Component)mainFrame);
        boolean hasConnections;
        this.mainFrame = mainFrame;
        Container contentPane = this.getContentPane();
        this.connections = ConnectionPool.getConnectionHandlersSnapshot();
        this.connectionList = new JList(new AbstractListModel(){

            public int getSize() {
                return ShowServerConnectionsDialog.this.connections.size();
            }

            public Object getElementAt(int i) {
                ConnectionHandler connHandler = (ConnectionHandler)ShowServerConnectionsDialog.this.connections.get(i);
                FileURL clonedRealm = (FileURL)connHandler.getRealm().clone();
                Credentials loginCredentials = new Credentials(connHandler.getCredentials().getLogin(), "");
                clonedRealm.setCredentials(loginCredentials);
                return clonedRealm.toString(true) + " (" + Translator.get(connHandler.isLocked() ? "server_connections_dialog.connection_busy" : "server_connections_dialog.connection_idle", new String[0]) + ")";
            }
        });
        this.connectionList.setSelectionMode(0);
        boolean bl = hasConnections = this.connections.size() > 0;
        if (hasConnections) {
            this.connectionList.setSelectedIndex(0);
        }
        contentPane.add((Component)new JScrollPane(this.connectionList, 20, 30), "Center");
        XBoxPanel buttonsPanel = new XBoxPanel();
        JPanel buttonGroupPanel = new JPanel(new FlowLayout(0));
        MnemonicHelper mnemonicHelper = new MnemonicHelper();
        this.disconnectButton = new JButton(Translator.get("server_connections_dialog.disconnect", new String[0]));
        this.disconnectButton.setMnemonic(mnemonicHelper.getMnemonic(this.disconnectButton));
        this.disconnectButton.setEnabled(hasConnections);
        if (hasConnections) {
            this.disconnectButton.addActionListener(this);
        }
        buttonGroupPanel.add(this.disconnectButton);
        this.goToButton = new JButton(Translator.get("go_to", new String[0]));
        this.goToButton.setMnemonic(mnemonicHelper.getMnemonic(this.goToButton));
        this.goToButton.setEnabled(hasConnections);
        if (hasConnections) {
            this.goToButton.addActionListener(this);
        }
        buttonGroupPanel.add(this.goToButton);
        buttonsPanel.add(buttonGroupPanel);
        this.closeButton = new JButton(Translator.get("close", new String[0]));
        this.closeButton.setMnemonic(mnemonicHelper.getMnemonic(this.closeButton));
        this.closeButton.addActionListener(this);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.closeButton);
        contentPane.add((Component)buttonsPanel, "South");
        this.setInitialFocusComponent(this.connectionList);
        this.getRootPane().setDefaultButton(this.closeButton);
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
        this.setDefaultCloseOperation(2);
        this.showDialog();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.disconnectButton) {
            int selectedIndex = this.connectionList.getSelectedIndex();
            if (selectedIndex >= 0 && selectedIndex < this.connections.size()) {
                final ConnectionHandler connHandler = this.connections.get(selectedIndex);
                new Thread(){

                    public void run() {
                        connHandler.closeConnection();
                    }
                }.start();
                this.connections.remove(selectedIndex);
                this.connectionList.setSelectedIndex(Math.min(selectedIndex, this.connections.size()));
                this.connectionList.repaint();
                if (this.connections.size() == 0) {
                    this.disconnectButton.setEnabled(false);
                    this.goToButton.setEnabled(false);
                }
            }
        } else if (source == this.goToButton) {
            this.dispose();
            int selectedIndex = this.connectionList.getSelectedIndex();
            if (selectedIndex >= 0 && selectedIndex < this.connections.size()) {
                this.mainFrame.getActivePanel().tryChangeCurrentFolder(this.connections.get(selectedIndex).getRealm());
            }
        } else if (source == this.closeButton) {
            this.dispose();
        }
    }
}

