/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.server;

import com.mucommander.commons.file.FileURL;
import com.mucommander.ui.dialog.server.ServerConnectDialog;
import com.mucommander.ui.layout.XAlignedComponentPanel;
import com.mucommander.ui.main.MainFrame;
import java.awt.Insets;
import java.net.MalformedURLException;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class ServerPanel
extends XAlignedComponentPanel {
    protected ServerConnectDialog dialog;
    protected MainFrame mainFrame;

    protected ServerPanel(ServerConnectDialog dialog, MainFrame mainFrame) {
        super(10);
        this.dialog = dialog;
        this.mainFrame = mainFrame;
    }

    public Insets getInsets() {
        return new Insets(8, 6, 8, 6);
    }

    protected JSpinner createPortSpinner(int portValue) {
        return this.createIntSpinner(portValue, 1, 65535, 1);
    }

    protected JSpinner createIntSpinner(int value, int minValue, int maxValue, int step) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(value, minValue, maxValue, step));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner, "#####");
        editor.getTextField().setHorizontalAlignment(10);
        spinner.setEditor(editor);
        spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ServerPanel.this.dialog.updateURLLabel();
            }
        });
        return spinner;
    }

    protected void addTextFieldListeners(JTextField textField, boolean updateLabel) {
        textField.addActionListener(this.dialog);
        if (updateLabel) {
            textField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    ServerPanel.this.dialog.updateURLLabel();
                }

                public void insertUpdate(DocumentEvent e) {
                    ServerPanel.this.dialog.updateURLLabel();
                }

                public void removeUpdate(DocumentEvent e) {
                    ServerPanel.this.dialog.updateURLLabel();
                }
            });
        }
    }

    abstract FileURL getServerURL() throws MalformedURLException;

    abstract boolean usesCredentials();

    abstract void dialogValidated();
}

