/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.server;

import com.mucommander.auth.CredentialsMapping;
import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileURL;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.dialog.server.FTPPanel;
import com.mucommander.ui.dialog.server.HDFSPanel;
import com.mucommander.ui.dialog.server.HTTPPanel;
import com.mucommander.ui.dialog.server.NFSPanel;
import com.mucommander.ui.dialog.server.S3Panel;
import com.mucommander.ui.dialog.server.SFTPPanel;
import com.mucommander.ui.dialog.server.SMBPanel;
import com.mucommander.ui.dialog.server.ServerPanel;
import com.mucommander.ui.helper.FocusRequester;
import com.mucommander.ui.layout.XBoxPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConnectDialog
extends FocusDialog
implements ActionListener,
ChangeListener {
    private FolderPanel folderPanel;
    private JButton cancelButton;
    private ServerPanel currentServerPanel;
    private JTabbedPane tabbedPane;
    private List<ServerPanel> serverPanels = new Vector<ServerPanel>();
    private JLabel urlLabel;
    private JCheckBox saveCredentialsCheckBox;
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(480, 0);
    private static Class<? extends ServerPanel> lastPanelClass = FTPPanel.class;

    public ServerConnectDialog(FolderPanel folderPanel) {
        this(folderPanel, lastPanelClass);
    }

    public ServerConnectDialog(FolderPanel folderPanel, Class<? extends ServerPanel> selectPanelClass) {
        super((Frame)folderPanel.getMainFrame(), ActionProperties.getActionLabel("ConnectToServer"), (Component)folderPanel.getMainFrame());
        this.folderPanel = folderPanel;
        lastPanelClass = selectPanelClass;
        MainFrame mainFrame = folderPanel.getMainFrame();
        Container contentPane = this.getContentPane();
        this.tabbedPane = new JTabbedPane(1);
        this.addTab("ftp", new FTPPanel(this, mainFrame), selectPanelClass);
        this.addTab("hdfs", new HDFSPanel(this, mainFrame), selectPanelClass);
        this.addTab("http", new HTTPPanel(this, mainFrame), selectPanelClass);
        this.addTab("nfs", new NFSPanel(this, mainFrame), selectPanelClass);
        this.addTab("s3", new S3Panel(this, mainFrame), selectPanelClass);
        this.addTab("sftp", new SFTPPanel(this, mainFrame), selectPanelClass);
        this.addTab("smb", new SMBPanel(this, mainFrame), selectPanelClass);
        this.currentServerPanel = this.getCurrentServerPanel();
        this.tabbedPane.addChangeListener(this);
        contentPane.add((Component)this.tabbedPane, "Center");
        YBoxPanel yPanel = new YBoxPanel();
        XBoxPanel xPanel = new XBoxPanel();
        xPanel.add(new JLabel(Translator.get("server_connect_dialog.server_url", new String[0]) + ":"));
        xPanel.addSpace(5);
        this.urlLabel = new JLabel("");
        this.updateURLLabel();
        xPanel.add(this.urlLabel);
        yPanel.add(xPanel);
        yPanel.addSpace(10);
        this.saveCredentialsCheckBox = new JCheckBox(Translator.get("auth_dialog.store_credentials", new String[0]), false);
        this.saveCredentialsCheckBox.setEnabled(this.currentServerPanel.usesCredentials());
        yPanel.add(this.saveCredentialsCheckBox);
        JButton okButton = new JButton(Translator.get("server_connect_dialog.connect", new String[0]));
        this.cancelButton = new JButton(Translator.get("cancel", new String[0]));
        yPanel.add(DialogToolkit.createOKCancelPanel(okButton, this.cancelButton, this.getRootPane(), this));
        contentPane.add((Component)yPanel, "South");
        this.setInitialFocusComponent(this.currentServerPanel);
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
    }

    public void addTab(String protocol, ServerPanel serverPanel, Class<? extends ServerPanel> selectPanelClass) {
        if (!FileFactory.isRegisteredProtocol(protocol)) {
            return;
        }
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)serverPanel, "North");
        this.tabbedPane.addTab(protocol.toUpperCase(), northPanel);
        if (selectPanelClass.equals(serverPanel.getClass())) {
            this.tabbedPane.setSelectedComponent(northPanel);
        }
        this.serverPanels.add(serverPanel);
    }

    protected void updateURLLabel() {
        try {
            FileURL url = this.currentServerPanel.getServerURL();
            this.urlLabel.setText(url == null ? " " : url.toString(false));
        }
        catch (MalformedURLException ex) {
            this.urlLabel.setText(" ");
        }
    }

    private ServerPanel getCurrentServerPanel() {
        return this.serverPanels.get(this.tabbedPane.getSelectedIndex());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cancelButton) {
            this.dispose();
            return;
        }
        try {
            this.currentServerPanel.dialogValidated();
            FileURL serverURL = this.currentServerPanel.getServerURL();
            Credentials credentials = serverURL.getCredentials();
            CredentialsMapping credentialsMapping = credentials != null ? new CredentialsMapping(credentials, serverURL, this.saveCredentialsCheckBox.isSelected()) : null;
            this.dispose();
            this.folderPanel.tryChangeCurrentFolder(serverURL, credentialsMapping);
        }
        catch (IOException ex) {
            InformationDialog.showErrorDialog(this, Translator.get("table.folder_access_error_title", new String[0]), Translator.get("folder_does_not_exist", new String[0]));
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.currentServerPanel = this.getCurrentServerPanel();
        lastPanelClass = this.currentServerPanel.getClass();
        this.saveCredentialsCheckBox.setEnabled(this.currentServerPanel.usesCredentials());
        this.updateURLLabel();
        FocusRequester.requestFocus(this.currentServerPanel);
    }
}

