/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.server;

import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.server.ServerConnectDialog;
import com.mucommander.ui.dialog.server.ServerPanel;
import com.mucommander.ui.main.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class SFTPPanel
extends ServerPanel {
    private static final int STANDARD_PORT = FileURL.getRegisteredHandler("sftp").getStandardPort();
    private JTextField serverField = new JTextField(lastServer);
    private JTextField privateKeyPathField;
    private JTextField usernameField;
    private JPasswordField passwordField;
    private JTextField initialDirField;
    private JSpinner portSpinner;
    private static String lastServer = "";
    private static String lastKeyPath = "";
    private static String lastUsername = "";
    private String lastPassword = "";
    private static String lastInitialDir = "/";
    private static int lastPort = STANDARD_PORT;

    SFTPPanel(ServerConnectDialog dialog, final MainFrame mainFrame) {
        super(dialog, mainFrame);
        this.serverField.selectAll();
        this.addTextFieldListeners(this.serverField, true);
        this.addRow(Translator.get("server_connect_dialog.server", new String[0]), (JComponent)this.serverField, 15);
        this.usernameField = new JTextField(lastUsername);
        this.usernameField.selectAll();
        this.addTextFieldListeners(this.usernameField, false);
        this.addRow(Translator.get("server_connect_dialog.username", new String[0]), (JComponent)this.usernameField, 5);
        this.passwordField = new JPasswordField();
        this.addTextFieldListeners(this.passwordField, false);
        this.addRow(Translator.get("password", new String[0]) + "/" + Translator.get("server_connect_dialog.passphrase", new String[0]), (JComponent)this.passwordField, 15);
        JPanel privateKeyChooser = new JPanel(new BorderLayout());
        this.privateKeyPathField = new JTextField(lastKeyPath);
        this.privateKeyPathField.selectAll();
        this.addTextFieldListeners(this.privateKeyPathField, false);
        privateKeyChooser.add((Component)this.privateKeyPathField, "Center");
        JButton chooseFileButton = new JButton("...");
        if (OsFamilies.MAC_OS_X.isCurrent()) {
            chooseFileButton.putClientProperty("JComponent.sizeVariant", "small");
        }
        chooseFileButton.addActionListener(new ActionListener(){
            JFileChooser fc = new JFileChooser(System.getProperty("user.home") + System.getProperty("file.separator") + ".ssh");

            public void actionPerformed(ActionEvent e) {
                int returnVal = this.fc.showOpenDialog(mainFrame);
                if (returnVal == 0) {
                    SFTPPanel.this.privateKeyPathField.setText(this.fc.getSelectedFile().getAbsolutePath());
                }
            }
        });
        privateKeyChooser.add((Component)chooseFileButton, "East");
        this.addRow(Translator.get("server_connect_dialog.private_key", new String[0]), (JComponent)privateKeyChooser, 15);
        this.initialDirField = new JTextField(lastInitialDir);
        this.initialDirField.selectAll();
        this.addTextFieldListeners(this.initialDirField, true);
        this.addRow(Translator.get("server_connect_dialog.initial_dir", new String[0]), (JComponent)this.initialDirField, 5);
        this.portSpinner = this.createPortSpinner(lastPort);
        this.addRow(Translator.get("server_connect_dialog.port", new String[0]), (JComponent)this.portSpinner, 15);
    }

    private void updateValues() {
        lastKeyPath = this.privateKeyPathField.getText();
        lastServer = this.serverField.getText();
        lastUsername = this.usernameField.getText();
        this.lastPassword = new String(this.passwordField.getPassword());
        lastInitialDir = this.initialDirField.getText();
        lastPort = (Integer)this.portSpinner.getValue();
    }

    FileURL getServerURL() throws MalformedURLException {
        this.updateValues();
        if (!lastInitialDir.startsWith("/")) {
            lastInitialDir = "/" + lastInitialDir;
        }
        FileURL url = FileURL.getFileURL("sftp://" + lastServer + lastInitialDir);
        url.setCredentials(new Credentials(lastUsername, this.lastPassword));
        if (!"".equals(lastKeyPath.trim())) {
            url.setProperty("privateKeyPath", lastKeyPath);
        }
        url.setPort(lastPort);
        return url;
    }

    boolean usesCredentials() {
        return true;
    }

    public void dialogValidated() {
        try {
            this.portSpinner.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.updateValues();
    }
}

