/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.server;

import com.mucommander.commons.file.FileURL;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.server.ServerConnectDialog;
import com.mucommander.ui.dialog.server.ServerPanel;
import com.mucommander.ui.main.MainFrame;
import java.net.MalformedURLException;
import java.text.ParseException;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class NFSPanel
extends ServerPanel {
    private static final int STANDARD_PORT = FileURL.getRegisteredHandler("nfs").getStandardPort();
    private JTextField serverField = new JTextField(lastServer);
    private JTextField shareField;
    private JSpinner portSpinner;
    private JComboBox nfsVersionComboBox;
    private JComboBox nfsProtocolComboBox;
    private static String lastServer = "";
    private static String lastShare = "";
    private static int lastPort = STANDARD_PORT;
    private static String lastNfsVersion = "v2";
    private static String lastNfsProtocol = "Auto";

    NFSPanel(ServerConnectDialog dialog, MainFrame mainFrame) {
        super(dialog, mainFrame);
        this.serverField.selectAll();
        this.addTextFieldListeners(this.serverField, true);
        this.addRow(Translator.get("server_connect_dialog.server", new String[0]), (JComponent)this.serverField, 5);
        this.shareField = new JTextField(lastShare);
        this.shareField.selectAll();
        this.addTextFieldListeners(this.shareField, true);
        this.addRow(Translator.get("server_connect_dialog.share", new String[0]), (JComponent)this.shareField, 15);
        this.portSpinner = this.createPortSpinner(lastPort);
        this.addRow(Translator.get("server_connect_dialog.port", new String[0]), (JComponent)this.portSpinner, 15);
        this.nfsVersionComboBox = new JComboBox();
        this.nfsVersionComboBox.addItem("v2");
        this.nfsVersionComboBox.addItem("v3");
        this.nfsVersionComboBox.setSelectedItem(lastNfsVersion);
        this.addRow(Translator.get("server_connect_dialog.nfs_version", new String[0]), (JComponent)this.nfsVersionComboBox, 5);
        this.nfsProtocolComboBox = new JComboBox();
        this.nfsProtocolComboBox.addItem("Auto");
        this.nfsProtocolComboBox.addItem("TCP");
        this.nfsProtocolComboBox.addItem("UDP");
        this.nfsProtocolComboBox.setSelectedItem(lastNfsProtocol);
        this.addRow(Translator.get("server_connect_dialog.protocol", new String[0]), (JComponent)this.nfsProtocolComboBox, 15);
    }

    private void updateValues() {
        lastServer = this.serverField.getText();
        lastShare = this.shareField.getText();
        lastPort = (Integer)this.portSpinner.getValue();
        lastNfsVersion = (String)this.nfsVersionComboBox.getSelectedItem();
        lastNfsProtocol = (String)this.nfsProtocolComboBox.getSelectedItem();
    }

    FileURL getServerURL() throws MalformedURLException {
        this.updateValues();
        FileURL url = FileURL.getFileURL("nfs://" + lastServer + (lastShare.startsWith("/") ? "" : "/") + lastShare);
        url.setPort(lastPort);
        url.setProperty("version", lastNfsVersion);
        url.setProperty("protocol", lastNfsProtocol);
        return url;
    }

    boolean usesCredentials() {
        return false;
    }

    public void dialogValidated() {
        try {
            this.portSpinner.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.updateValues();
    }
}

