/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.theme;

import com.mucommander.text.SizeFormat;
import com.mucommander.text.Translator;
import com.mucommander.ui.border.MutableLineBorder;
import com.mucommander.ui.chooser.FontChooser;
import com.mucommander.ui.chooser.PreviewLabel;
import com.mucommander.ui.dialog.pref.PreferencesDialog;
import com.mucommander.ui.dialog.pref.theme.ColorButton;
import com.mucommander.ui.dialog.pref.theme.ThemeEditorPanel;
import com.mucommander.ui.layout.ProportionalGridPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.theme.ThemeData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

class StatusBarPanel
extends ThemeEditorPanel
implements PropertyChangeListener {
    private static final int[] WARNING_LEVEL_COLOR_IDS = new int[]{53, 54, 55};
    private static final String[] WARNING_LEVEL_LABELS = new String[]{Translator.get("theme_editor.free_space.ok", new String[0]), Translator.get("theme_editor.free_space.warning", new String[0]), Translator.get("theme_editor.free_space.critical", new String[0])};
    private static final int[] WARNING_DRAW_PERCENTAGE = new int[]{50, 10, 1};
    private static final String[] WARNING_LEVEL_TEXT = new String[]{Translator.get("status_bar.volume_free", SizeFormat.format(0xA00000000L, 202) + " / " + SizeFormat.format(0x1400000000L, 202)), Translator.get("status_bar.volume_free", SizeFormat.format(0x200000000L, 202) + " / " + SizeFormat.format(0x1400000000L, 202)), Translator.get("status_bar.volume_free", SizeFormat.format(0x33333333L, 202) + " / " + SizeFormat.format(0x1400000000L, 202))};
    private JLabel normalPreview;
    private Preview okPreview;
    private Preview warningPreview;
    private Preview criticalPreview;

    public StatusBarPanel(PreferencesDialog parent, ThemeData themeData) {
        super(parent, Translator.get("theme_editor.statusbar_tab", new String[0]), themeData);
        this.initUI();
    }

    private JPanel createGeneralPanel(FontChooser chooser, ColorButton foreground) {
        ProportionalGridPanel colorPanel = new ProportionalGridPanel(2);
        ((Container)colorPanel).add(this.createCaptionLabel("theme_editor.text"));
        ((Container)colorPanel).add(foreground);
        JPanel flowPanel = new JPanel(new FlowLayout(0));
        flowPanel.add(colorPanel);
        flowPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("theme_editor.colors", new String[0])));
        YBoxPanel mainPanel = new YBoxPanel();
        mainPanel.add(chooser);
        mainPanel.addSpace(10);
        mainPanel.add(flowPanel);
        return mainPanel;
    }

    private JPanel createFreeSpacePanel(FontChooser chooser, ColorButton foreground, ColorButton background, ColorButton border) {
        ProportionalGridPanel colorPanel = new ProportionalGridPanel(2);
        ((Container)colorPanel).add(new JLabel());
        ((Container)colorPanel).add(this.createCaptionLabel("theme_editor.color"));
        ((Container)colorPanel).add(this.createCaptionLabel("theme_editor.background"));
        ((Container)colorPanel).add(background);
        ((Container)colorPanel).add(this.createCaptionLabel("theme_editor.border"));
        ((Container)colorPanel).add(border);
        for (int i = 0; i < 3; ++i) {
            PreviewLabel previewLabel = new PreviewLabel();
            previewLabel.setOverlayUnderText(true);
            previewLabel.setTextPainted(true);
            foreground.addUpdatedPreviewComponent(previewLabel);
            background.addUpdatedPreviewComponent(previewLabel);
            border.addUpdatedPreviewComponent(previewLabel);
            this.addFontChooserListener(chooser, previewLabel);
            ((Container)colorPanel).add(this.createCaptionLabel(WARNING_LEVEL_LABELS[i]));
            ((Container)colorPanel).add(new ColorButton(this.parent, this.themeData, WARNING_LEVEL_COLOR_IDS[i], "PreviewLabel.OverlayColor", previewLabel));
            previewLabel.addPropertyChangeListener(this);
        }
        JPanel flowPanel = new JPanel(new FlowLayout(0));
        flowPanel.add(colorPanel);
        return flowPanel;
    }

    private void addPreviewLabel(YBoxPanel panel, JLabel preview, String label, FontChooser chooser) {
        panel.add(this.createCaptionLabel(label));
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)preview, "North");
        panel.add(wrapper);
        this.addFontChooserListener(chooser, preview);
    }

    private JPanel createPreviewPanel(FontChooser fontChooser) {
        YBoxPanel previewPanel = new YBoxPanel();
        this.normalPreview = new JLabel(Translator.get("status_bar.selected_files", "3", "14"));
        this.addPreviewLabel(previewPanel, this.normalPreview, "theme_editor.normal", fontChooser);
        this.normalPreview.setForeground(this.themeData.getColor(50));
        this.okPreview = new Preview(0);
        this.addPreviewLabel(previewPanel, this.okPreview, "theme_editor.free_space.ok", fontChooser);
        this.warningPreview = new Preview(1);
        this.addPreviewLabel(previewPanel, this.warningPreview, "theme_editor.free_space.warning", fontChooser);
        this.criticalPreview = new Preview(2);
        this.addPreviewLabel(previewPanel, this.criticalPreview, "theme_editor.free_space.critical", fontChooser);
        previewPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("preview", new String[0])));
        Insets insets = previewPanel.getInsets();
        previewPanel.setInsets(new Insets(insets.top, insets.left + 8, insets.bottom, insets.right + 6));
        return previewPanel;
    }

    private void initUI() {
        FontChooser fontChooser = this.createFontChooser(5);
        PreviewLabel previewLabel = new PreviewLabel();
        ColorButton foreground = new ColorButton(this.parent, this.themeData, 50, "PreviewLabel.ForegroundColor", previewLabel);
        previewLabel.setTextPainted(true);
        this.addFontChooserListener(fontChooser, previewLabel);
        previewLabel.addPropertyChangeListener(this);
        previewLabel = new PreviewLabel();
        ColorButton background = new ColorButton(this.parent, this.themeData, 51, "PreviewLabel.BackgroundColor", previewLabel);
        PreviewLabel borderPreviewLabel = new PreviewLabel();
        ColorButton border = new ColorButton(this.parent, this.themeData, 52, "PreviewLabel.BorderColor", borderPreviewLabel);
        previewLabel.setTextPainted(true);
        foreground.addUpdatedPreviewComponent(previewLabel);
        border.addUpdatedPreviewComponent(previewLabel);
        this.addFontChooserListener(fontChooser, previewLabel);
        previewLabel.addPropertyChangeListener(this);
        borderPreviewLabel.setTextPainted(true);
        foreground.addUpdatedPreviewComponent(borderPreviewLabel);
        background.addUpdatedPreviewComponent(borderPreviewLabel);
        this.addFontChooserListener(fontChooser, borderPreviewLabel);
        borderPreviewLabel.addPropertyChangeListener(this);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(Translator.get("theme_editor.general", new String[0]), this.createGeneralPanel(fontChooser, foreground));
        tabbedPane.add(Translator.get("theme_editor.free_space", new String[0]), this.createFreeSpacePanel(fontChooser, foreground, background, border));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)tabbedPane, "Center");
        mainPanel.add((Component)this.createPreviewPanel(fontChooser), "East");
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "North");
    }

    public void commit() {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("PreviewLabel.BackgroundColor") || event.getPropertyName().equals("PreviewLabel.OverlayColor")) {
            this.okPreview.repaint();
            this.warningPreview.repaint();
            this.criticalPreview.repaint();
        } else if (event.getPropertyName().equals("PreviewLabel.ForegroundColor")) {
            Color color = this.themeData.getColor(50);
            this.okPreview.setForeground(color);
            this.warningPreview.setForeground(color);
            this.criticalPreview.setForeground(color);
            this.normalPreview.setForeground(color);
        } else if (event.getPropertyName().equals("PreviewLabel.BorderColor")) {
            this.okPreview.refreshBorder();
            this.warningPreview.refreshBorder();
            this.criticalPreview.refreshBorder();
        }
    }

    private class Preview
    extends JLabel {
        private MutableLineBorder border;
        private int type;

        public Preview(int type) {
            super(WARNING_LEVEL_TEXT[type]);
            this.setOpaque(false);
            this.border = new MutableLineBorder(Color.BLACK, 1);
            this.setBorder(this.border);
            this.setHorizontalAlignment(0);
            this.setForeground(StatusBarPanel.this.themeData.getColor(50));
            this.type = type;
        }

        public void refreshBorder() {
            this.border.setLineColor(StatusBarPanel.this.themeData.getColor(52));
            this.repaint();
        }

        public void paint(Graphics g) {
            int width = (this.getWidth() - 2) * WARNING_DRAW_PERCENTAGE[this.type] / 100;
            if (this.type == 0) {
                g.setColor(StatusBarPanel.this.themeData.getColor(53));
            } else if (this.type == 1) {
                g.setColor(StatusBarPanel.this.themeData.getColor(54));
            } else {
                g.setColor(StatusBarPanel.this.themeData.getColor(55));
            }
            g.fillRect(1, 1, width + 1, this.getHeight() - 2);
            g.setColor(StatusBarPanel.this.themeData.getColor(51));
            g.fillRect(width + 1, 1, this.getWidth() - width - 1, this.getHeight() - 2);
            super.paint(g);
        }
    }
}

