/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.theme;

import com.mucommander.text.Translator;
import com.mucommander.ui.chooser.FontChooser;
import com.mucommander.ui.chooser.PreviewLabel;
import com.mucommander.ui.dialog.pref.PreferencesDialog;
import com.mucommander.ui.dialog.pref.theme.ColorButton;
import com.mucommander.ui.dialog.pref.theme.ThemeEditorPanel;
import com.mucommander.ui.layout.ProportionalGridPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.progress.ProgressTextField;
import com.mucommander.ui.theme.ThemeData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

class LocationBarPanel
extends ThemeEditorPanel
implements PropertyChangeListener {
    private ProgressTextField normalPreview;
    private ProgressTextField progressPreview;

    public LocationBarPanel(PreferencesDialog parent, ThemeData themeData) {
        super(parent, Translator.get("theme_editor.locationbar_tab", new String[0]), themeData);
        this.initUI();
    }

    private JPanel createConfigurationPanel() {
        FontChooser fontChooser = this.createFontChooser(3);
        this.addFontChooserListener(fontChooser, this.normalPreview);
        this.addFontChooserListener(fontChooser, this.progressPreview);
        ProportionalGridPanel colorsPanel = new ProportionalGridPanel(3);
        this.addLabelRow(colorsPanel, false);
        PreviewLabel label = new PreviewLabel();
        this.addColorButtons(colorsPanel, fontChooser, "theme_editor.normal", 45, 46, label).addPropertyChangeListener(this);
        this.addColorButtons(colorsPanel, fontChooser, "theme_editor.selected", 47, 48).addPropertyChangeListener(this);
        label.setTextPainted(true);
        this.addFontChooserListener(fontChooser, label);
        colorsPanel.add(this.createCaptionLabel("theme_editor.progress"));
        colorsPanel.add(new JLabel());
        colorsPanel.add(new ColorButton(this.parent, this.themeData, 49, "PreviewLabel.OverlayColor", label));
        label.addPropertyChangeListener(this);
        JPanel flowPanel = new JPanel(new FlowLayout(0));
        flowPanel.add(colorsPanel);
        flowPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("theme_editor.colors", new String[0])));
        YBoxPanel mainPanel = new YBoxPanel();
        mainPanel.add(fontChooser);
        mainPanel.addSpace(10);
        mainPanel.add(flowPanel);
        return mainPanel;
    }

    private JPanel createPreviewPanel() {
        YBoxPanel panel = new YBoxPanel();
        panel.add(this.createCaptionLabel("theme_editor.normal"));
        this.normalPreview = new ProgressTextField(0, this.themeData.getColor(49));
        panel.add(this.normalPreview);
        this.normalPreview.setText(System.getProperty("user.home"));
        panel.addSpace(10);
        panel.add(this.createCaptionLabel("theme_editor.progress"));
        this.progressPreview = new ProgressTextField(50, this.themeData.getColor(49));
        panel.add(this.progressPreview);
        this.progressPreview.setText(System.getProperty("user.home"));
        this.progressPreview.setEnabled(false);
        JPanel borderPanel = new JPanel(new BorderLayout());
        borderPanel.add((Component)panel, "North");
        borderPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("preview", new String[0])));
        this.setBackgroundColors();
        this.setForegroundColors();
        this.setProgressColors();
        return borderPanel;
    }

    private void initUI() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createPreviewPanel(), "East");
        panel.add((Component)this.createConfigurationPanel(), "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "North");
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("PreviewLabel.BackgroundColor")) {
            this.setBackgroundColors();
        } else if (event.getPropertyName().equals("PreviewLabel.ForegroundColor")) {
            this.setForegroundColors();
        } else if (event.getPropertyName().equals("PreviewLabel.OverlayColor")) {
            this.setProgressColors();
        }
    }

    private void setBackgroundColors() {
        this.normalPreview.setBackground(this.themeData.getColor(46));
        this.normalPreview.setSelectionColor(this.themeData.getColor(48));
        this.progressPreview.setBackground(this.themeData.getColor(46));
        this.progressPreview.setSelectionColor(this.themeData.getColor(48));
    }

    private void setForegroundColors() {
        this.normalPreview.setForeground(this.themeData.getColor(45));
        this.normalPreview.setSelectedTextColor(this.themeData.getColor(47));
        this.progressPreview.setForeground(this.themeData.getColor(45));
        this.progressPreview.setSelectedTextColor(this.themeData.getColor(47));
        this.progressPreview.setDisabledTextColor(this.themeData.getColor(45));
    }

    private void setProgressColors() {
        this.progressPreview.setProgressColor(this.themeData.getColor(49));
    }

    public void commit() {
    }
}

