/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.theme;

import com.mucommander.text.Translator;
import com.mucommander.ui.border.MutableLineBorder;
import com.mucommander.ui.icon.FileIcons;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.main.table.CellLabel;
import com.mucommander.ui.theme.ThemeData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

class FilePreviewPanel
extends JScrollPane
implements PropertyChangeListener {
    private ThemeData data;
    private boolean isActive;
    private PreviewTable table;
    private ImageIcon symlinkIcon;

    public FilePreviewPanel(ThemeData data, boolean isActive) {
        super(20, 31);
        this.data = data;
        this.isActive = isActive;
        this.symlinkIcon = IconManager.getCompositeIcon(IconManager.getIcon(0, "file.png"), IconManager.getIcon(0, "link.png"));
        this.initUI();
    }

    private void initUI() {
        this.table = new PreviewTable();
        this.setViewportView(this.table);
        this.getViewport().setBackground(this.data.getColor(this.isActive ? 1 : 3));
        this.setBorder(new MutableLineBorder(this.data.getColor(this.isActive ? 0 : 56)));
        this.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("PreviewLabel.BackgroundColor")) {
            this.getViewport().setBackground(this.data.getColor(this.isActive ? 1 : 3));
        } else if (event.getPropertyName().equals("PreviewLabel.BorderColor")) {
            if (this.getBorder() instanceof MutableLineBorder) {
                ((MutableLineBorder)this.getBorder()).setLineColor(this.data.getColor(this.isActive ? 0 : 56));
            }
        } else if (!event.getPropertyName().equals("PreviewLabel.ForegroundColor")) {
            return;
        }
        this.repaint();
    }

    public void setFont(Font font) {
        if (this.table != null) {
            this.table.setRowHeight(font);
        }
    }

    private class PreviewCellRenderer
    implements TableCellRenderer {
        private CellLabel label = new CellLabel();
        private CellLabel icon = new CellLabel();

        private Color getForegroundColor(int row, boolean isSelected) {
            switch (row) {
                case 0: {
                    if (FilePreviewPanel.this.isActive) {
                        return FilePreviewPanel.this.data.getColor(isSelected ? 15 : 13);
                    }
                    return FilePreviewPanel.this.data.getColor(isSelected ? 16 : 14);
                }
                case 1: {
                    if (FilePreviewPanel.this.isActive) {
                        return FilePreviewPanel.this.data.getColor(isSelected ? 31 : 29);
                    }
                    return FilePreviewPanel.this.data.getColor(isSelected ? 32 : 30);
                }
                case 2: {
                    if (FilePreviewPanel.this.isActive) {
                        return FilePreviewPanel.this.data.getColor(isSelected ? 19 : 17);
                    }
                    return FilePreviewPanel.this.data.getColor(isSelected ? 20 : 18);
                }
                case 3: {
                    if (FilePreviewPanel.this.isActive) {
                        return FilePreviewPanel.this.data.getColor(isSelected ? 11 : 9);
                    }
                    return FilePreviewPanel.this.data.getColor(isSelected ? 12 : 10);
                }
                case 4: {
                    if (FilePreviewPanel.this.isActive) {
                        return FilePreviewPanel.this.data.getColor(isSelected ? 23 : 21);
                    }
                    return FilePreviewPanel.this.data.getColor(isSelected ? 24 : 22);
                }
                case 5: {
                    if (FilePreviewPanel.this.isActive) {
                        return FilePreviewPanel.this.data.getColor(isSelected ? 27 : 25);
                    }
                    return FilePreviewPanel.this.data.getColor(isSelected ? 28 : 26);
                }
            }
            return null;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            CellLabel currentLabel;
            if (column == 0) {
                currentLabel = this.icon;
                if (row == 0) {
                    currentLabel.setIcon(IconManager.getIcon(0, "folder.png"));
                } else if (row == 2) {
                    currentLabel.setIcon(IconManager.getIcon(0, "archive_supported.png"));
                } else if (row == 4) {
                    currentLabel.setIcon(FilePreviewPanel.this.symlinkIcon);
                } else {
                    currentLabel.setIcon(IconManager.getIcon(0, "file.png"));
                }
            } else {
                currentLabel = this.label;
                currentLabel.setFont(FilePreviewPanel.this.data.getFont(0));
                currentLabel.setText((String)value);
                currentLabel.setForeground(this.getForegroundColor(row, isSelected));
            }
            if (isSelected) {
                currentLabel.setOutline(FilePreviewPanel.this.isActive ? FilePreviewPanel.this.data.getColor(57) : FilePreviewPanel.this.data.getColor(58));
            } else {
                currentLabel.setOutline(null);
            }
            if (FilePreviewPanel.this.isActive) {
                if (isSelected) {
                    currentLabel.setBackground(FilePreviewPanel.this.data.getColor(7));
                } else {
                    currentLabel.setBackground(FilePreviewPanel.this.data.getColor(row % 2 == 0 ? 1 : 2));
                }
            } else if (isSelected) {
                currentLabel.setBackground(FilePreviewPanel.this.data.getColor(8));
            } else {
                currentLabel.setBackground(FilePreviewPanel.this.data.getColor(row % 2 == 0 ? 3 : 4));
            }
            return currentLabel;
        }
    }

    private class PreviewTable
    extends JTable {
        private PreviewCellRenderer cellRenderer;
        private Dimension preferredSize;

        public PreviewTable() {
            super(new String[][]{{"", Translator.get("theme_editor.folder", new String[0])}, {"", Translator.get("theme_editor.plain_file", new String[0])}, {"", Translator.get("theme_editor.archive_file", new String[0])}, {"", Translator.get("theme_editor.hidden_file", new String[0])}, {"", Translator.get("theme_editor.symbolic_link", new String[0])}, {"", Translator.get("theme_editor.marked_file", new String[0])}}, new String[]{"", Translator.get("preview", new String[0])});
            this.cellRenderer = new PreviewCellRenderer();
            this.setShowGrid(false);
            this.getSelectionModel().setSelectionMode(0);
            this.changeSelection(0, 0, false, false);
            this.setRowHeight(FilePreviewPanel.this.data.getFont(0));
            this.setIntercellSpacing(new Dimension(0, 0));
            this.getTableHeader().setResizingAllowed(false);
            this.getTableHeader().setReorderingAllowed(false);
            ((DefaultTableCellRenderer)this.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
        }

        public void doLayout() {
            int width = this.getIconWidth();
            this.getColumnModel().getColumn(0).setWidth(width);
            this.getColumnModel().getColumn(1).setWidth(Math.max(this.getWidth() - width, this.getLabelWidth()));
        }

        private int getIconWidth() {
            return (int)FileIcons.getIconDimension().getWidth() + 8;
        }

        private int getLabelWidth() {
            FontMetrics fm = this.getFontMetrics(FilePreviewPanel.this.data.getFont(0));
            int rowCount = this.getModel().getRowCount();
            int width = 0;
            for (int i = 0; i < rowCount; ++i) {
                width = Math.max(width, fm.stringWidth((String)this.getModel().getValueAt(i, 1)) + 8);
            }
            return width;
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.getIconWidth() + 2 * this.getLabelWidth(), this.getModel().getRowCount() * this.getRowHeight());
        }

        public Dimension getPreferredScrollableViewportSize() {
            if (this.preferredSize == null) {
                this.preferredSize = this.getPreferredSize();
            }
            return this.preferredSize;
        }

        private void setRowHeight(Font font) {
            this.setRowHeight(2 + Math.max(this.getFontMetrics(font).getHeight(), (int)FileIcons.getIconDimension().getHeight()));
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            return this.cellRenderer;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

