/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.theme;

import com.mucommander.ui.chooser.ColorChangeEvent;
import com.mucommander.ui.chooser.ColorChangeListener;
import com.mucommander.ui.chooser.ColorChooser;
import com.mucommander.ui.chooser.ColorPicker;
import com.mucommander.ui.chooser.PreviewLabel;
import com.mucommander.ui.dialog.pref.PreferencesDialog;
import com.mucommander.ui.theme.ThemeData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

class ColorButton
extends JPanel
implements ColorChangeListener,
ActionListener {
    private ThemeData themeData;
    private int colorId;
    private PreferencesDialog parent;
    private JComponent previewComponent;
    private String previewColorPropertyName;
    private List<JComponent> updatedPreviewComponents;
    private Border border = BorderFactory.createEtchedBorder();
    private JButton button;
    private Color currentColor;

    public ColorButton(PreferencesDialog parent, ThemeData themeData, int colorId, String previewColorPropertyName) {
        this(parent, themeData, colorId, previewColorPropertyName, null);
    }

    public ColorButton(PreferencesDialog parent, ThemeData themeData, int colorId, String previewColorPropertyName, JComponent previewComponent) {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setHgap(0);
        flowLayout.setVgap(0);
        this.setLayout(flowLayout);
        this.themeData = themeData;
        this.colorId = colorId;
        this.parent = parent;
        this.previewComponent = previewComponent;
        this.previewColorPropertyName = previewColorPropertyName;
        if (previewColorPropertyName != null && previewComponent != null) {
            this.addUpdatedPreviewComponent(previewComponent);
        }
        this.button = new JButton(){

            public Dimension getPreferredSize() {
                return new Dimension(70, 30);
            }

            public void paint(Graphics g) {
                int width = this.getWidth();
                int height = this.getHeight();
                g.setColor(ColorButton.this.currentColor);
                g.fillRect(0, 0, width, height);
                ColorButton.this.border.paintBorder(this, g, 0, 0, width, height);
            }
        };
        this.button.addActionListener(this);
        this.button.setBorderPainted(true);
        this.add(this.button);
        if (ColorPicker.isSupported()) {
            ColorPicker colorPicker = new ColorPicker();
            colorPicker.addColorChangeListener(this);
            this.add(colorPicker);
        }
        this.setCurrentColor(themeData.getColor(colorId), false);
    }

    void addUpdatedPreviewComponent(JComponent previewComponent) {
        if (this.previewColorPropertyName == null) {
            return;
        }
        if (this.updatedPreviewComponents == null) {
            this.updatedPreviewComponents = new Vector<JComponent>();
        }
        this.updatedPreviewComponents.add(previewComponent);
        previewComponent.putClientProperty(this.previewColorPropertyName, this.currentColor);
    }

    private void setCurrentColor(Color color, boolean initiatedByUser) {
        this.currentColor = color;
        if (this.themeData.isColorDifferent(this.colorId, this.currentColor)) {
            initiatedByUser &= this.themeData.setColor(this.colorId, this.currentColor);
        }
        this.button.repaint();
        if (this.updatedPreviewComponents != null && this.previewColorPropertyName != null) {
            int nbPreviewComponents = this.updatedPreviewComponents.size();
            for (int i = 0; i < nbPreviewComponents; ++i) {
                this.updatedPreviewComponents.get(i).putClientProperty(this.previewColorPropertyName, color);
            }
        }
        if (initiatedByUser) {
            this.parent.componentChanged(null);
        }
    }

    private ColorChooser createColorChooser() {
        if (this.previewComponent != null && this.previewColorPropertyName != null && this.previewComponent instanceof PreviewLabel) {
            try {
                return new ColorChooser(this.currentColor, (PreviewLabel)((PreviewLabel)this.previewComponent).clone(), this.previewColorPropertyName);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return new ColorChooser(this.currentColor, new PreviewLabel(), "PreviewLabel.BackgroundColor");
    }

    public void actionPerformed(ActionEvent e) {
        ColorChooser chooser = this.createColorChooser();
        ColorChooser.createDialog(this.parent, chooser).showDialog();
        this.setCurrentColor(chooser.getColor(), true);
    }

    public void colorChanged(ColorChangeEvent event) {
        this.setCurrentColor(event.getColor(), true);
    }
}

