/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.general;

import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionCategories;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionKeymapIO;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.pref.PreferencesDialog;
import com.mucommander.ui.dialog.pref.PreferencesPanel;
import com.mucommander.ui.dialog.pref.general.ShortcutsTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ShortcutsPanel
extends PreferencesPanel {
    private ShortcutsTable shortcutsTable;
    private TooltipBar tooltipBar;

    public ShortcutsPanel(PreferencesDialog parent) {
        super(parent, Translator.get("shortcuts_panel.title", new String[0]));
        this.initUI();
        this.setPreferredSize(new Dimension(0, 0));
        this.shortcutsTable.addDialogListener(parent);
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.tooltipBar = new TooltipBar();
        this.shortcutsTable = new ShortcutsTable(this.tooltipBar);
        this.add((Component)this.createNorthPanel(), "North");
        this.add((Component)this.createCenterPanel(), "Center");
        this.add((Component)this.createSouthPanel(), "South");
    }

    private JPanel createNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.add((Component)this.createFilteringPanel(), "West");
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 0));
        this.shortcutsTable.setPreferredColumnWidths(new double[]{0.6, 0.2, 0.2});
        panel.add(new JScrollPane(this.shortcutsTable));
        return panel;
    }

    private JPanel createSouthPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel tooltipBarPanel = new JPanel(new BorderLayout());
        tooltipBarPanel.add((Component)this.tooltipBar, "West");
        panel.add(tooltipBarPanel);
        panel.add(this.createButtonsPanel());
        return panel;
    }

    private JPanel createButtonsPanel() {
        JPanel panel = new JPanel(new FlowLayout(2));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        RemoveButton removeButton = new RemoveButton();
        JButton restoreDefaultButton = new JButton();
        restoreDefaultButton.setAction(new AbstractAction(Translator.get("shortcuts_panel.restore_defaults", new String[0])){

            public void actionPerformed(ActionEvent e) {
                ShortcutsPanel.this.shortcutsTable.restoreDefaults();
            }
        });
        panel.add(removeButton);
        panel.add(restoreDefaultButton);
        return panel;
    }

    private JPanel createFilteringPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.add(new JLabel(Translator.get("shortcuts_panel.show", new String[0]) + ":"));
        final JComboBox<ActionCategory> combo = new JComboBox<ActionCategory>();
        combo.addItem(ActionCategories.ALL);
        for (ActionCategory category : ActionProperties.getActionCategories()) {
            combo.addItem(category);
        }
        combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                final ActionCategory selectedActionCategory = (ActionCategory)combo.getSelectedItem();
                ShortcutsPanel.this.shortcutsTable.updateModel(new ShortcutsTable.ActionFilter(){

                    public boolean accept(String actionId) {
                        return selectedActionCategory.contains(actionId);
                    }
                });
                ShortcutsPanel.this.tooltipBar.showDefaultMessage();
            }
        });
        combo.setSelectedIndex(0);
        panel.add(combo);
        return panel;
    }

    protected void commit() {
        this.shortcutsTable.commitChanges();
        ActionKeymapIO.setModified();
    }

    private class RemoveButton
    extends JButton
    implements ListSelectionListener,
    TableModelListener {
        public RemoveButton() {
            this.setEnabled(false);
            this.setAction(new AbstractAction(Translator.get("remove", new String[0])){

                public void actionPerformed(ActionEvent e) {
                    ShortcutsPanel.this.shortcutsTable.setValueAt(ShortcutsTable.DELETE, ShortcutsPanel.this.shortcutsTable.getSelectedRow(), ShortcutsPanel.this.shortcutsTable.getSelectedColumn());
                    ShortcutsPanel.this.shortcutsTable.repaint();
                    ShortcutsPanel.this.shortcutsTable.requestFocus();
                }
            });
            ShortcutsPanel.this.shortcutsTable.getSelectionModel().addListSelectionListener(this);
            ShortcutsPanel.this.shortcutsTable.getColumnModel().getSelectionModel().addListSelectionListener(this);
            ShortcutsPanel.this.shortcutsTable.getModel().addTableModelListener(this);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateButtonState();
        }

        public void tableChanged(TableModelEvent e) {
            this.updateButtonState();
        }

        private void updateButtonState() {
            int column = ShortcutsPanel.this.shortcutsTable.getSelectedColumn();
            int row = ShortcutsPanel.this.shortcutsTable.getSelectedRow();
            boolean canRemove = (column == 1 || column == 2) && row != -1 && ShortcutsPanel.this.shortcutsTable.getValueAt(ShortcutsPanel.this.shortcutsTable.getSelectedRow(), column) != null;
            this.setEnabled(canRemove);
        }
    }

    class TooltipBar
    extends JLabel {
        private String lastActionTooltipShown;
        private String DEFAULT_MESSAGE = Translator.get("shortcuts_panel.default_message", new String[0]);
        private MessageRemoverThread currentRemoverThread;

        public TooltipBar() {
            Font tableFont = UIManager.getFont("TableHeader.font");
            this.setFont(new Font(tableFont.getName(), 1, tableFont.getSize()));
            this.setHorizontalAlignment(2);
            this.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            this.setText(this.DEFAULT_MESSAGE);
        }

        public void showActionTooltip(String text) {
            this.lastActionTooltipShown = text == null ? " " : text;
            this.setText(this.lastActionTooltipShown);
        }

        public void showDefaultMessage() {
            this.setText(this.DEFAULT_MESSAGE);
        }

        public void showErrorMessage(String text) {
            this.setText(text);
            this.createMessageRemoverThread();
        }

        private void createMessageRemoverThread() {
            if (this.currentRemoverThread != null) {
                this.currentRemoverThread.neutralize();
            }
            this.currentRemoverThread = new MessageRemoverThread();
            this.currentRemoverThread.start();
        }

        private class MessageRemoverThread
        extends Thread {
            private boolean stopped = false;

            private MessageRemoverThread() {
            }

            public void neutralize() {
                this.stopped = true;
            }

            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.stopped) {
                    TooltipBar.this.showActionTooltip(TooltipBar.this.lastActionTooltipShown);
                }
            }
        }
    }
}

