/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.general;

import com.mucommander.conf.MuConfigurations;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.dialog.pref.PreferencesDialog;
import com.mucommander.ui.dialog.pref.PreferencesPanel;
import com.mucommander.ui.dialog.pref.component.PrefComponent;
import com.mucommander.ui.dialog.pref.general.AppearancePanel;
import com.mucommander.ui.dialog.pref.general.FoldersPanel;
import com.mucommander.ui.dialog.pref.general.GeneralPanel;
import com.mucommander.ui.dialog.pref.general.MailPanel;
import com.mucommander.ui.dialog.pref.general.MiscPanel;
import com.mucommander.ui.dialog.pref.general.ShortcutsPanel;
import com.mucommander.ui.main.WindowManager;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.LinkedHashSet;
import java.util.Set;

public class GeneralPreferencesDialog
extends PreferencesDialog {
    private static GeneralPreferencesDialog singleton;
    private Set<PrefComponent> modifiedComponents = new LinkedHashSet<PrefComponent>();
    private static final Dimension MINIMUM_DIALOG_DIMENSION;
    private static final Dimension MAXIMUM_DIALOG_DIMENSION;
    private static int lastTabIndex;

    private GeneralPreferencesDialog() {
        super((Frame)WindowManager.getCurrentMainFrame(), Translator.get("prefs_dialog.title", new String[0]));
        this.addPreferencesPanel((PreferencesPanel)new GeneralPanel(this), "general.png");
        this.addPreferencesPanel((PreferencesPanel)new FoldersPanel(this), "folders.png");
        this.addPreferencesPanel((PreferencesPanel)new AppearancePanel(this), "appearance.png");
        this.addPreferencesPanel((PreferencesPanel)new ShortcutsPanel(this), "shortcuts.png");
        this.addPreferencesPanel((PreferencesPanel)new MailPanel(this), "mail.png");
        this.addPreferencesPanel((PreferencesPanel)new MiscPanel(this), "misc.png");
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
        this.setActiveTab(lastTabIndex);
    }

    public void commit() {
        super.commit();
        try {
            MuConfigurations.savePreferences();
        }
        catch (Exception e) {
            InformationDialog.showErrorDialog(this);
        }
    }

    public void dispose() {
        GeneralPreferencesDialog.releaseSingleton(this.getSelectedPanelIndex());
        super.dispose();
    }

    public static synchronized GeneralPreferencesDialog getDialog() {
        if (singleton == null) {
            singleton = new GeneralPreferencesDialog();
        }
        return singleton;
    }

    private static synchronized void releaseSingleton(int lastTab) {
        singleton = null;
        lastTabIndex = lastTab;
    }

    public void componentChanged(PrefComponent component) {
        if (component.hasChanged()) {
            this.modifiedComponents.add(component);
        } else {
            this.modifiedComponents.remove(component);
        }
        this.setCommitButtonsEnabled(this.modifiedComponents.size() != 0);
    }

    protected void setCommitButtonsEnabled(boolean enable) {
        super.setCommitButtonsEnabled(enable);
        if (!enable) {
            this.modifiedComponents.clear();
        }
    }

    static {
        MINIMUM_DIALOG_DIMENSION = new Dimension(580, 0);
        MAXIMUM_DIALOG_DIMENSION = new Dimension(640, 480);
        lastTabIndex = 0;
    }
}

