/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.component;

import com.mucommander.ui.dialog.pref.PreferencesDialog;
import com.mucommander.ui.dialog.pref.component.PrefComponent;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class PrefTable
extends JTable
implements PrefComponent {
    private TableModelListener dialogListener;

    public PrefTable() {
    }

    public PrefTable(TableModel model) {
        super(model);
    }

    public void setPreferredColumnWidths(double[] percentages) {
        int i;
        Dimension tableDim = this.getPreferredSize();
        double total = 0.0;
        int nbColumns = this.getColumnModel().getColumnCount();
        for (i = 0; i < nbColumns; ++i) {
            total += percentages[i];
        }
        for (i = 0; i < nbColumns; ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            column.setPreferredWidth((int)((double)tableDim.width * (percentages[i] / total)));
        }
    }

    public void addDialogListener(final PreferencesDialog dialog) {
        this.dialogListener = new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                dialog.componentChanged(PrefTable.this);
            }
        };
        this.getModel().addTableModelListener(this.dialogListener);
    }

    public void setModel(TableModel model) {
        if (this.dialogListener != null) {
            model.addTableModelListener(this.dialogListener);
        }
        super.setModel(model);
    }
}

