/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.file.util.PathUtils;
import com.mucommander.job.TransferFileJob;
import com.mucommander.job.UnpackJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.file.PathFieldContent;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.dialog.file.TransferDestinationDialog;
import com.mucommander.ui.main.MainFrame;

public class UnpackDialog
extends TransferDestinationDialog {
    public UnpackDialog(MainFrame mainFrame, FileSet files) {
        super(mainFrame, files, ActionProperties.getActionLabel("Unpack"), Translator.get("unpack_dialog.destination", new String[0]), Translator.get("unpack", new String[0]), Translator.get("unpack_dialog.error_title", new String[0]), true);
    }

    protected PathFieldContent computeInitialPath(FileSet files) {
        return new PathFieldContent(this.mainFrame.getInactiveTable().getCurrentFolder().getAbsolutePath(true));
    }

    protected TransferFileJob createTransferFileJob(ProgressDialog progressDialog, PathUtils.ResolvedDestination resolvedDest, int defaultFileExistsAction) {
        int destinationType = resolvedDest.getDestinationType();
        if (destinationType == 1) {
            this.showErrorDialog(Translator.get("invalid_path", resolvedDest.getDestinationFile().getAbsolutePath()));
            return null;
        }
        return new UnpackJob(progressDialog, this.mainFrame, this.files, destinationType == 2 ? resolvedDest.getDestinationFile() : resolvedDest.getDestinationFolder(), defaultFileExistsAction);
    }

    protected String getProgressDialogTitle() {
        return Translator.get("unpack_dialog.unpacking", new String[0]);
    }
}

