/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.file.util.PathUtils;
import com.mucommander.job.SplitFileJob;
import com.mucommander.text.SizeFormat;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.combobox.ComboBoxListener;
import com.mucommander.ui.combobox.EditableComboBox;
import com.mucommander.ui.combobox.SaneComboBox;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.file.JobDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.layout.XAlignedComponentPanel;
import com.mucommander.ui.layout.XBoxPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.text.FilePathField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SplitFileDialog
extends JobDialog
implements ActionListener {
    private static final String[] unitNames = new String[]{Translator.get("unit.bytes_short", new String[0]).toLowerCase(), Translator.get("unit.kb", new String[0]).toLowerCase(), Translator.get("unit.mb", new String[0]).toLowerCase(), Translator.get("unit.gb", new String[0]).toLowerCase()};
    private static final int[] unitBytes = new int[]{1, 1024, 0x100000, 0x40000000};
    private static final DecimalFormat DECIMAL_FORMAT = (DecimalFormat)NumberFormat.getInstance();
    private String MSG_AUTO = Translator.get("split_file_dialog.auto", new String[0]);
    private AbstractFile file;
    private AbstractFile destFolder;
    private JButton btnSplit;
    private JButton btnClose;
    private FilePathField edtTargetDirectory;
    private JCheckBox cbGenerateCRC;
    private JTextField edtSize;
    private JSpinner spnParts;
    protected boolean edtChange;

    public SplitFileDialog(MainFrame mainFrame, AbstractFile file, AbstractFile destFolder) {
        super(mainFrame, ActionProperties.getActionLabel("SplitFile"), new FileSet());
        this.file = file;
        this.destFolder = destFolder;
        this.initialize();
    }

    protected void initialize() {
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout(0, 5));
        XAlignedComponentPanel pnlMain = new XAlignedComponentPanel(10);
        pnlMain.addRow(Translator.get("split_file_dialog.file_to_split", new String[0]) + ":", (JComponent)new JLabel(this.file.getName()), 0);
        String size = SizeFormat.format(this.file.getSize(), 84);
        pnlMain.addRow(Translator.get("size", new String[0]) + ":", (JComponent)new JLabel(size), 10);
        this.edtTargetDirectory = new FilePathField(this.destFolder.getAbsolutePath(), 40);
        pnlMain.addRow(Translator.get("split_file_dialog.target_directory", new String[0]) + ":", (JComponent)this.edtTargetDirectory, 5);
        XBoxPanel pnlSize = new XBoxPanel();
        Object[] sizes = new String[]{this.MSG_AUTO, "10 " + Translator.get("unit.mb", new String[0]), "100 " + Translator.get("unit.mb", new String[0]), "250 " + Translator.get("unit.mb", new String[0]), "650 " + Translator.get("unit.mb", new String[0]), "700 " + Translator.get("unit.mb", new String[0])};
        this.edtSize = new JTextField();
        EditableComboBox cbSize = new EditableComboBox(this.edtSize, sizes);
        cbSize.setComboSelectionUpdatesTextField(true);
        cbSize.setSelectedIndex(1);
        this.edtSize.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                SplitFileDialog.this.updatePartsNumber();
            }
        });
        cbSize.addComboBoxListener(new ComboBoxListener(){

            public void comboBoxSelectionChanged(SaneComboBox source) {
                SplitFileDialog.this.updatePartsNumber();
            }
        });
        pnlSize.add(cbSize);
        pnlSize.addSpace(10);
        pnlSize.add(new JLabel(Translator.get("split_file_dialog.parts", new String[0]) + ":"));
        pnlSize.addSpace(5);
        this.spnParts = new JSpinner(new SpinnerNumberModel(1.0, 1.0, this.file.getSize(), 1.0));
        this.spnParts.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!SplitFileDialog.this.edtChange) {
                    long parts = ((Number)SplitFileDialog.this.spnParts.getValue()).longValue();
                    long newsize = SplitFileDialog.this.file.getSize() / parts;
                    if (SplitFileDialog.this.file.getSize() % parts != 0L) {
                        ++newsize;
                    }
                    if (SplitFileDialog.this.getBytes() != newsize) {
                        SplitFileDialog.this.edtSize.setText(Long.toString(newsize));
                    }
                }
            }
        });
        pnlSize.add(this.spnParts);
        pnlMain.addRow(Translator.get("split_file_dialog.part_size", new String[0]) + ":", (JComponent)pnlSize, 0);
        this.cbGenerateCRC = new JCheckBox(Translator.get("split_file_dialog.generate_CRC", new String[0]));
        this.cbGenerateCRC.setSelected(true);
        pnlMain.addRow("", (JComponent)this.cbGenerateCRC, 0);
        content.add((Component)pnlMain, "Center");
        content.add((Component)this.getPnlButtons(), "South");
        this.getRootPane().setDefaultButton(this.btnSplit);
        this.updatePartsNumber();
    }

    private JPanel getPnlButtons() {
        this.btnSplit = new JButton(Translator.get("split", new String[0]));
        this.btnClose = new JButton(Translator.get("cancel", new String[0]));
        return DialogToolkit.createOKCancelPanel(this.btnSplit, this.btnClose, this.getRootPane(), this);
    }

    private void startJob() {
        long size = this.getBytes();
        if (size < 1L) {
            return;
        }
        String destPath = this.edtTargetDirectory.getText();
        PathUtils.ResolvedDestination resolvedDest = PathUtils.resolveDestination(destPath, this.mainFrame.getActiveTable().getCurrentFolder());
        if (resolvedDest == null || this.files.size() > 1 && resolvedDest.getDestinationType() != 0) {
            this.showErrorDialog(Translator.get("invalid_path", destPath), Translator.get("split_file_dialog.error_title", new String[0]));
            return;
        }
        long parts = this.getParts();
        if (parts > 100L) {
            this.showErrorDialog(Translator.get("split_file_dialog.max_parts", Integer.toString(100)), Translator.get("split_file_dialog.error_title", new String[0]));
            return;
        }
        ProgressDialog progressDialog = new ProgressDialog(this.mainFrame, Translator.get("progress_dialog.processing_files", new String[0]));
        SplitFileJob job = new SplitFileJob(progressDialog, this.mainFrame, this.file, resolvedDest.getDestinationFolder(), size, (int)parts);
        job.setIntegrityCheckEnabled(this.cbGenerateCRC.isSelected());
        progressDialog.start(job);
    }

    private long getBytes() {
        String strVal = this.edtSize.getText().trim();
        if (this.MSG_AUTO.equals(strVal)) {
            return this.file.getSize();
        }
        String[] strArr = strVal.split(" ");
        if (strArr.length < 1 || strArr.length > 2) {
            return -1L;
        }
        int unit = 1;
        if (strArr.length == 2) {
            unit = -1;
            strArr[1] = strArr[1].toLowerCase();
            for (int i = 0; i < unitNames.length; ++i) {
                if (!unitNames[i].equals(strArr[1])) continue;
                unit = unitBytes[i];
                break;
            }
            if (unit == -1) {
                return -1L;
            }
        }
        try {
            double size = DECIMAL_FORMAT.parse(strArr[0]).doubleValue();
            return (long)(size *= (double)unit);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private long getParts() {
        long size = this.getBytes();
        if (size < 1L) {
            return -1L;
        }
        return (long)Math.ceil((double)this.file.getSize() / (double)size);
    }

    private void updatePartsNumber() {
        long parts = this.getParts();
        if (parts < 1L) {
            return;
        }
        this.edtChange = true;
        this.spnParts.setValue(parts);
        this.edtChange = false;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.btnClose) {
            this.dispose();
        } else if (source == this.btnSplit) {
            this.dispose();
            this.startJob();
        }
    }

    static {
        DECIMAL_FORMAT.setGroupingUsed(false);
    }
}

