/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.file.util.OSXFileUtils;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsVersions;
import com.mucommander.job.PropertiesJob;
import com.mucommander.text.SizeFormat;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.icon.FileIcons;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.icon.SpinningDial;
import com.mucommander.ui.layout.XAlignedComponentPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.text.FileLabel;
import com.mucommander.ui.text.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class PropertiesDialog
extends FocusDialog
implements ActionListener,
Runnable {
    private PropertiesJob job;
    private Thread repaintThread;
    private SpinningDial dial;
    private JLabel counterLabel;
    private JLabel sizeLabel;
    private JButton okCancelButton;
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(360, 0);
    private static final Dimension MAXIMUM_DIALOG_DIMENSION = new Dimension(450, 10000);
    private static final Dimension ICON_DIMENSION = new Dimension(64, 64);

    public PropertiesDialog(MainFrame mainFrame, FileSet fileSet) {
        super((Frame)mainFrame, fileSet.size() > 1 ? ActionProperties.getActionLabel("ShowFileProperties") : Translator.get("properties_dialog.file_properties", ((AbstractFile)fileSet.elementAt(0)).getName()), (Component)mainFrame);
        Object object;
        Accessible accessible;
        Icon icon;
        AbstractFile abstractFile;
        this.job = new PropertiesJob(fileSet, mainFrame);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        boolean bl = fileSet.size() == 1;
        AbstractFile abstractFile2 = abstractFile = bl ? (AbstractFile)fileSet.elementAt(0) : null;
        if (bl) {
            icon = FileIcons.getFileIcon(abstractFile, ICON_DIMENSION);
        } else {
            accessible = IconManager.getIcon(3, "many_files.png");
            icon = IconManager.getScaledIcon((ImageIcon)accessible, (float)ICON_DIMENSION.getWidth() / (float)((ImageIcon)accessible).getIconWidth());
        }
        accessible = new JLabel(icon);
        ((JLabel)accessible).setVerticalAlignment(1);
        ((JComponent)((Object)accessible)).setBorder(new EmptyBorder(0, 0, 0, 8));
        jPanel.add((Component)((Object)accessible), "West");
        XAlignedComponentPanel xAlignedComponentPanel = new XAlignedComponentPanel(10);
        this.counterLabel = new JLabel("");
        xAlignedComponentPanel.addRow(Translator.get("properties_dialog.contents", new String[0]) + ":", (JComponent)this.counterLabel, 6);
        xAlignedComponentPanel.addRow(Translator.get("location", new String[0]) + ":", (JComponent)new FileLabel(fileSet.getBaseFolder(), true), 6);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        this.sizeLabel = new JLabel("");
        jPanel2.add(this.sizeLabel);
        this.dial = new SpinningDial();
        jPanel2.add(new JLabel(this.dial));
        xAlignedComponentPanel.addRow(Translator.get("size", new String[0]) + ":", (JComponent)jPanel2, 6);
        if (OsFamilies.MAC_OS_X.isCurrent() && OsVersions.MAC_OS_X_10_4.isCurrentOrHigher() && bl && abstractFile.hasAncestor(LocalFile.class)) {
            object = OSXFileUtils.getSpotlightComment(abstractFile);
            JLabel jLabel = new JLabel(Translator.get("comment", new String[0]) + ":");
            jLabel.setAlignmentY(0.0f);
            jLabel.setVerticalAlignment(1);
            xAlignedComponentPanel.addRow(jLabel, (JComponent)new MultiLineLabel((String)object), 6);
        }
        this.updateLabels();
        jPanel.add((Component)xAlignedComponentPanel, "Center");
        object = new YBoxPanel(5);
        ((YBoxPanel)object).add(jPanel);
        container.add((Component)object, "North");
        this.okCancelButton = new JButton(Translator.get("cancel", new String[0]));
        container.add((Component)DialogToolkit.createOKPanel(this.okCancelButton, this.getRootPane(), this), "South");
        this.setInitialFocusComponent(this.okCancelButton);
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
        this.start();
    }

    private void updateLabels() {
        int nbFiles = this.job.getNbFilesRecurse();
        int nbFolders = this.job.getNbFolders();
        this.counterLabel.setText((nbFiles > 0 ? Translator.get("nb_files", "" + nbFiles) : "") + (nbFiles > 0 && nbFolders > 0 ? ", " : "") + (nbFolders > 0 ? Translator.get("nb_folders", "" + nbFolders) : ""));
        this.sizeLabel.setText(SizeFormat.format(this.job.getTotalBytes(), 210) + " (" + SizeFormat.format(this.job.getTotalBytes(), 84) + ")");
        this.counterLabel.repaint(500L);
        this.sizeLabel.repaint(500L);
    }

    public void start() {
        this.job.start();
        this.repaintThread = new Thread((Runnable)this, "com.mucommander.ui.dialog.file.PropertiesDialog's Thread");
        this.repaintThread.start();
    }

    public void run() {
        this.dial.setAnimated(true);
        while (this.repaintThread != null && this.job.getState() != 4) {
            this.updateLabels();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.updateLabels();
        this.okCancelButton.setText(Translator.get("ok", new String[0]));
        this.dial.setAnimated(false);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okCancelButton) {
            this.dispose();
        }
    }

    public void windowClosed(WindowEvent e) {
        super.windowClosed(e);
        this.job.interrupt();
        this.repaintThread = null;
    }
}

