/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.util.FileSet;
import com.mucommander.text.Translator;
import com.mucommander.ui.button.CollapseExpandButton;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.layout.AsyncPanel;
import com.mucommander.ui.list.FileList;
import com.mucommander.ui.main.MainFrame;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class JobDialog
extends FocusDialog {
    protected MainFrame mainFrame;
    protected FileSet files;
    protected CollapseExpandButton collapseExpandButton;

    public JobDialog(MainFrame mainFrame, String title, FileSet files) {
        super((Frame)mainFrame, title, (Component)mainFrame);
        this.mainFrame = mainFrame;
        this.files = files;
    }

    protected void showErrorDialog(String message, String title) {
        InformationDialog.showErrorDialog(this.mainFrame, title, message);
    }

    protected void showErrorDialog(String message) {
        this.showErrorDialog(message, Translator.get("error", new String[0]));
    }

    protected AsyncPanel createFileDetailsPanel() {
        return new AsyncPanel(){

            public JComponent getTargetComponent() {
                FileList fileList = new FileList(JobDialog.this.files, true);
                fileList.setVisibleRowCount(10);
                return new JScrollPane(fileList, 20, 30);
            }
        };
    }

    protected CollapseExpandButton createFileDetailsButton(JPanel detailsPanel) {
        this.collapseExpandButton = new CollapseExpandButton(Translator.get("nb_files", "" + this.files.size()), detailsPanel, false);
        return this.collapseExpandButton;
    }

    protected JPanel createButtonsPanel(JButton fileDetailsButton, JPanel buttonsPanel) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(fileDetailsButton);
        panel.add(Box.createVerticalGlue());
        panel.add(buttonsPanel);
        return panel;
    }

    protected void setFiles(FileSet files) {
        this.files = files;
        if (this.collapseExpandButton != null) {
            this.collapseExpandButton.setText(Translator.get("nb_files", Integer.toString(files.size())));
        }
    }
}

