/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.text.CustomDateFormat;
import com.mucommander.text.SizeFormat;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.QuestionDialog;
import com.mucommander.ui.layout.InformationPane;
import com.mucommander.ui.layout.XAlignedComponentPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.notifier.AbstractNotifier;
import com.mucommander.ui.notifier.NotificationType;
import com.mucommander.ui.text.FileLabel;
import com.mucommander.ui.text.FontUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.Date;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;

public class FileCollisionDialog
extends QuestionDialog {
    public static final String CANCEL_TEXT = Translator.get("cancel", new String[0]);
    public static final String SKIP_TEXT = Translator.get("skip", new String[0]);
    public static final String OVERWRITE_TEXT = Translator.get("overwrite", new String[0]);
    public static final String OVERWRITE_IF_OLDER_TEXT = Translator.get("overwrite_if_older", new String[0]);
    public static final String RESUME_TEXT = Translator.get("resume", new String[0]);
    public static final String RENAME_TEXT = Translator.get("rename", new String[0]);
    private JCheckBox applyToAllCheckBox;

    public FileCollisionDialog(Dialog owner, Component locationRelative, int collisionType, AbstractFile sourceFile, AbstractFile destFile, boolean multipleFilesMode, boolean allowRename) {
        super(owner, Translator.get("file_collision_dialog.title", new String[0]), locationRelative);
        this.init(collisionType, sourceFile, destFile, multipleFilesMode, allowRename);
    }

    public FileCollisionDialog(Frame owner, Component locationRelative, int collisionType, AbstractFile sourceFile, AbstractFile destFile, boolean multipleFilesMode, boolean allowRename) {
        super(owner, Translator.get("file_collision_dialog.title", new String[0]), locationRelative);
        this.init(collisionType, sourceFile, destFile, multipleFilesMode, allowRename);
    }

    private void init(int collisionType, AbstractFile sourceFile, AbstractFile destFile, boolean multipleFilesMode, boolean allowRename) {
        Vector<String> choicesTextV = new Vector<String>();
        Vector<Integer> choicesActionsV = new Vector<Integer>();
        choicesTextV.add(CANCEL_TEXT);
        choicesActionsV.add(0);
        if (multipleFilesMode) {
            choicesTextV.add(SKIP_TEXT);
            choicesActionsV.add(1);
        }
        if (collisionType == 1 && !destFile.isDirectory()) {
            choicesTextV.add(OVERWRITE_TEXT);
            choicesActionsV.add(2);
            if (sourceFile != null) {
                choicesTextV.add(OVERWRITE_IF_OLDER_TEXT);
                choicesActionsV.add(3);
                long destSize = destFile.getSize();
                long sourceSize = sourceFile.getSize();
                if (destSize != -1L && (sourceSize == -1L || destSize < sourceSize)) {
                    choicesTextV.add(RESUME_TEXT);
                    choicesActionsV.add(4);
                }
                if (allowRename) {
                    choicesTextV.add(RENAME_TEXT);
                    choicesActionsV.add(5);
                }
            }
        }
        int nbChoices = choicesActionsV.size();
        String[] choicesText = new String[nbChoices];
        choicesTextV.toArray(choicesText);
        int[] choicesActions = new int[nbChoices];
        for (int i = 0; i < nbChoices; ++i) {
            choicesActions[i] = (Integer)choicesActionsV.get(i);
        }
        String desc = collisionType == 1 ? Translator.get("file_exists_in_destination", new String[0]) : (collisionType == 2 ? Translator.get("same_source_destination", new String[0]) : (collisionType == 3 ? Translator.get("source_parent_of_destination", new String[0]) : null));
        YBoxPanel yPanel = new YBoxPanel();
        if (desc != null) {
            yPanel.add(new InformationPane(desc, null, 0, 4));
            yPanel.addSpace(10);
        }
        yPanel.add(new JSeparator());
        XAlignedComponentPanel tfPanel = new XAlignedComponentPanel(10);
        if (collisionType == 2) {
            this.addFileDetails(tfPanel, sourceFile, Translator.get("name", new String[0]));
        } else {
            if (sourceFile != null) {
                this.addFileDetails(tfPanel, sourceFile, Translator.get("source", new String[0]));
            }
            this.addFileDetails(tfPanel, destFile, Translator.get("destination", new String[0]));
        }
        yPanel.add(tfPanel);
        yPanel.add(new JSeparator());
        this.init(yPanel, choicesText, choicesActions, 3);
        if (multipleFilesMode && collisionType == 1) {
            this.applyToAllCheckBox = new JCheckBox(Translator.get("apply_to_all", new String[0]));
            this.addComponent(this.applyToAllCheckBox);
        }
        if (AbstractNotifier.isAvailable() && AbstractNotifier.getNotifier().isEnabled()) {
            AbstractNotifier.getNotifier().displayBackgroundNotification(NotificationType.JOB_ERROR, this.getTitle(), desc);
        }
    }

    private void addFileDetails(XAlignedComponentPanel panel, AbstractFile file, String nameLabel) {
        this.addFileDetailsRow(panel, nameLabel + ":", new FileLabel(file, false), 0);
        AbstractFile parent = file.getParent();
        this.addFileDetailsRow(panel, Translator.get("location", new String[0]) + ":", new FileLabel(parent == null ? file : parent, true), 0);
        this.addFileDetailsRow(panel, Translator.get("size", new String[0]) + ":", new JLabel(SizeFormat.format(file.getSize(), 84)), 0);
        this.addFileDetailsRow(panel, Translator.get("date", new String[0]) + ":", new JLabel(CustomDateFormat.format(new Date(file.getDate()))), 0);
        this.addFileDetailsRow(panel, Translator.get("permissions", new String[0]) + ":", new JLabel(file.getPermissionsString()), 10);
    }

    private void addFileDetailsRow(XAlignedComponentPanel panel, String label, JComponent comp, int ySpaceAfter) {
        panel.addRow(FontUtils.makeMini(new JLabel(label)), FontUtils.makeMini(comp), ySpaceAfter);
    }

    public boolean applyToAllSelected() {
        return this.applyToAllCheckBox != null && this.applyToAllCheckBox.isSelected();
    }
}

