/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.job.SendMailJob;
import com.mucommander.text.SizeFormat;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.file.JobDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.dialog.pref.general.GeneralPreferencesDialog;
import com.mucommander.ui.layout.XAlignedComponentPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.MainFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class EmailFilesDialog
extends JobDialog
implements ActionListener,
ItemListener {
    private FileSet flattenedFiles;
    private JTextField toField;
    private JTextField subjectField;
    private JTextArea bodyArea;
    private JLabel infoLabel;
    private JCheckBox[] fileCheckboxes;
    private static String lastTo = "";
    private static String lastSubject = "";
    private static String lastBody = "";
    private JButton okButton;
    private JButton cancelButton;
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(400, 0);
    private static final Dimension MAXIMUM_DIALOG_DIMENSION = new Dimension(550, 400);

    public EmailFilesDialog(MainFrame mainFrame, FileSet files) {
        super(mainFrame, ActionProperties.getActionLabel("Email"), files);
        if (!SendMailJob.mailPreferencesSet()) {
            this.showErrorDialog(Translator.get("email_dialog.prefs_not_set", new String[0]), Translator.get("email_dialog.prefs_not_set_title", new String[0]));
            GeneralPreferencesDialog preferencesDialog = GeneralPreferencesDialog.getDialog();
            preferencesDialog.setActiveTab(3);
            preferencesDialog.showDialog();
            return;
        }
        try {
            this.flattenedFiles = this.getFlattenedFiles(files);
            Container contentPane = this.getContentPane();
            YBoxPanel mainPanel = new YBoxPanel(5);
            XAlignedComponentPanel compPanel = new XAlignedComponentPanel();
            JLabel fromLabel = new JLabel(MuConfigurations.getPreferences().getVariable(MuPreference.MAIL_SENDER_NAME) + " <" + MuConfigurations.getPreferences().getVariable(MuPreference.MAIL_SENDER_ADDRESS) + ">");
            compPanel.addRow(Translator.get("email_dialog.from", new String[0]) + ":", (JComponent)fromLabel, 10);
            this.toField = new JTextField(lastTo);
            compPanel.addRow(Translator.get("email_dialog.to", new String[0]) + ":", (JComponent)this.toField, 10);
            this.subjectField = new JTextField(lastSubject);
            compPanel.addRow(Translator.get("email_dialog.subject", new String[0]) + ":", (JComponent)this.subjectField, 15);
            mainPanel.add(compPanel);
            this.bodyArea = new JTextArea(lastBody);
            this.bodyArea.setRows(6);
            this.bodyArea.setLineWrap(true);
            JScrollPane scrollPane = new JScrollPane(this.bodyArea, 20, 31);
            mainPanel.add(scrollPane);
            mainPanel.addSpace(15);
            this.infoLabel = new JLabel();
            mainPanel.add(this.infoLabel);
            contentPane.add((Component)mainPanel, "North");
            int nbFiles = this.flattenedFiles.size();
            this.fileCheckboxes = new JCheckBox[nbFiles];
            if (nbFiles > 0) {
                YBoxPanel tempPanel2 = new YBoxPanel();
                for (int i = 0; i < nbFiles; ++i) {
                    AbstractFile file = (AbstractFile)this.flattenedFiles.elementAt(i);
                    this.fileCheckboxes[i] = new JCheckBox(file.getName() + " (" + SizeFormat.format(file.getSize(), 202) + ")", true);
                    this.fileCheckboxes[i].addItemListener(this);
                    tempPanel2.add(this.fileCheckboxes[i]);
                }
                scrollPane = new JScrollPane(tempPanel2, 20, 30);
                contentPane.add((Component)scrollPane, "Center");
            }
            this.updateInfoLabel();
            this.okButton = new JButton(Translator.get("email_dialog.send", new String[0]));
            this.cancelButton = new JButton(Translator.get("cancel", new String[0]));
            contentPane.add((Component)DialogToolkit.createOKCancelPanel(this.okButton, this.cancelButton, this.getRootPane(), this), "South");
            this.setInitialFocusComponent(this.toField);
            this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
            this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
        }
        catch (IOException e) {
            this.showErrorDialog(Translator.get("email_dialog.read_error", new String[0]), Translator.get("email_dialog.error_title", new String[0]));
        }
    }

    private void updateInfoLabel() {
        int nbFiles = this.fileCheckboxes.length;
        int nbSelected = 0;
        int bytesTotal = 0;
        for (int i = 0; i < nbFiles; ++i) {
            if (!this.fileCheckboxes[i].isSelected()) continue;
            long fileSize = ((AbstractFile)this.flattenedFiles.elementAt(i)).getSize();
            if (fileSize > 0L) {
                bytesTotal = (int)((long)bytesTotal + fileSize);
            }
            ++nbSelected;
        }
        String text = Translator.get("nb_files", "" + nbSelected) + (nbSelected == 0 ? "" : " (" + SizeFormat.format(bytesTotal, 146) + ")");
        this.infoLabel.setText(text);
        this.infoLabel.repaint(100L);
    }

    private FileSet getFlattenedFiles(FileSet originalFiles) throws IOException {
        int nbFiles = originalFiles.size();
        FileSet flattenedFiles = new FileSet(originalFiles.getBaseFolder());
        for (int i = 0; i < nbFiles; ++i) {
            this.recurseOnFolder((AbstractFile)originalFiles.elementAt(i), flattenedFiles);
        }
        return flattenedFiles;
    }

    private void recurseOnFolder(AbstractFile file, FileSet flattenedFiles) throws IOException {
        if (file.isDirectory() && !file.isSymlink()) {
            AbstractFile[] children;
            for (AbstractFile child : children = file.ls()) {
                this.recurseOnFolder(child, flattenedFiles);
            }
        } else {
            flattenedFiles.add(file);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            String to = this.toField.getText().trim();
            String subject = this.subjectField.getText();
            String body = this.bodyArea.getText();
            if (!to.equals("")) {
                lastTo = to;
                lastSubject = subject;
                lastBody = body;
                this.dispose();
                FileSet filesToSend = new FileSet(this.flattenedFiles.getBaseFolder());
                int nbFiles = this.fileCheckboxes.length;
                for (int i = 0; i < nbFiles; ++i) {
                    if (!this.fileCheckboxes[i].isSelected()) continue;
                    filesToSend.add(this.flattenedFiles.elementAt(i));
                }
                ProgressDialog progressDialog = new ProgressDialog(this.mainFrame, Translator.get("email_dialog.sending", new String[0]));
                SendMailJob mailJob = new SendMailJob(progressDialog, this.mainFrame, filesToSend, to, subject, body);
                progressDialog.start(mailJob);
            }
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.updateInfoLabel();
    }
}

